/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public abstract class CompactArray<T>
implements JmeCloneable {
    protected Map<T, Integer> indexPool = new HashMap<T, Integer>();
    protected int[] index;
    protected float[] array;
    private boolean invalid;

    public CompactArray() {
    }

    public CompactArray(float[] compressedArray, int[] index) {
        this.array = compressedArray;
        this.index = index;
    }

    public void add(T ... objArray) {
        if (objArray == null || objArray.length == 0) {
            return;
        }
        this.invalid = true;
        int base = 0;
        if (this.index == null) {
            this.index = new int[objArray.length];
        } else {
            if (this.indexPool.isEmpty()) {
                throw new RuntimeException("Internal is already fixed");
            }
            base = this.index.length;
            int[] tmp = new int[base + objArray.length];
            System.arraycopy(this.index, 0, tmp, 0, this.index.length);
            this.index = tmp;
        }
        for (int j = 0; j < objArray.length; ++j) {
            T obj = objArray[j];
            if (obj == null) {
                this.index[base + j] = -1;
                continue;
            }
            Integer i = this.indexPool.get(obj);
            if (i == null) {
                i = this.indexPool.size();
                this.indexPool.put(obj, i);
            }
            this.index[base + j] = i;
        }
    }

    public void freeze() {
        this.serialize();
        this.indexPool.clear();
    }

    protected void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public final void set(int index, T value) {
        int j = this.getCompactIndex(index);
        this.serialize(j, value);
    }

    public final T get(int index, T store) {
        this.serialize();
        int j = this.getCompactIndex(index);
        return this.deserialize(j, store);
    }

    public final float[] getSerializedData() {
        this.serialize();
        return this.array;
    }

    public final void serialize() {
        if (this.invalid) {
            int newSize = this.indexPool.size() * this.getTupleSize();
            if (this.array == null || Array.getLength(this.array) < newSize) {
                this.array = this.ensureCapacity(this.array, newSize);
                for (Map.Entry<T, Integer> entry : this.indexPool.entrySet()) {
                    int i = entry.getValue();
                    T obj = entry.getKey();
                    this.serialize(i, obj);
                }
            }
            this.invalid = false;
        }
    }

    protected final int getSerializedSize() {
        return Array.getLength(this.getSerializedData());
    }

    protected float[] ensureCapacity(float[] arr, int size) {
        if (arr == null) {
            return new float[size];
        }
        if (arr.length >= size) {
            return arr;
        }
        float[] tmp = new float[size];
        System.arraycopy(arr, 0, tmp, 0, arr.length);
        return tmp;
    }

    public final int[] getIndex(T ... objArray) {
        int[] index = new int[objArray.length];
        for (int i = 0; i < index.length; ++i) {
            T obj = objArray[i];
            index[i] = obj != null ? this.indexPool.get(obj) : -1;
        }
        return index;
    }

    public int getCompactIndex(int objIndex) {
        return this.index != null ? this.index[objIndex] : objIndex;
    }

    public final int getTotalObjectSize() {
        assert (this.getSerializedSize() % this.getTupleSize() == 0);
        return this.index != null ? this.index.length : this.getSerializedSize() / this.getTupleSize();
    }

    public final int getCompactObjectSize() {
        assert (this.getSerializedSize() % this.getTupleSize() == 0);
        return this.getSerializedSize() / this.getTupleSize();
    }

    public final T[] toObjectArray() {
        try {
            Object[] compactArr = (Object[])Array.newInstance(this.getElementClass(), this.getSerializedSize() / this.getTupleSize());
            for (int i = 0; i < compactArr.length; ++i) {
                compactArr[i] = this.getElementClass().newInstance();
                this.deserialize(i, compactArr[i]);
            }
            Object[] objArr = (Object[])Array.newInstance(this.getElementClass(), this.getTotalObjectSize());
            for (int i = 0; i < objArr.length; ++i) {
                int compactIndex = this.getCompactIndex(i);
                objArr[i] = compactArr[compactIndex];
            }
            return objArr;
        }
        catch (Exception e) {
            return null;
        }
    }

    public CompactArray clone() throws CloneNotSupportedException {
        return Cloner.deepClone(this);
    }

    @Override
    public Object jmeClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException("Can't clone array", exception);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.indexPool = cloner.clone(this.indexPool);
        this.index = cloner.clone(this.index);
        this.array = cloner.clone(this.array);
    }

    protected abstract void serialize(int var1, T var2);

    protected abstract T deserialize(int var1, T var2);

    protected abstract int getTupleSize();

    protected abstract Class<T> getElementClass();
}

