/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.util.NativeObjectManager;

public abstract class NativeObject
implements Cloneable {
    public static final int INVALID_ID = -1;
    protected static final int OBJTYPE_VERTEXBUFFER = 1;
    protected static final int OBJTYPE_TEXTURE = 2;
    protected static final int OBJTYPE_FRAMEBUFFER = 3;
    protected static final int OBJTYPE_SHADER = 4;
    protected static final int OBJTYPE_SHADERSOURCE = 5;
    protected static final int OBJTYPE_AUDIOBUFFER = 6;
    protected static final int OBJTYPE_AUDIOSTREAM = 7;
    protected static final int OBJTYPE_FILTER = 8;
    protected static final int OBJTYPE_BO = 9;
    protected NativeObjectManager objectManager = null;
    protected int id = -1;
    protected Object handleRef = null;
    protected boolean updateNeeded = true;

    public NativeObject() {
        this.handleRef = new Object();
    }

    protected NativeObject(int id) {
        this.id = id;
    }

    void setNativeObjectManager(NativeObjectManager objectManager) {
        this.objectManager = objectManager;
    }

    public void setId(int id) {
        if (this.id != -1) {
            throw new IllegalStateException("ID has already been set for this GL object.");
        }
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setUpdateNeeded() {
        this.updateNeeded = true;
    }

    public void clearUpdateNeeded() {
        this.updateNeeded = false;
    }

    public boolean isUpdateNeeded() {
        return this.updateNeeded;
    }

    public String toString() {
        return "Native" + this.getClass().getSimpleName() + " " + this.id;
    }

    protected NativeObject clone() {
        try {
            NativeObject obj = (NativeObject)super.clone();
            obj.handleRef = new Object();
            obj.objectManager = null;
            obj.id = -1;
            obj.updateNeeded = true;
            return obj;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    protected void deleteNativeBuffers() {
    }

    void deleteNativeBuffersInternal() {
        this.deleteNativeBuffers();
    }

    public abstract void resetObject();

    public abstract void deleteObject(Object var1);

    public abstract NativeObject createDestructableClone();

    public abstract long getUniqueId();

    public void dispose() {
        if (this.objectManager != null) {
            this.objectManager.enqueueUnusedObject(this);
        }
    }
}

