/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.UrlAssetInfo;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.Trigger;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.RendererException;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaterialDebugAppState
extends AbstractAppState {
    private RenderManager renderManager;
    private AssetManager assetManager;
    private InputManager inputManager;
    private List<Binding> bindings = new ArrayList<Binding>();
    private Map<Trigger, List<Binding>> fileTriggers = new HashMap<Trigger, List<Binding>>();

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        this.renderManager = app.getRenderManager();
        this.assetManager = app.getAssetManager();
        this.inputManager = app.getInputManager();
        for (Binding binding : this.bindings) {
            this.bind(binding);
        }
        super.initialize(stateManager, app);
    }

    public void registerBinding(Trigger trigger, Spatial spat) {
        if (spat instanceof Geometry) {
            GeometryBinding binding = new GeometryBinding(trigger, (Geometry)spat);
            this.bindings.add(binding);
            if (this.isInitialized()) {
                this.bind(binding);
            }
        } else if (spat instanceof Node) {
            for (Spatial child : ((Node)spat).getChildren()) {
                this.registerBinding(trigger, child);
            }
        }
    }

    public void registerBinding(Trigger trigger, Filter filter) {
        FilterBinding binding = new FilterBinding(trigger, filter);
        this.bindings.add(binding);
        if (this.isInitialized()) {
            this.bind(binding);
        }
    }

    public void registerBinding(String shaderName, Filter filter) {
        this.registerBinding((Trigger)new FileChangedTrigger(shaderName), filter);
    }

    public void registerBinding(String shaderName, Spatial spat) {
        this.registerBinding((Trigger)new FileChangedTrigger(shaderName), spat);
    }

    private void bind(final Binding binding) {
        if (binding.getTrigger() instanceof FileChangedTrigger) {
            FileChangedTrigger t = (FileChangedTrigger)binding.getTrigger();
            List<Binding> b = this.fileTriggers.get(t);
            if (b == null) {
                t.init();
                b = new ArrayList<Binding>();
                this.fileTriggers.put(t, b);
            }
            b.add(binding);
        } else {
            final String actionName = binding.getActionName();
            this.inputManager.addListener(new ActionListener(){

                @Override
                public void onAction(String name, boolean isPressed, float tpf) {
                    if (actionName.equals(name) && isPressed) {
                        binding.reload();
                    }
                }
            }, actionName);
            this.inputManager.addMapping(actionName, binding.getTrigger());
        }
    }

    public Material reloadMaterial(Material mat) {
        this.assetManager.clearCache();
        Material dummy = new Material(this.assetManager, mat.getMaterialDef().getAssetName());
        for (MatParam matParam : mat.getParams()) {
            dummy.setParam(matParam.getName(), matParam.getVarType(), matParam.getValue());
        }
        dummy.getAdditionalRenderState().set(mat.getAdditionalRenderState());
        Geometry dummyGeom = new Geometry("dummyGeom", new Box(1.0f, 1.0f, 1.0f));
        dummyGeom.setMaterial(dummy);
        try {
            this.renderManager.preloadScene(dummyGeom);
        }
        catch (RendererException e) {
            Logger.getLogger(MaterialDebugAppState.class.getName()).log(Level.SEVERE, e.getMessage());
            return null;
        }
        Logger.getLogger(MaterialDebugAppState.class.getName()).log(Level.INFO, "Material succesfully reloaded");
        return dummy;
    }

    @Override
    public void update(float tpf) {
        super.update(tpf);
        for (Trigger trigger : this.fileTriggers.keySet()) {
            FileChangedTrigger t;
            if (!(trigger instanceof FileChangedTrigger) || !(t = (FileChangedTrigger)trigger).shouldFire()) continue;
            List<Binding> b = this.fileTriggers.get(t);
            for (Binding binding : b) {
                binding.reload();
            }
        }
    }

    private class FileChangedTrigger
    implements Trigger {
        String fileName;
        File file;
        Long fileLastM;

        public FileChangedTrigger(String fileName) {
            this.fileName = fileName;
        }

        public void init() {
            AssetInfo info = MaterialDebugAppState.this.assetManager.locateAsset(new AssetKey(this.fileName));
            if (info != null && info instanceof UrlAssetInfo) {
                try {
                    Field f = info.getClass().getDeclaredField("url");
                    f.setAccessible(true);
                    URL url = (URL)f.get(info);
                    this.file = new File(url.getFile());
                    this.fileLastM = this.file.lastModified();
                }
                catch (NoSuchFieldException ex) {
                    Logger.getLogger(MaterialDebugAppState.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SecurityException ex) {
                    Logger.getLogger(MaterialDebugAppState.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(MaterialDebugAppState.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(MaterialDebugAppState.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        public boolean shouldFire() {
            if (this.file.lastModified() != this.fileLastM.longValue()) {
                this.fileLastM = this.file.lastModified();
                return true;
            }
            return false;
        }

        @Override
        public String getName() {
            return this.fileName;
        }

        @Override
        public int triggerHashCode() {
            return 0;
        }
    }

    private class FilterBinding
    implements Binding {
        Trigger trigger;
        Filter filter;

        public FilterBinding(Trigger trigger, Filter filter) {
            this.trigger = trigger;
            this.filter = filter;
        }

        @Override
        public void reload() {
            Field[] fields1 = this.filter.getClass().getDeclaredFields();
            Field[] fields2 = this.filter.getClass().getSuperclass().getDeclaredFields();
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.addAll(Arrays.asList(fields1));
            fields.addAll(Arrays.asList(fields2));
            Material m = new Material();
            Filter.Pass p = new Filter.Pass(this.filter);
            try {
                for (Field field : fields) {
                    Material mat;
                    if (field.getType().isInstance(m)) {
                        field.setAccessible(true);
                        mat = MaterialDebugAppState.this.reloadMaterial((Material)field.get(this.filter));
                        if (mat == null) {
                            return;
                        }
                        field.set(this.filter, mat);
                    }
                    if (field.getType().isInstance(p)) {
                        field.setAccessible(true);
                        p = (Filter.Pass)field.get(this.filter);
                        if (p != null && p.getPassMaterial() != null) {
                            mat = MaterialDebugAppState.this.reloadMaterial(p.getPassMaterial());
                            if (mat == null) {
                                return;
                            }
                            p.setPassMaterial(mat);
                        }
                    }
                    if (!field.getName().equals("postRenderPasses")) continue;
                    field.setAccessible(true);
                    List passes = new ArrayList();
                    passes = (List)field.get(this.filter);
                    if (passes == null) continue;
                    for (Filter.Pass pass : passes) {
                        Material mat2 = MaterialDebugAppState.this.reloadMaterial(pass.getPassMaterial());
                        if (mat2 == null) {
                            return;
                        }
                        pass.setPassMaterial(mat2);
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(MaterialDebugAppState.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(MaterialDebugAppState.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public String getActionName() {
            return this.filter.getName() + "Reload";
        }

        @Override
        public Trigger getTrigger() {
            return this.trigger;
        }
    }

    private class GeometryBinding
    implements Binding {
        Trigger trigger;
        Geometry geom;

        public GeometryBinding(Trigger trigger, Geometry geom) {
            this.trigger = trigger;
            this.geom = geom;
        }

        @Override
        public void reload() {
            Material reloadedMat = MaterialDebugAppState.this.reloadMaterial(this.geom.getMaterial());
            if (reloadedMat != null) {
                this.geom.setMaterial(reloadedMat);
            }
        }

        @Override
        public String getActionName() {
            return this.geom.getName() + "Reload";
        }

        @Override
        public Trigger getTrigger() {
            return this.trigger;
        }
    }

    private static interface Binding {
        public String getActionName();

        public void reload();

        public Trigger getTrigger();
    }
}

