/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.cache.AssetCache;
import com.jme3.shader.plugins.ShaderAssetKey;
import com.jme3.shader.plugins.ShaderDependencyNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GLSLLoader
implements AssetLoader {
    private AssetManager assetManager;
    private Map<String, ShaderDependencyNode> dependCache = new HashMap<String, ShaderDependencyNode>();

    private ShaderDependencyNode loadNode(Reader reader, String nodeName) {
        ShaderDependencyNode node = new ShaderDependencyNode(nodeName);
        StringBuilder sb = new StringBuilder();
        StringBuilder sbExt = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String ln;
            if (!nodeName.equals("[main]")) {
                sb.append("// -- begin import ").append(nodeName).append(" --\n");
            }
            while ((ln = bufferedReader.readLine()) != null) {
                if (ln.trim().startsWith("#import ")) {
                    if (!(ln = ln.trim().substring(8).trim()).startsWith("\"") || !ln.endsWith("\"") || ln.length() <= 3) continue;
                    if ((ln = ln.substring(1, ln.length() - 1)).equals(nodeName)) {
                        throw new IOException("Node depends on itself.");
                    }
                    ShaderDependencyNode dependNode = this.dependCache.get(ln);
                    if (dependNode == null) {
                        Reader dependNodeReader = this.assetManager.loadAsset(new ShaderDependencyKey(ln));
                        dependNode = this.loadNode(dependNodeReader, ln);
                    }
                    node.addDependency(sb.length(), dependNode);
                    continue;
                }
                if (ln.trim().startsWith("#extension ")) {
                    sbExt.append(ln).append('\n');
                    continue;
                }
                sb.append(ln).append('\n');
            }
            if (!nodeName.equals("[main]")) {
                sb.append("// -- end import ").append(nodeName).append(" --\n");
            }
        }
        catch (IOException ex) {
            throw new AssetLoadException("Failed to load shader node: " + nodeName, ex);
        }
        node.setSource(sb.toString());
        node.setExtensions(sbExt.toString());
        this.dependCache.put(nodeName, node);
        return node;
    }

    private ShaderDependencyNode nextIndependentNode() throws IOException {
        Collection<ShaderDependencyNode> allNodes = this.dependCache.values();
        if (allNodes.isEmpty()) {
            return null;
        }
        for (ShaderDependencyNode node : allNodes) {
            if (!node.getDependOnMe().isEmpty()) continue;
            return node;
        }
        for (ShaderDependencyNode node : allNodes) {
            System.out.println(node.getName());
        }
        throw new IOException("Circular dependency.");
    }

    private String resolveDependencies(ShaderDependencyNode node, Set<ShaderDependencyNode> alreadyInjectedSet, StringBuilder extensions, boolean injectDependencies) {
        if (alreadyInjectedSet.contains(node)) {
            return "// " + node.getName() + " was already injected at the top.\n";
        }
        alreadyInjectedSet.add(node);
        if (!node.getExtensions().isEmpty()) {
            extensions.append(node.getExtensions());
        }
        if (node.getDependencies().isEmpty()) {
            return node.getSource();
        }
        if (injectDependencies) {
            StringBuilder sb = new StringBuilder(node.getSource());
            ArrayList<String> resolvedShaderNodes = new ArrayList<String>();
            for (ShaderDependencyNode dependencyNode : node.getDependencies()) {
                resolvedShaderNodes.add(this.resolveDependencies(dependencyNode, alreadyInjectedSet, extensions, injectDependencies));
            }
            List<Integer> injectIndices = node.getDependencyInjectIndices();
            for (int i = resolvedShaderNodes.size() - 1; i >= 0; --i) {
                sb.insert((int)injectIndices.get(i), (String)resolvedShaderNodes.get(i));
            }
            return sb.toString();
        }
        for (ShaderDependencyNode dependencyNode : node.getDependencies()) {
            this.resolveDependencies(dependencyNode, alreadyInjectedSet, extensions, injectDependencies);
        }
        return null;
    }

    @Override
    public Object load(AssetInfo info) throws IOException {
        this.assetManager = info.getManager();
        InputStreamReader reader = new InputStreamReader(info.openStream());
        boolean injectDependencies = true;
        if (info.getKey() instanceof ShaderAssetKey) {
            injectDependencies = ((ShaderAssetKey)info.getKey()).isInjectDependencies();
        }
        if (info.getKey().getExtension().equals("glsllib") || info.getKey().getExtension().equals("glsl")) {
            return reader;
        }
        ShaderDependencyNode rootNode = this.loadNode(reader, "[main]");
        StringBuilder extensions = new StringBuilder();
        if (injectDependencies) {
            String code = this.resolveDependencies(rootNode, new HashSet<ShaderDependencyNode>(), extensions, injectDependencies);
            extensions.append(code);
            this.dependCache.clear();
            return extensions.toString();
        }
        LinkedHashMap<String, String> files = new LinkedHashMap<String, String>();
        HashSet<ShaderDependencyNode> dependencies = new HashSet<ShaderDependencyNode>();
        String code = this.resolveDependencies(rootNode, dependencies, extensions, injectDependencies);
        extensions.append(code);
        files.put("[main]", extensions.toString());
        for (ShaderDependencyNode dependency : dependencies) {
            files.put(dependency.getName(), dependency.getSource());
        }
        this.dependCache.clear();
        return files;
    }

    private class ShaderDependencyKey
    extends AssetKey<Reader> {
        public ShaderDependencyKey(String name) {
            super(name);
        }

        @Override
        public Class<? extends AssetCache> getCacheType() {
            return null;
        }
    }
}

