/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.shader.ShaderVariable;
import com.jme3.shader.UniformBinding;
import com.jme3.shader.VarType;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class Uniform
extends ShaderVariable {
    private static final Integer ZERO_INT = 0;
    private static final Float ZERO_FLT = Float.valueOf(0.0f);
    private static final FloatBuffer ZERO_BUF = BufferUtils.createFloatBuffer(16);
    protected Object value = null;
    protected FloatBuffer multiData = null;
    protected VarType varType;
    protected UniformBinding binding;
    protected boolean setByCurrentMaterial = false;

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 31 * hash + (this.varType != null ? this.varType.hashCode() : 0);
        hash = 31 * hash + (this.binding != null ? this.binding.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Uniform other = (Uniform)obj;
        if (!(this.value == other.value || this.value != null && this.value.equals(other.value))) {
            return false;
        }
        return this.binding == other.binding && this.varType == other.varType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Uniform[name=");
        sb.append(this.name);
        if (this.varType != null) {
            sb.append(", type=");
            sb.append((Object)this.varType);
            sb.append(", value=");
            sb.append(this.value);
        } else {
            sb.append(", value=<not set>");
        }
        sb.append("]");
        return sb.toString();
    }

    public void setBinding(UniformBinding binding) {
        this.binding = binding;
    }

    public UniformBinding getBinding() {
        return this.binding;
    }

    public VarType getVarType() {
        return this.varType;
    }

    public Object getValue() {
        return this.value;
    }

    public FloatBuffer getMultiData() {
        return this.multiData;
    }

    public boolean isSetByCurrentMaterial() {
        return this.setByCurrentMaterial;
    }

    public void clearSetByCurrentMaterial() {
        this.setByCurrentMaterial = false;
    }

    public void clearValue() {
        this.updateNeeded = true;
        if (this.multiData != null) {
            this.multiData.clear();
            while (this.multiData.remaining() > 0) {
                ZERO_BUF.clear();
                ZERO_BUF.limit(Math.min(this.multiData.remaining(), 16));
                this.multiData.put(ZERO_BUF);
            }
            this.multiData.clear();
            return;
        }
        if (this.varType == null) {
            return;
        }
        switch (this.varType) {
            case Int: {
                this.value = ZERO_INT;
                break;
            }
            case Boolean: {
                this.value = Boolean.FALSE;
                break;
            }
            case Float: {
                this.value = ZERO_FLT;
                break;
            }
            case Vector2: {
                if (this.value == null) break;
                ((Vector2f)this.value).set(Vector2f.ZERO);
                break;
            }
            case Vector3: {
                if (this.value == null) break;
                ((Vector3f)this.value).set(Vector3f.ZERO);
                break;
            }
            case Vector4: {
                if (this.value == null) break;
                if (this.value instanceof ColorRGBA) {
                    ((ColorRGBA)this.value).set(ColorRGBA.BlackNoAlpha);
                    break;
                }
                if (this.value instanceof Vector4f) {
                    ((Vector4f)this.value).set(Vector4f.ZERO);
                    break;
                }
                ((Quaternion)this.value).set(Quaternion.ZERO);
                break;
            }
        }
    }

    public void setValue(VarType type, Object value) {
        if (this.location == -1) {
            return;
        }
        if (this.varType != null && this.varType != type) {
            throw new IllegalArgumentException("Expected a " + this.varType.name() + " value!");
        }
        if (value == null) {
            throw new IllegalArgumentException("for uniform " + this.name + ": value cannot be null");
        }
        this.setByCurrentMaterial = true;
        switch (type) {
            case Matrix3: {
                if (value.equals(this.value)) {
                    return;
                }
                Matrix3f m3 = (Matrix3f)value;
                if (this.multiData == null) {
                    this.multiData = BufferUtils.createFloatBuffer(9);
                }
                m3.fillFloatBuffer(this.multiData, true);
                this.multiData.clear();
                if (this.value == null) {
                    this.value = new Matrix3f(m3);
                    break;
                }
                ((Matrix3f)this.value).set(m3);
                break;
            }
            case Matrix4: {
                if (value.equals(this.value)) {
                    return;
                }
                Matrix4f m4 = (Matrix4f)value;
                if (this.multiData == null) {
                    this.multiData = BufferUtils.createFloatBuffer(16);
                }
                m4.fillFloatBuffer(this.multiData, true);
                this.multiData.clear();
                if (this.value == null) {
                    this.value = new Matrix4f(m4);
                    break;
                }
                ((Matrix4f)this.value).copy(m4);
                break;
            }
            case IntArray: {
                int[] ia = (int[])value;
                this.value = this.value == null ? BufferUtils.createIntBuffer(ia) : BufferUtils.ensureLargeEnough((IntBuffer)this.value, ia.length);
                ((IntBuffer)this.value).clear();
                break;
            }
            case FloatArray: {
                float[] fa = (float[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(fa) : BufferUtils.ensureLargeEnough(this.multiData, fa.length);
                this.multiData.put(fa);
                this.multiData.clear();
                break;
            }
            case Vector2Array: {
                Vector2f[] v2a = (Vector2f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(v2a) : BufferUtils.ensureLargeEnough(this.multiData, v2a.length * 2);
                for (int i = 0; i < v2a.length; ++i) {
                    BufferUtils.setInBuffer(v2a[i], this.multiData, i);
                }
                this.multiData.clear();
                break;
            }
            case Vector3Array: {
                Vector3f[] v3a = (Vector3f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(v3a) : BufferUtils.ensureLargeEnough(this.multiData, v3a.length * 3);
                for (int i = 0; i < v3a.length; ++i) {
                    BufferUtils.setInBuffer(v3a[i], this.multiData, i);
                }
                this.multiData.clear();
                break;
            }
            case Vector4Array: {
                Vector4f[] v4a = (Vector4f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(v4a) : BufferUtils.ensureLargeEnough(this.multiData, v4a.length * 4);
                for (int i = 0; i < v4a.length; ++i) {
                    BufferUtils.setInBuffer(v4a[i], this.multiData, i);
                }
                this.multiData.clear();
                break;
            }
            case Matrix3Array: {
                Matrix3f[] m3a = (Matrix3f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(m3a.length * 9) : BufferUtils.ensureLargeEnough(this.multiData, m3a.length * 9);
                for (int i = 0; i < m3a.length; ++i) {
                    m3a[i].fillFloatBuffer(this.multiData, true);
                }
                this.multiData.clear();
                break;
            }
            case Matrix4Array: {
                Matrix4f[] m4a = (Matrix4f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(m4a.length * 16) : BufferUtils.ensureLargeEnough(this.multiData, m4a.length * 16);
                for (int i = 0; i < m4a.length; ++i) {
                    m4a[i].fillFloatBuffer(this.multiData, true);
                }
                this.multiData.clear();
                break;
            }
            case Vector2: {
                if (value.equals(this.value)) {
                    return;
                }
                if (this.value == null) {
                    this.value = new Vector2f((Vector2f)value);
                    break;
                }
                ((Vector2f)this.value).set((Vector2f)value);
                break;
            }
            case Vector3: {
                if (value.equals(this.value)) {
                    return;
                }
                if (this.value == null) {
                    this.value = new Vector3f((Vector3f)value);
                    break;
                }
                ((Vector3f)this.value).set((Vector3f)value);
                break;
            }
            case Vector4: {
                if (value.equals(this.value)) {
                    return;
                }
                TempVars vars = TempVars.get();
                Vector4f vec4 = vars.vect4f1;
                if (this.value == null) {
                    try {
                        this.value = value.getClass().newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Cannot instanciate param of class " + value.getClass().getCanonicalName());
                    }
                }
                if (value instanceof ColorRGBA) {
                    ColorRGBA c = (ColorRGBA)value;
                    vec4.set(c.r, c.g, c.b, c.a);
                } else if (value instanceof Vector4f) {
                    vec4.set((Vector4f)value);
                } else {
                    Quaternion q = (Quaternion)value;
                    vec4.set(q.getX(), q.getY(), q.getZ(), q.getW());
                }
                if (this.value instanceof ColorRGBA) {
                    ((ColorRGBA)this.value).set(vec4.x, vec4.y, vec4.z, vec4.w);
                } else if (this.value instanceof Vector4f) {
                    ((Vector4f)this.value).set(vec4);
                } else {
                    ((Quaternion)this.value).set(vec4.x, vec4.y, vec4.z, vec4.w);
                }
                vars.release();
                break;
            }
            case Int: 
            case Boolean: 
            case Float: {
                if (value.equals(this.value)) {
                    return;
                }
                this.value = value;
                break;
            }
            default: {
                this.value = value;
            }
        }
        this.varType = type;
        this.updateNeeded = true;
    }

    public void setVector4Length(int length) {
        if (this.location == -1) {
            return;
        }
        this.multiData = BufferUtils.ensureLargeEnough(this.multiData, length * 4);
        this.value = this.multiData;
        this.varType = VarType.Vector4Array;
        this.updateNeeded = true;
        this.setByCurrentMaterial = true;
    }

    public void setVector4InArray(float x, float y, float z, float w, int index) {
        if (this.location == -1) {
            return;
        }
        if (this.varType != null && this.varType != VarType.Vector4Array) {
            throw new IllegalArgumentException("Expected a " + this.varType.name() + " value!");
        }
        this.multiData.position(index * 4);
        this.multiData.put(x).put(y).put(z).put(w);
        this.multiData.rewind();
        this.updateNeeded = true;
        this.setByCurrentMaterial = true;
    }

    public boolean isUpdateNeeded() {
        return this.updateNeeded;
    }

    public void clearUpdateNeeded() {
        this.updateNeeded = false;
    }

    public void reset() {
        this.setByCurrentMaterial = false;
        this.location = -2;
        this.updateNeeded = true;
    }

    public void deleteNativeBuffers() {
        if (this.value instanceof Buffer) {
            BufferUtils.destroyDirectBuffer((Buffer)this.value);
            this.value = null;
        }
    }
}

