/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.mesh;

import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexByteBuffer;
import com.jme3.scene.mesh.IndexIntBuffer;
import com.jme3.scene.mesh.IndexShortBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public abstract class IndexBuffer {
    public static IndexBuffer wrapIndexBuffer(Buffer buf) {
        if (buf instanceof ByteBuffer) {
            return new IndexByteBuffer((ByteBuffer)buf);
        }
        if (buf instanceof ShortBuffer) {
            return new IndexShortBuffer((ShortBuffer)buf);
        }
        if (buf instanceof IntBuffer) {
            return new IndexIntBuffer((IntBuffer)buf);
        }
        throw new UnsupportedOperationException("Index buffer type unsupported: " + buf.getClass());
    }

    public static IndexBuffer createIndexBuffer(int vertexCount, int indexCount) {
        if (vertexCount < 128) {
            return new IndexByteBuffer(BufferUtils.createByteBuffer(indexCount));
        }
        if (vertexCount < 65536) {
            return new IndexShortBuffer(BufferUtils.createShortBuffer(indexCount));
        }
        return new IndexIntBuffer(BufferUtils.createIntBuffer(indexCount));
    }

    public void rewind() {
        this.getBuffer().rewind();
    }

    public int remaining() {
        return this.getBuffer().remaining();
    }

    public abstract int get();

    public abstract int get(int var1);

    public abstract IndexBuffer put(int var1, int var2);

    public abstract IndexBuffer put(int var1);

    public abstract int size();

    public abstract Buffer getBuffer();

    public abstract VertexBuffer.Format getFormat();
}

