/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug.custom;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.math.ColorRGBA;
import com.jme3.math.MathUtils;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.debug.custom.ArmatureInterJointsWire;
import com.jme3.scene.debug.custom.JointShape;
import com.jme3.scene.shape.Line;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArmatureNode
extends Node {
    public static final float PIXEL_BOX = 10.0f;
    private Armature armature;
    private Map<Joint, Geometry[]> jointToGeoms = new HashMap<Joint, Geometry[]>();
    private Map<Geometry, Joint> geomToJoint = new HashMap<Geometry, Joint>();
    private Joint selectedJoint = null;
    private Vector3f tmp = new Vector3f();
    private Vector2f tmpv2 = new Vector2f();
    private static final ColorRGBA selectedColor = ColorRGBA.Orange;
    private static final ColorRGBA selectedColorJ = ColorRGBA.Yellow;
    private static final ColorRGBA outlineColor = ColorRGBA.LightGray;
    private static final ColorRGBA baseColor = new ColorRGBA(0.05f, 0.05f, 0.05f, 1.0f);
    private Camera camera;

    public ArmatureNode(Armature armature, Node joints, Node wires, Node outlines, List<Joint> deformingJoints) {
        this.armature = armature;
        Geometry origin = new Geometry("Armature Origin", new JointShape());
        this.setColor(origin, ColorRGBA.Green);
        this.attach(joints, true, origin);
        for (Joint joint : armature.getRoots()) {
            this.createSkeletonGeoms(joint, joints, wires, outlines, deformingJoints);
        }
        this.updateModelBound();
    }

    protected final void createSkeletonGeoms(Joint joint, Node joints, Node wires, Node outlines, List<Joint> deformingJoints) {
        Vector3f start = joint.getModelTransform().getTranslation().clone();
        Vector3f[] ends = null;
        if (!joint.getChildren().isEmpty()) {
            ends = new Vector3f[joint.getChildren().size()];
        }
        for (int i = 0; i < joint.getChildren().size(); ++i) {
            ends[i] = joint.getChildren().get(i).getModelTransform().getTranslation().clone();
        }
        boolean deforms = deformingJoints.contains(joint);
        Geometry jGeom = new Geometry(joint.getName() + "Joint", new JointShape());
        jGeom.setLocalTranslation(start);
        this.attach(joints, deforms, jGeom);
        Geometry bGeom = null;
        Geometry bGeomO = null;
        if (ends == null) {
            this.geomToJoint.put(jGeom, joint);
        } else {
            Mesh m = null;
            Mesh mO = null;
            Node wireAttach = wires;
            Node outlinesAttach = outlines;
            if (ends.length == 1) {
                m = new Line(start, ends[0]);
                mO = new Line(start, ends[0]);
            } else {
                m = new ArmatureInterJointsWire(start, ends);
                mO = new ArmatureInterJointsWire(start, ends);
                wireAttach = (Node)wires.getChild(1);
                outlinesAttach = null;
            }
            bGeom = new Geometry(joint.getName() + "Bone", m);
            this.setColor(bGeom, outlinesAttach == null ? outlineColor : baseColor);
            this.geomToJoint.put(bGeom, joint);
            bGeom.setUserData("start", this.getWorldTransform().transformVector(start, start));
            for (int i = 0; i < ends.length; ++i) {
                this.getWorldTransform().transformVector(ends[i], ends[i]);
            }
            bGeom.setUserData("end", ends);
            bGeom.setQueueBucket(RenderQueue.Bucket.Transparent);
            this.attach(wireAttach, deforms, bGeom);
            if (outlinesAttach != null) {
                bGeomO = new Geometry(joint.getName() + "BoneOutline", mO);
                this.setColor(bGeomO, outlineColor);
                this.attach(outlinesAttach, deforms, bGeomO);
            }
        }
        this.jointToGeoms.put(joint, new Geometry[]{jGeom, bGeom, bGeomO});
        for (Joint child : joint.getChildren()) {
            this.createSkeletonGeoms(child, joints, wires, outlines, deformingJoints);
        }
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    private void attach(Node parent, boolean deforms, Geometry geom) {
        if (deforms) {
            parent.attachChild(geom);
        } else {
            ((Node)parent.getChild(0)).attachChild(geom);
        }
    }

    protected Joint select(Geometry g) {
        if (g == null) {
            this.resetSelection();
            return null;
        }
        Joint j = this.geomToJoint.get(g);
        if (j != null) {
            if (this.selectedJoint == j) {
                return null;
            }
            this.resetSelection();
            this.selectedJoint = j;
            Geometry[] geomArray = this.jointToGeoms.get(this.selectedJoint);
            this.setColor(geomArray[0], selectedColorJ);
            if (geomArray[1] != null) {
                this.setColor(geomArray[1], selectedColor);
            }
            if (geomArray[2] != null) {
                this.setColor(geomArray[2], baseColor);
            }
            return j;
        }
        return null;
    }

    private void resetSelection() {
        if (this.selectedJoint == null) {
            return;
        }
        Geometry[] geoms = this.jointToGeoms.get(this.selectedJoint);
        this.setColor(geoms[0], ColorRGBA.White);
        if (geoms[1] != null) {
            this.setColor(geoms[1], geoms[2] == null ? outlineColor : baseColor);
        }
        if (geoms[2] != null) {
            this.setColor(geoms[2], outlineColor);
        }
        this.selectedJoint = null;
    }

    protected Joint getSelectedJoint() {
        return this.selectedJoint;
    }

    protected final void updateSkeletonGeoms(Joint joint) {
        Geometry[] geoms = this.jointToGeoms.get(joint);
        if (geoms != null) {
            Geometry jGeom = geoms[0];
            jGeom.setLocalTranslation(joint.getModelTransform().getTranslation());
            Geometry bGeom = geoms[1];
            if (bGeom != null) {
                Vector3f start = (Vector3f)bGeom.getUserData("start");
                Vector3f[] ends = (Vector3f[])bGeom.getUserData("end");
                start.set(joint.getModelTransform().getTranslation());
                if (ends != null) {
                    for (int i = 0; i < joint.getChildren().size(); ++i) {
                        ends[i].set(joint.getChildren().get(i).getModelTransform().getTranslation());
                    }
                    this.updateBoneMesh(bGeom, start, ends);
                    Geometry bGeomO = geoms[2];
                    if (bGeomO != null) {
                        this.updateBoneMesh(bGeomO, start, ends);
                    }
                    bGeom.setUserData("start", this.getWorldTransform().transformVector(start, start));
                    for (int i = 0; i < ends.length; ++i) {
                        this.getWorldTransform().transformVector(ends[i], ends[i]);
                    }
                    bGeom.setUserData("end", ends);
                }
            }
        }
        for (Joint child : joint.getChildren()) {
            this.updateSkeletonGeoms(child);
        }
    }

    public int pick(Vector2f cursor, CollisionResults results) {
        for (Geometry g : this.geomToJoint.keySet()) {
            if (!(g.getMesh() instanceof JointShape)) continue;
            this.camera.getScreenCoordinates(g.getWorldTranslation(), this.tmp);
            if (!(cursor.x <= this.tmp.x + 10.0f) || !(cursor.x >= this.tmp.x - 10.0f) || !(cursor.y <= this.tmp.y + 10.0f) || !(cursor.y >= this.tmp.y - 10.0f)) continue;
            CollisionResult res = new CollisionResult();
            res.setGeometry(g);
            results.addCollision(res);
        }
        return 0;
    }

    @Override
    public int collideWith(Collidable other, CollisionResults results) {
        if (!(other instanceof Ray)) {
            return 0;
        }
        this.camera.getScreenCoordinates(((Ray)other).getOrigin(), this.tmp);
        this.tmpv2.x = this.tmp.x;
        this.tmpv2.y = this.tmp.y;
        int nbHit = this.pick(this.tmpv2, results);
        if (nbHit > 0) {
            return nbHit;
        }
        for (Geometry g : this.geomToJoint.keySet()) {
            if (g.getMesh() instanceof JointShape) continue;
            Vector3f start = (Vector3f)g.getUserData("start");
            Vector3f[] ends = (Vector3f[])g.getUserData("end");
            for (int i = 0; i < ends.length; ++i) {
                float len = MathUtils.raySegmentShortestDistance((Ray)other, start, ends[i], this.camera);
                if (!(len > 0.0f) || !(len < 10.0f)) continue;
                CollisionResult res = new CollisionResult();
                res.setGeometry(g);
                results.addCollision(res);
                ++nbHit;
            }
        }
        return nbHit;
    }

    private void updateBoneMesh(Geometry geom, Vector3f start, Vector3f[] ends) {
        if (geom.getMesh() instanceof ArmatureInterJointsWire) {
            ((ArmatureInterJointsWire)geom.getMesh()).updatePoints(start, ends);
        } else if (geom.getMesh() instanceof Line) {
            ((Line)geom.getMesh()).updatePoints(start, ends[0]);
        }
        geom.updateModelBound();
    }

    private void setColor(Geometry g, ColorRGBA color) {
        float[] colors = new float[g.getMesh().getVertexCount() * 4];
        for (int i = 0; i < g.getMesh().getVertexCount() * 4; i += 4) {
            colors[i] = color.r;
            colors[i + 1] = color.g;
            colors[i + 2] = color.b;
            colors[i + 3] = color.a;
        }
        VertexBuffer colorBuff = g.getMesh().getBuffer(VertexBuffer.Type.Color);
        if (colorBuff == null) {
            g.getMesh().setBuffer(VertexBuffer.Type.Color, 4, colors);
        } else {
            FloatBuffer cBuff = (FloatBuffer)colorBuff.getData();
            cBuff.rewind();
            cBuff.put(colors);
            colorBuff.updateData(cBuff);
        }
    }

    public void updateGeometry() {
        this.armature.update();
        for (Joint joint : this.armature.getRoots()) {
            this.updateSkeletonGeoms(joint);
        }
    }
}

