/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug.custom;

import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.nio.FloatBuffer;

public class ArmatureInterJointsWire
extends Mesh {
    private Vector3f tmp = new Vector3f();

    public ArmatureInterJointsWire(Vector3f start, Vector3f[] ends) {
        this.setMode(Mesh.Mode.Lines);
        this.updateGeometry(start, ends);
    }

    protected void updateGeometry(Vector3f start, Vector3f[] ends) {
        int index;
        float[] pos = new float[ends.length * 3 + 3];
        pos[0] = start.x;
        pos[1] = start.y;
        pos[2] = start.z;
        for (int i = 0; i < ends.length; ++i) {
            index = i * 3 + 3;
            pos[index] = ends[i].x;
            pos[index + 1] = ends[i].y;
            pos[index + 2] = ends[i].z;
        }
        this.setBuffer(VertexBuffer.Type.Position, 3, pos);
        float[] texCoord = new float[ends.length * 2 + 2];
        texCoord[0] = 0.0f;
        texCoord[1] = 0.0f;
        for (int i = 0; i < ends.length * 2; ++i) {
            texCoord[i + 2] = this.tmp.set(start).subtractLocal(ends[i / 2]).length();
        }
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, texCoord);
        float[] normal = new float[ends.length * 3 + 3];
        for (int i = 0; i < ends.length * 3 + 3; i += 3) {
            normal[i] = start.x;
            normal[i + 1] = start.y;
            normal[i + 2] = start.z;
        }
        this.setBuffer(VertexBuffer.Type.Normal, 3, normal);
        short[] id = new short[ends.length * 2];
        index = 1;
        for (int i = 0; i < ends.length * 2; i += 2) {
            id[i] = 0;
            id[i + 1] = (short)index;
            ++index;
        }
        this.setBuffer(VertexBuffer.Type.Index, 2, id);
        this.updateBound();
    }

    public void updatePoints(Vector3f start, Vector3f[] ends) {
        VertexBuffer posBuf = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fb = (FloatBuffer)posBuf.getData();
        fb.rewind();
        fb.put(start.x).put(start.y).put(start.z);
        for (int i = 0; i < ends.length; ++i) {
            fb.put(ends[i].x);
            fb.put(ends[i].y);
            fb.put(ends[i].z);
        }
        posBuf.updateData(fb);
        VertexBuffer normBuf = this.getBuffer(VertexBuffer.Type.Normal);
        fb = (FloatBuffer)normBuf.getData();
        fb.rewind();
        for (int i = 0; i < ends.length * 3 + 3; i += 3) {
            fb.put(start.x);
            fb.put(start.y);
            fb.put(start.z);
        }
        normBuf.updateData(fb);
    }
}

