/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.opengl;

import com.jme3.renderer.Caps;
import com.jme3.renderer.RendererException;
import com.jme3.renderer.opengl.GL;
import com.jme3.renderer.opengl.GL2;
import com.jme3.renderer.opengl.GLExt;
import com.jme3.renderer.opengl.GLImageFormat;
import com.jme3.renderer.opengl.GLImageFormats;
import com.jme3.texture.Image;
import com.jme3.texture.image.ColorSpace;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TextureUtil {
    private static final Logger logger = Logger.getLogger(TextureUtil.class.getName());
    private final GL gl;
    private final GL2 gl2;
    private final GLExt glext;
    private GLImageFormat[][] formats;
    private boolean supportUnpackRowLength;

    public TextureUtil(GL gl, GL2 gl2, GLExt glext) {
        this.gl = gl;
        this.gl2 = gl2;
        this.glext = glext;
    }

    public void initialize(EnumSet<Caps> caps) {
        this.supportUnpackRowLength = caps.contains((Object)Caps.UnpackRowLength);
        this.formats = GLImageFormats.getFormatsForCaps(caps);
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Supported texture formats: \n");
            for (int i = 0; i < Image.Format.values().length; ++i) {
                Image.Format format = Image.Format.values()[i];
                if (this.formats[0][i] == null) continue;
                boolean srgb = this.formats[1][i] != null;
                sb.append("\t").append(format.toString());
                sb.append(" (Linear");
                if (srgb) {
                    sb.append("/sRGB");
                }
                sb.append(")\n");
            }
            logger.log(Level.FINE, sb.toString());
        }
    }

    public GLImageFormat getImageFormat(Image.Format fmt, boolean isSrgb) {
        if (isSrgb) {
            return this.formats[1][fmt.ordinal()];
        }
        return this.formats[0][fmt.ordinal()];
    }

    public GLImageFormat getImageFormatWithError(Image.Format fmt, boolean isSrgb) {
        GLImageFormat glFmt = this.getImageFormat(fmt, isSrgb = isSrgb && !fmt.isDepthFormat());
        if (glFmt == null && isSrgb) {
            glFmt = this.getImageFormat(fmt, false);
            logger.log(Level.WARNING, "No sRGB format available for ''{0}''. Failling back to linear.", (Object)fmt);
        }
        if (glFmt == null) {
            throw new RendererException("Image format '" + (Object)((Object)fmt) + "' is unsupported by the video hardware.");
        }
        return glFmt;
    }

    private void setupTextureSwizzle(int target, Image.Format format) {
        switch (format) {
            case Alpha8: {
                this.gl.glTexParameteri(target, 36418, 0);
                this.gl.glTexParameteri(target, 36419, 0);
                this.gl.glTexParameteri(target, 36420, 0);
                this.gl.glTexParameteri(target, 36421, 6403);
                break;
            }
            case Luminance8: 
            case Luminance16F: 
            case Luminance32F: {
                this.gl.glTexParameteri(target, 36418, 6403);
                this.gl.glTexParameteri(target, 36419, 6403);
                this.gl.glTexParameteri(target, 36420, 6403);
                this.gl.glTexParameteri(target, 36421, 1);
                break;
            }
            case Luminance8Alpha8: 
            case Luminance16FAlpha16F: {
                this.gl.glTexParameteri(target, 36418, 6403);
                this.gl.glTexParameteri(target, 36419, 6403);
                this.gl.glTexParameteri(target, 36420, 6403);
                this.gl.glTexParameteri(target, 36421, 6404);
                break;
            }
            case ABGR8: {
                this.gl.glTexParameteri(target, 36418, 6406);
                this.gl.glTexParameteri(target, 36419, 6405);
                this.gl.glTexParameteri(target, 36420, 6404);
                this.gl.glTexParameteri(target, 36421, 6403);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void uploadTextureLevel(GLImageFormat format, int target, int level, int slice, int sliceCount, int width, int height, int depth, int samples, ByteBuffer data) {
        if (format.compressed && data != null) {
            if (target == 32879) {
                this.gl2.glCompressedTexImage3D(target, level, format.internalFormat, width, height, depth, 0, data);
            } else if (target == 35866) {
                this.gl2.glCompressedTexSubImage3D(target, level, 0, 0, slice, width, height, 1, format.internalFormat, data);
            } else {
                this.gl2.glCompressedTexImage2D(target, level, format.internalFormat, width, height, 0, data);
            }
        } else if (target == 32879) {
            this.gl2.glTexImage3D(target, level, format.internalFormat, width, height, depth, 0, format.format, format.dataType, data);
        } else if (target == 35866) {
            if (slice == -1) {
                this.gl2.glTexImage3D(target, level, format.internalFormat, width, height, sliceCount, 0, format.format, format.dataType, data);
            } else {
                this.gl2.glTexSubImage3D(target, level, 0, 0, slice, width, height, 1, format.format, format.dataType, data);
            }
        } else if (samples > 1) {
            this.glext.glTexImage2DMultisample(target, samples, format.internalFormat, width, height, true);
        } else {
            this.gl.glTexImage2D(target, level, format.internalFormat, width, height, 0, format.format, format.dataType, data);
        }
    }

    public void uploadTexture(Image image, int target, int index, boolean linearizeSrgb) {
        boolean getSrgbFormat = image.getColorSpace() == ColorSpace.sRGB && linearizeSrgb;
        Image.Format jmeFormat = image.getFormat();
        GLImageFormat oglFormat = this.getImageFormatWithError(jmeFormat, getSrgbFormat);
        ByteBuffer data = null;
        int sliceCount = 1;
        if (index >= 0) {
            data = image.getData(index);
        }
        if (image.getData() != null && image.getData().size() > 0) {
            sliceCount = image.getData().size();
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int depth = image.getDepth();
        int[] mipSizes = image.getMipMapSizes();
        int pos = 0;
        if (mipSizes == null) {
            mipSizes = data != null ? new int[]{data.capacity()} : new int[]{width * height * jmeFormat.getBitsPerPixel() / 8};
        }
        int samples = image.getMultiSamples();
        if (oglFormat.swizzleRequired) {
            this.setupTextureSwizzle(target, jmeFormat);
        }
        for (int i = 0; i < mipSizes.length; ++i) {
            int mipWidth = Math.max(1, width >> i);
            int mipHeight = Math.max(1, height >> i);
            int mipDepth = Math.max(1, depth >> i);
            if (data != null) {
                data.position(pos);
                data.limit(pos + mipSizes[i]);
            }
            this.uploadTextureLevel(oglFormat, target, i, index, sliceCount, mipWidth, mipHeight, mipDepth, samples, data);
            pos += mipSizes[i];
        }
    }

    @Deprecated
    public void uploadSubTexture(Image image, int target, int index, int x, int y, boolean linearizeSrgb) {
        if (target != 3553 || image.getDepth() > 1) {
            throw new UnsupportedOperationException("Updating non-2D texture is not supported");
        }
        if (image.getMipMapSizes() != null) {
            throw new UnsupportedOperationException("Updating mip-mapped images is not supported");
        }
        if (image.getMultiSamples() > 1) {
            throw new UnsupportedOperationException("Updating multisampled images is not supported");
        }
        Image.Format jmeFormat = image.getFormat();
        if (jmeFormat.isCompressed()) {
            throw new UnsupportedOperationException("Updating compressed images is not supported");
        }
        if (jmeFormat.isDepthFormat()) {
            throw new UnsupportedOperationException("Updating depth images is not supported");
        }
        boolean getSrgbFormat = image.getColorSpace() == ColorSpace.sRGB && linearizeSrgb;
        GLImageFormat oglFormat = this.getImageFormatWithError(jmeFormat, getSrgbFormat);
        ByteBuffer data = null;
        if (index >= 0) {
            data = image.getData(index);
        }
        if (data == null) {
            throw new IndexOutOfBoundsException("The image index " + index + " is not valid for the given image");
        }
        data.position(0);
        data.limit(data.capacity());
        this.gl.glTexSubImage2D(target, 0, x, y, image.getWidth(), image.getHeight(), oglFormat.format, oglFormat.dataType, data);
    }

    public void uploadSubTexture(int target, Image src, int index, int targetX, int targetY, int areaX, int areaY, int areaWidth, int areaHeight, boolean linearizeSrgb) {
        boolean needsStride;
        if (target != 3553 || src.getDepth() > 1) {
            throw new UnsupportedOperationException("Updating non-2D texture is not supported");
        }
        if (src.getMipMapSizes() != null) {
            throw new UnsupportedOperationException("Updating mip-mappped images is not supported");
        }
        if (src.getMultiSamples() > 1) {
            throw new UnsupportedOperationException("Updating multisampled images is not supported");
        }
        Image.Format jmeFormat = src.getFormat();
        if (jmeFormat.isCompressed()) {
            throw new UnsupportedOperationException("Updating compressed images is not supported");
        }
        if (jmeFormat.isDepthFormat()) {
            throw new UnsupportedOperationException("Updating depth images is not supported");
        }
        boolean getSrgbFormat = src.getColorSpace() == ColorSpace.sRGB && linearizeSrgb;
        GLImageFormat oglFormat = this.getImageFormatWithError(jmeFormat, getSrgbFormat);
        ByteBuffer data = src.getData(index);
        if (data == null) {
            throw new IndexOutOfBoundsException("The image index " + index + " is not valid for the given image");
        }
        int Bpp = src.getFormat().getBitsPerPixel() / 8;
        int srcWidth = src.getWidth();
        int cpos = data.position();
        int skip = areaX;
        skip += areaY * srcWidth;
        data.position(skip *= Bpp);
        boolean bl = needsStride = srcWidth != areaWidth;
        if (needsStride && !this.supportUnpackRowLength) {
            for (int i = 0; i < areaHeight; ++i) {
                data.position(skip + srcWidth * Bpp * i);
                this.gl.glTexSubImage2D(target, 0, targetX, targetY + i, areaWidth, 1, oglFormat.format, oglFormat.dataType, data);
            }
        } else {
            if (needsStride) {
                this.gl2.glPixelStorei(3314, srcWidth);
            }
            this.gl.glTexSubImage2D(target, 0, targetX, targetY, areaWidth, areaHeight, oglFormat.format, oglFormat.dataType, data);
            if (needsStride) {
                this.gl2.glPixelStorei(3314, 0);
            }
        }
        data.position(cpos);
    }
}

