/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.opengl;

import com.jme3.renderer.opengl.GL;
import com.jme3.renderer.opengl.GL2;
import com.jme3.renderer.opengl.GL3;
import com.jme3.renderer.opengl.GL4;
import com.jme3.renderer.opengl.GLExt;
import com.jme3.renderer.opengl.GLFbo;
import com.jme3.util.IntMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;

public final class GLTracer
implements InvocationHandler {
    private final Object obj;
    private final IntMap<String> constMap;
    private static final HashMap<String, IntMap<Void>> nonEnumArgMap = new HashMap();
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_BRIGHT = "\u001b[1m";
    private static final String ANSI_BLACK = "\u001b[30m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_BLUE = "\u001b[34m";
    private static final String ANSI_MAGENTA = "\u001b[35m";
    private static final String ANSI_CYAN = "\u001b[36m";
    private static final String ANSI_WHITE = "\u001b[37m";

    private static void noEnumArgs(String method, int ... argSlots) {
        IntMap<Object> argSlotsMap = new IntMap<Object>();
        for (int argSlot : argSlots) {
            argSlotsMap.put(argSlot, null);
        }
        nonEnumArgMap.put(method, argSlotsMap);
    }

    public GLTracer(Object obj, IntMap<String> constMap) {
        this.obj = obj;
        this.constMap = constMap;
    }

    private static IntMap<String> generateConstantMap(Class<?> ... classes) {
        IntMap<String> constMap = new IntMap<String>();
        for (Class<?> clazz : classes) {
            for (Field field : clazz.getFields()) {
                if (field.getType() != Integer.TYPE) continue;
                try {
                    int val = field.getInt(null);
                    String name = field.getName();
                    constMap.put(val, name);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        constMap.put(1, "GL_ONE");
        return constMap;
    }

    public static Object createGlesTracer(Object glInterface, Class<?> ... glInterfaceClasses) {
        IntMap<String> constMap = GLTracer.generateConstantMap(GL.class, GL2.class, GL3.class, GLFbo.class, GLExt.class);
        return Proxy.newProxyInstance(glInterface.getClass().getClassLoader(), glInterfaceClasses, (InvocationHandler)new GLTracer(glInterface, constMap));
    }

    public static Object createDesktopGlTracer(Object glInterface, Class<?> ... glInterfaceClasses) {
        IntMap<String> constMap = GLTracer.generateConstantMap(GL2.class, GL3.class, GL4.class, GLFbo.class, GLExt.class);
        return Proxy.newProxyInstance(glInterface.getClass().getClassLoader(), glInterfaceClasses, (InvocationHandler)new GLTracer(glInterface, constMap));
    }

    private void printStyle(String style, String string) {
        System.out.print(style + string + ANSI_RESET);
    }

    private void print(String string) {
        System.out.print(string);
    }

    private void printInt(int value) {
        this.print(Integer.toString(value));
    }

    private void printEnum(int value) {
        String enumName = this.constMap.get(value);
        if (enumName != null) {
            if (enumName.startsWith("GL_")) {
                enumName = enumName.substring(3);
            }
            if (enumName.endsWith("_EXT") || enumName.endsWith("_ARB")) {
                enumName = enumName.substring(0, enumName.length() - 4);
            }
            this.printStyle(ANSI_GREEN, enumName);
        } else {
            this.printStyle(ANSI_GREEN, "ENUM_" + Integer.toHexString(value));
        }
    }

    private void printIntOrEnum(String method, int value, int argIndex) {
        IntMap<Void> argSlotMap = nonEnumArgMap.get(method);
        if (argSlotMap != null && argSlotMap.containsKey(argIndex)) {
            this.printInt(value);
        } else {
            this.printEnum(value);
        }
    }

    private void printNewLine() {
        System.out.println();
    }

    private void printString(String value) {
        if (value.length() > 150) {
            value = value.substring(0, 150) + "...";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ANSI_YELLOW);
        sb.append("\"");
        sb.append(ANSI_RESET);
        for (String line : value.split("\n")) {
            sb.append(ANSI_YELLOW);
            sb.append(line.replaceAll("\u0000", "\\\\0"));
            sb.append(ANSI_RESET);
            sb.append("\n");
        }
        if (sb.length() > 1 && sb.charAt(sb.length() - 1) == '\n') {
            sb.setLength(sb.length() - 1);
        }
        sb.append(ANSI_YELLOW);
        sb.append("\"");
        sb.append(ANSI_RESET);
        this.print(sb.toString());
    }

    private void printBoolean(boolean bool) {
        this.printStyle(ANSI_BLUE, bool ? "true" : "false");
    }

    private void printBuffer(Buffer buffer) {
        StringBuilder sb = new StringBuilder();
        sb.append(ANSI_MAGENTA);
        if (buffer instanceof ByteBuffer) {
            sb.append("byte");
        } else if (buffer instanceof ShortBuffer) {
            sb.append("short");
        } else if (buffer instanceof CharBuffer) {
            sb.append("char");
        } else if (buffer instanceof FloatBuffer) {
            sb.append("float");
        } else if (buffer instanceof IntBuffer) {
            sb.append("int");
        } else if (buffer instanceof LongBuffer) {
            sb.append("long");
        } else if (buffer instanceof DoubleBuffer) {
            sb.append("double");
        } else {
            throw new UnsupportedOperationException();
        }
        sb.append(ANSI_RESET);
        sb.append("[");
        if (buffer.position() == 0 && buffer.limit() == buffer.capacity()) {
            sb.append(buffer.capacity());
        } else {
            sb.append("pos=").append(buffer.position());
            sb.append(" lim=").append(buffer.limit());
            sb.append(" cap=").append(buffer.capacity());
        }
        sb.append("]");
        this.print(sb.toString());
    }

    private void printMethodName(String methodName) {
        if (methodName.startsWith("gl")) {
            if ((methodName = methodName.substring(2)).equals("Clear") || methodName.equals("DrawRangeElements") || methodName.equals("DrawElementsInstancedARB")) {
                this.print(methodName);
            } else {
                if (methodName.endsWith("EXT")) {
                    methodName = methodName.substring(0, methodName.length() - 3);
                }
                this.printStyle(ANSI_BRIGHT, methodName);
            }
        } else if (methodName.equals("resetStats")) {
            this.printStyle(ANSI_RED, "-- frame boundary --");
        }
    }

    private void printArgsClear(int mask) {
        boolean needAPipe = false;
        this.print("(");
        if ((mask & 0x4000) != 0) {
            this.printStyle(ANSI_GREEN, "COLOR_BUFFER_BIT");
            needAPipe = true;
        }
        if ((mask & 0x100) != 0) {
            if (needAPipe) {
                this.print(" | ");
            }
            this.printStyle(ANSI_GREEN, "DEPTH_BUFFER_BIT");
        }
        if ((mask & 0x400) != 0) {
            if (needAPipe) {
                this.print(" | ");
            }
            this.printStyle(ANSI_GREEN, "STENCIL_BUFFER_BIT");
        }
        this.print(")");
    }

    private void printArgsGetInteger(Object[] args) {
        this.print("(");
        int param = (Integer)args[0];
        IntBuffer ib = (IntBuffer)args[1];
        this.printEnum(param);
        this.print(", ");
        this.printOut();
        if (param == 3073 || param == 3074) {
            this.printEnum(ib.get(0));
        } else {
            this.printInt(ib.get(0));
        }
        this.print(")");
    }

    private void printArgsTexParameter(Object[] args) {
        this.print("(");
        int target = (Integer)args[0];
        int param = (Integer)args[1];
        int value = (Integer)args[2];
        this.printEnum(target);
        this.print(", ");
        this.printEnum(param);
        this.print(", ");
        if (param == 33084 || param == 33085) {
            this.printInt(value);
        } else {
            this.printEnum(value);
        }
        this.print(")");
    }

    private void printOut() {
        this.printStyle(ANSI_CYAN, "out=");
    }

    private void printResult(String methodName, Object result, Class<?> returnType) {
        if (returnType != Void.TYPE) {
            this.print(" = ");
            if (result instanceof String) {
                this.printString((String)result);
            } else if (returnType == Integer.TYPE) {
                int val = (Integer)result;
                this.printIntOrEnum(methodName, val, -1);
            } else if (returnType == Boolean.TYPE) {
                this.printBoolean((Boolean)result);
            } else {
                this.print(" = ???");
            }
        }
    }

    private void printNull() {
        this.printStyle(ANSI_BLUE, "null");
    }

    private void printArgs(String methodName, Object[] args, Class<?>[] paramTypes) {
        if (methodName.equals("glClear")) {
            this.printArgsClear((Integer)args[0]);
            return;
        }
        if (methodName.equals("glTexParameteri")) {
            this.printArgsTexParameter(args);
            return;
        }
        if (methodName.equals("glGetInteger")) {
            this.printArgsGetInteger(args);
            return;
        }
        if (args == null) {
            this.print("()");
            return;
        }
        this.print("(");
        for (int i = 0; i < args.length; ++i) {
            if (paramTypes[i] == Integer.TYPE) {
                int val = (Integer)args[i];
                this.printIntOrEnum(methodName, val, i);
            } else if (paramTypes[i] == Boolean.TYPE) {
                this.printBoolean((Boolean)args[i]);
            } else if (paramTypes[i] == String.class) {
                this.printString((String)args[i]);
            } else if (paramTypes[i] == String[].class) {
                String[] arr = (String[])args[i];
                if (arr.length == 1) {
                    this.printString(arr[0]);
                } else {
                    this.print("string[" + arr.length + "]");
                }
            } else if (args[i] instanceof IntBuffer) {
                IntBuffer buf = (IntBuffer)args[i];
                if (buf.capacity() == 16) {
                    int val = buf.get(0);
                    this.printOut();
                    this.printIntOrEnum(methodName, val, i);
                } else if (buf.capacity() == 1) {
                    this.printOut();
                    this.print(Integer.toString(buf.get(0)));
                } else {
                    this.printBuffer(buf);
                }
            } else if (args[i] instanceof ByteBuffer) {
                ByteBuffer bb = (ByteBuffer)args[i];
                if (bb.capacity() == 250) {
                    this.printOut();
                    this.printBoolean(bb.get(0) != 0);
                } else {
                    this.printBuffer(bb);
                }
            } else if (args[i] instanceof Buffer) {
                this.printBuffer((Buffer)args[i]);
            } else if (args[i] != null) {
                this.print(args[i].toString());
            } else {
                this.printNull();
            }
            if (i == args.length - 1) continue;
            System.out.print(", ");
        }
        this.print(")");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        this.printMethodName(methodName);
        if (methodName.startsWith("gl")) {
            try {
                Object result = method.invoke(this.obj, args);
                this.printArgs(methodName, args, method.getParameterTypes());
                this.printResult(methodName, result, method.getReturnType());
                this.printNewLine();
                return result;
            }
            catch (Throwable ex) {
                this.printArgs(methodName, args, method.getParameterTypes());
                this.printNewLine();
                System.out.println("\tException occurred!");
                System.out.println(ex.toString());
                throw ex;
            }
        }
        this.printNewLine();
        return method.invoke(this.obj, args);
    }

    static {
        GLTracer.noEnumArgs("glViewport", 0, 1, 2, 3);
        GLTracer.noEnumArgs("glScissor", 0, 1, 2, 3);
        GLTracer.noEnumArgs("glClear", 0);
        GLTracer.noEnumArgs("glGetInteger", 1);
        GLTracer.noEnumArgs("glGetString", 1);
        GLTracer.noEnumArgs("glBindTexture", 1);
        GLTracer.noEnumArgs("glPixelStorei", 1);
        GLTracer.noEnumArgs("glTexImage2D", 1, 3, 4, 5);
        GLTracer.noEnumArgs("glTexImage3D", 1, 3, 4, 5, 6);
        GLTracer.noEnumArgs("glTexSubImage2D", 1, 2, 3, 4, 5);
        GLTracer.noEnumArgs("glTexSubImage3D", 1, 2, 3, 4, 5, 6, 7);
        GLTracer.noEnumArgs("glCompressedTexImage2D", 1, 3, 4, 5);
        GLTracer.noEnumArgs("glCompressedTexSubImage3D", 1, 2, 3, 4, 5, 6, 7);
        GLTracer.noEnumArgs("glDeleteTextures", 0);
        GLTracer.noEnumArgs("glReadPixels", 0, 1, 2, 3);
        GLTracer.noEnumArgs("glBindBuffer", 1);
        GLTracer.noEnumArgs("glEnableVertexAttribArray", 0);
        GLTracer.noEnumArgs("glDisableVertexAttribArray", 0);
        GLTracer.noEnumArgs("glVertexAttribPointer", 0, 1, 4, 5);
        GLTracer.noEnumArgs("glVertexAttribDivisorARB", 0, 1);
        GLTracer.noEnumArgs("glDrawRangeElements", 1, 2, 3, 5);
        GLTracer.noEnumArgs("glDrawArrays", 1, 2);
        GLTracer.noEnumArgs("glDeleteBuffers", 0);
        GLTracer.noEnumArgs("glBindVertexArray", 0);
        GLTracer.noEnumArgs("glGenVertexArrays", 0);
        GLTracer.noEnumArgs("glBindFramebufferEXT", 1);
        GLTracer.noEnumArgs("glBindRenderbufferEXT", 1);
        GLTracer.noEnumArgs("glRenderbufferStorageEXT", 2, 3);
        GLTracer.noEnumArgs("glRenderbufferStorageMultisampleEXT", 1, 3, 4);
        GLTracer.noEnumArgs("glFramebufferRenderbufferEXT", 3);
        GLTracer.noEnumArgs("glFramebufferTexture2DEXT", 3, 4);
        GLTracer.noEnumArgs("glFramebufferTextureLayerEXT", 2, 3, 4);
        GLTracer.noEnumArgs("glBlitFramebufferEXT", 0, 1, 2, 3, 4, 5, 6, 7, 8);
        GLTracer.noEnumArgs("glCreateProgram", -1);
        GLTracer.noEnumArgs("glCreateShader", -1);
        GLTracer.noEnumArgs("glShaderSource", 0);
        GLTracer.noEnumArgs("glCompileShader", 0);
        GLTracer.noEnumArgs("glGetShader", 0);
        GLTracer.noEnumArgs("glAttachShader", 0, 1);
        GLTracer.noEnumArgs("glLinkProgram", 0);
        GLTracer.noEnumArgs("glGetProgram", 0);
        GLTracer.noEnumArgs("glUseProgram", 0);
        GLTracer.noEnumArgs("glGetUniformLocation", 0, -1);
        GLTracer.noEnumArgs("glUniformMatrix3", 0);
        GLTracer.noEnumArgs("glUniformMatrix4", 0);
        GLTracer.noEnumArgs("glUniform1i", 0, 1);
        GLTracer.noEnumArgs("glUniform1f", 0);
        GLTracer.noEnumArgs("glUniform2f", 0);
        GLTracer.noEnumArgs("glUniform3f", 0);
        GLTracer.noEnumArgs("glUniform4", 0);
        GLTracer.noEnumArgs("glUniform4f", 0);
        GLTracer.noEnumArgs("glGetAttribLocation", 0, -1);
        GLTracer.noEnumArgs("glDetachShader", 0, 1);
        GLTracer.noEnumArgs("glDeleteShader", 0);
        GLTracer.noEnumArgs("glDeleteProgram", 0);
        GLTracer.noEnumArgs("glBindFragDataLocation", 0, 1);
    }
}

