/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import java.io.IOException;
import java.io.Serializable;

public final class ColorRGBA
implements Savable,
Cloneable,
Serializable {
    static final float GAMMA = 2.2f;
    static final long serialVersionUID = 1L;
    public static final ColorRGBA Black = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    public static final ColorRGBA White = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    public static final ColorRGBA DarkGray = new ColorRGBA(0.2f, 0.2f, 0.2f, 1.0f);
    public static final ColorRGBA Gray = new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f);
    public static final ColorRGBA LightGray = new ColorRGBA(0.8f, 0.8f, 0.8f, 1.0f);
    public static final ColorRGBA Red = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
    public static final ColorRGBA Green = new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f);
    public static final ColorRGBA Blue = new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f);
    public static final ColorRGBA Yellow = new ColorRGBA(1.0f, 1.0f, 0.0f, 1.0f);
    public static final ColorRGBA Magenta = new ColorRGBA(1.0f, 0.0f, 1.0f, 1.0f);
    public static final ColorRGBA Cyan = new ColorRGBA(0.0f, 1.0f, 1.0f, 1.0f);
    public static final ColorRGBA Orange = new ColorRGBA(0.9843137f, 0.50980395f, 0.0f, 1.0f);
    public static final ColorRGBA Brown = new ColorRGBA(0.25490198f, 0.15686275f, 0.09803922f, 1.0f);
    public static final ColorRGBA Pink = new ColorRGBA(1.0f, 0.68f, 0.68f, 1.0f);
    public static final ColorRGBA BlackNoAlpha = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    public float r;
    public float g;
    public float b;
    public float a;

    public ColorRGBA() {
        this.a = 1.0f;
        this.b = 1.0f;
        this.g = 1.0f;
        this.r = 1.0f;
    }

    public ColorRGBA(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public ColorRGBA(ColorRGBA rgba) {
        this.a = rgba.a;
        this.r = rgba.r;
        this.g = rgba.g;
        this.b = rgba.b;
    }

    public ColorRGBA set(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public ColorRGBA set(ColorRGBA rgba) {
        if (rgba == null) {
            this.r = 0.0f;
            this.g = 0.0f;
            this.b = 0.0f;
            this.a = 0.0f;
        } else {
            this.r = rgba.r;
            this.g = rgba.g;
            this.b = rgba.b;
            this.a = rgba.a;
        }
        return this;
    }

    public void clamp() {
        this.r = FastMath.clamp(this.r, 0.0f, 1.0f);
        this.g = FastMath.clamp(this.g, 0.0f, 1.0f);
        this.b = FastMath.clamp(this.b, 0.0f, 1.0f);
        this.a = FastMath.clamp(this.a, 0.0f, 1.0f);
    }

    public float[] getColorArray() {
        return new float[]{this.r, this.g, this.b, this.a};
    }

    public float[] getColorArray(float[] store) {
        store[0] = this.r;
        store[1] = this.g;
        store[2] = this.b;
        store[3] = this.a;
        return store;
    }

    public float getAlpha() {
        return this.a;
    }

    public float getRed() {
        return this.r;
    }

    public float getBlue() {
        return this.b;
    }

    public float getGreen() {
        return this.g;
    }

    public ColorRGBA interpolateLocal(ColorRGBA finalColor, float changeAmnt) {
        this.r = (1.0f - changeAmnt) * this.r + changeAmnt * finalColor.r;
        this.g = (1.0f - changeAmnt) * this.g + changeAmnt * finalColor.g;
        this.b = (1.0f - changeAmnt) * this.b + changeAmnt * finalColor.b;
        this.a = (1.0f - changeAmnt) * this.a + changeAmnt * finalColor.a;
        return this;
    }

    public ColorRGBA interpolateLocal(ColorRGBA beginColor, ColorRGBA finalColor, float changeAmnt) {
        this.r = (1.0f - changeAmnt) * beginColor.r + changeAmnt * finalColor.r;
        this.g = (1.0f - changeAmnt) * beginColor.g + changeAmnt * finalColor.g;
        this.b = (1.0f - changeAmnt) * beginColor.b + changeAmnt * finalColor.b;
        this.a = (1.0f - changeAmnt) * beginColor.a + changeAmnt * finalColor.a;
        return this;
    }

    public static ColorRGBA randomColor() {
        ColorRGBA rVal = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
        rVal.r = FastMath.nextRandomFloat();
        rVal.g = FastMath.nextRandomFloat();
        rVal.b = FastMath.nextRandomFloat();
        return rVal;
    }

    public ColorRGBA mult(ColorRGBA c) {
        return new ColorRGBA(c.r * this.r, c.g * this.g, c.b * this.b, c.a * this.a);
    }

    public ColorRGBA mult(float scalar) {
        return new ColorRGBA(scalar * this.r, scalar * this.g, scalar * this.b, scalar * this.a);
    }

    public ColorRGBA multLocal(float scalar) {
        this.r *= scalar;
        this.g *= scalar;
        this.b *= scalar;
        this.a *= scalar;
        return this;
    }

    public ColorRGBA add(ColorRGBA c) {
        return new ColorRGBA(c.r + this.r, c.g + this.g, c.b + this.b, c.a + this.a);
    }

    public ColorRGBA addLocal(ColorRGBA c) {
        this.set(c.r + this.r, c.g + this.g, c.b + this.b, c.a + this.a);
        return this;
    }

    public String toString() {
        return "Color[" + this.r + ", " + this.g + ", " + this.b + ", " + this.a + "]";
    }

    public ColorRGBA clone() {
        try {
            return (ColorRGBA)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public float[] toArray(float[] floats) {
        if (floats == null) {
            floats = new float[]{this.r, this.g, this.b, this.a};
        }
        return floats;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ColorRGBA)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ColorRGBA comp = (ColorRGBA)o;
        if (Float.compare(this.r, comp.r) != 0) {
            return false;
        }
        if (Float.compare(this.g, comp.g) != 0) {
            return false;
        }
        if (Float.compare(this.b, comp.b) != 0) {
            return false;
        }
        return Float.compare(this.a, comp.a) == 0;
    }

    public int hashCode() {
        int hash = 37;
        hash += 37 * hash + Float.floatToIntBits(this.r);
        hash += 37 * hash + Float.floatToIntBits(this.g);
        hash += 37 * hash + Float.floatToIntBits(this.b);
        hash += 37 * hash + Float.floatToIntBits(this.a);
        return hash;
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.r, "r", 0.0f);
        capsule.write(this.g, "g", 0.0f);
        capsule.write(this.b, "b", 0.0f);
        capsule.write(this.a, "a", 0.0f);
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        InputCapsule capsule = e.getCapsule(this);
        this.r = capsule.readFloat("r", 0.0f);
        this.g = capsule.readFloat("g", 0.0f);
        this.b = capsule.readFloat("b", 0.0f);
        this.a = capsule.readFloat("a", 0.0f);
    }

    public byte[] asBytesRGBA() {
        byte[] store = new byte[]{(byte)((int)(this.r * 255.0f) & 0xFF), (byte)((int)(this.g * 255.0f) & 0xFF), (byte)((int)(this.b * 255.0f) & 0xFF), (byte)((int)(this.a * 255.0f) & 0xFF)};
        return store;
    }

    public int asIntARGB() {
        int argb = ((int)(this.a * 255.0f) & 0xFF) << 24 | ((int)(this.r * 255.0f) & 0xFF) << 16 | ((int)(this.g * 255.0f) & 0xFF) << 8 | (int)(this.b * 255.0f) & 0xFF;
        return argb;
    }

    public int asIntRGBA() {
        int rgba = ((int)(this.r * 255.0f) & 0xFF) << 24 | ((int)(this.g * 255.0f) & 0xFF) << 16 | ((int)(this.b * 255.0f) & 0xFF) << 8 | (int)(this.a * 255.0f) & 0xFF;
        return rgba;
    }

    public int asIntABGR() {
        int abgr = ((int)(this.a * 255.0f) & 0xFF) << 24 | ((int)(this.b * 255.0f) & 0xFF) << 16 | ((int)(this.g * 255.0f) & 0xFF) << 8 | (int)(this.r * 255.0f) & 0xFF;
        return abgr;
    }

    public ColorRGBA fromIntARGB(int color) {
        this.a = (float)((byte)(color >> 24) & 0xFF) / 255.0f;
        this.r = (float)((byte)(color >> 16) & 0xFF) / 255.0f;
        this.g = (float)((byte)(color >> 8) & 0xFF) / 255.0f;
        this.b = (float)((byte)color & 0xFF) / 255.0f;
        return this;
    }

    public ColorRGBA fromIntRGBA(int color) {
        this.r = (float)((byte)(color >> 24) & 0xFF) / 255.0f;
        this.g = (float)((byte)(color >> 16) & 0xFF) / 255.0f;
        this.b = (float)((byte)(color >> 8) & 0xFF) / 255.0f;
        this.a = (float)((byte)color & 0xFF) / 255.0f;
        return this;
    }

    public ColorRGBA fromIntABGR(int color) {
        this.a = (float)((byte)(color >> 24) & 0xFF) / 255.0f;
        this.b = (float)((byte)(color >> 16) & 0xFF) / 255.0f;
        this.g = (float)((byte)(color >> 8) & 0xFF) / 255.0f;
        this.r = (float)((byte)color & 0xFF) / 255.0f;
        return this;
    }

    public Vector3f toVector3f() {
        return new Vector3f(this.r, this.g, this.b);
    }

    public Vector4f toVector4f() {
        return new Vector4f(this.r, this.g, this.b, this.a);
    }

    public ColorRGBA setAsSrgb(float r, float g, float b, float a) {
        this.r = (float)Math.pow(r, 2.2f);
        this.b = (float)Math.pow(b, 2.2f);
        this.g = (float)Math.pow(g, 2.2f);
        this.a = a;
        return this;
    }

    public ColorRGBA getAsSrgb() {
        ColorRGBA srgb = new ColorRGBA();
        float invGama = 0.45454544f;
        srgb.r = (float)Math.pow(this.r, invGama);
        srgb.g = (float)Math.pow(this.g, invGama);
        srgb.b = (float)Math.pow(this.b, invGama);
        srgb.a = this.a;
        return srgb;
    }
}

