/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.MaterialKey;
import com.jme3.asset.TextureKey;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.material.TechniqueDef;
import com.jme3.material.logic.DefaultTechniqueDefLogic;
import com.jme3.material.logic.MultiPassLightingLogic;
import com.jme3.material.logic.SinglePassAndImageBasedLightingLogic;
import com.jme3.material.logic.SinglePassLightingLogic;
import com.jme3.material.logic.StaticPassLightingLogic;
import com.jme3.material.plugins.MatParseException;
import com.jme3.material.plugins.ShaderNodeLoaderDelegate;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.PlaceholderAssets;
import com.jme3.util.blockparser.BlockLanguageParser;
import com.jme3.util.blockparser.Statement;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class J3MLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(J3MLoader.class.getName());
    private ShaderNodeLoaderDelegate nodesLoaderDelegate;
    boolean isUseNodes = false;
    int langSize = 0;
    private AssetManager assetManager;
    private AssetKey key;
    private MaterialDef materialDef;
    private Material material;
    private TechniqueDef technique;
    private RenderState renderState;
    private ArrayList<String> presetDefines = new ArrayList();
    private List<EnumMap<Shader.ShaderType, String>> shaderLanguages = new ArrayList<EnumMap<Shader.ShaderType, String>>();
    private EnumMap<Shader.ShaderType, String> shaderNames = new EnumMap(Shader.ShaderType.class);
    private static final String whitespacePattern = "\\p{javaWhitespace}+";

    private void readShaderStatement(String statement) throws IOException {
        String[] split = statement.split(":");
        if (split.length != 2) {
            throw new IOException("Shader statement syntax incorrect" + statement);
        }
        String[] typeAndLang = split[0].split(whitespacePattern);
        for (Shader.ShaderType shaderType : Shader.ShaderType.values()) {
            if (!typeAndLang[0].equals(shaderType.toString() + "Shader")) continue;
            this.readShaderDefinition(shaderType, split[1].trim(), Arrays.copyOfRange(typeAndLang, 1, typeAndLang.length));
        }
    }

    private void readShaderDefinition(Shader.ShaderType shaderType, String name, String ... languages) {
        this.shaderNames.put(shaderType, name);
        if (this.langSize != 0 && this.langSize != languages.length) {
            throw new AssetLoadException("Technique " + this.technique.getName() + " must have the same number of languages for each shader type.");
        }
        this.langSize = languages.length;
        for (int i = 0; i < languages.length; ++i) {
            if (i >= this.shaderLanguages.size()) {
                this.shaderLanguages.add(new EnumMap(Shader.ShaderType.class));
            }
            this.shaderLanguages.get(i).put(shaderType, languages[i]);
        }
    }

    private void readLightMode(String statement) throws IOException {
        String[] split = statement.split(whitespacePattern);
        if (split.length != 2) {
            throw new IOException("LightMode statement syntax incorrect");
        }
        TechniqueDef.LightMode lm = TechniqueDef.LightMode.valueOf(split[1]);
        this.technique.setLightMode(lm);
    }

    private void readLightSpace(String statement) throws IOException {
        String[] split = statement.split(whitespacePattern);
        if (split.length != 2) {
            throw new IOException("LightSpace statement syntax incorrect");
        }
        TechniqueDef.LightSpace ls = TechniqueDef.LightSpace.valueOf(split[1]);
        this.technique.setLightSpace(ls);
    }

    private void readShadowMode(String statement) throws IOException {
        String[] split = statement.split(whitespacePattern);
        if (split.length != 2) {
            throw new IOException("ShadowMode statement syntax incorrect");
        }
        TechniqueDef.ShadowMode sm = TechniqueDef.ShadowMode.valueOf(split[1]);
        this.technique.setShadowMode(sm);
    }

    private List<String> tokenizeTextureValue(String value) {
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(value.trim());
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        return matchList;
    }

    private List<TextureOptionValue> parseTextureOptions(List<String> values) {
        ArrayList<TextureOptionValue> matchList = new ArrayList<TextureOptionValue>();
        if (values.isEmpty() || values.size() == 1) {
            return matchList;
        }
        for (int i = 0; i < values.size() - 1; ++i) {
            String value = values.get(i);
            TextureOption textureOption = TextureOption.getTextureOption(value);
            if (!(textureOption != null || value.contains("\\") || value.contains("/") || values.get(0).equals("Flip") || values.get(0).equals("Repeat"))) {
                logger.log(Level.WARNING, "Unknown texture option \"{0}\" encountered for \"{1}\" in material \"{2}\"", new Object[]{value, this.key, this.material.getKey().getName()});
                continue;
            }
            if (textureOption == null) continue;
            String option = textureOption.getOptionValue(value);
            matchList.add(new TextureOptionValue(textureOption, option));
        }
        return matchList;
    }

    private boolean isTexturePathDeclaredTheTraditionalWay(List<TextureOptionValue> optionValues, String texturePath) {
        boolean startsWithOldStyle;
        boolean bl = startsWithOldStyle = texturePath.startsWith("Flip Repeat ") || texturePath.startsWith("Flip ") || texturePath.startsWith("Repeat ") || texturePath.startsWith("Repeat Flip ");
        if (!startsWithOldStyle) {
            return false;
        }
        if (optionValues.size() == 1 && (optionValues.get(0).textureOption == TextureOption.Flip || optionValues.get(0).textureOption == TextureOption.Repeat)) {
            return true;
        }
        if (optionValues.size() == 2 && optionValues.get(0).textureOption == TextureOption.Flip && optionValues.get(1).textureOption == TextureOption.Repeat) {
            return true;
        }
        return optionValues.size() == 2 && optionValues.get(0).textureOption == TextureOption.Repeat && optionValues.get(1).textureOption == TextureOption.Flip;
    }

    private Texture parseTextureType(VarType type, String value) {
        Texture texture;
        List<String> textureValues = this.tokenizeTextureValue(value);
        List<TextureOptionValue> textureOptionValues = this.parseTextureOptions(textureValues);
        TextureKey textureKey = null;
        if (textureValues.size() == 1) {
            textureKey = new TextureKey(textureValues.get(0), false);
        } else {
            String texturePath = value.trim();
            if (this.isTexturePathDeclaredTheTraditionalWay(textureOptionValues, texturePath)) {
                boolean flipY = false;
                if (texturePath.startsWith("Flip Repeat ") || texturePath.startsWith("Repeat Flip ")) {
                    texturePath = texturePath.substring(12).trim();
                    flipY = true;
                } else if (texturePath.startsWith("Flip ")) {
                    texturePath = texturePath.substring(5).trim();
                    flipY = true;
                } else if (texturePath.startsWith("Repeat ")) {
                    texturePath = texturePath.substring(7).trim();
                }
                if (texturePath.startsWith("\"") || texturePath.startsWith("'")) {
                    texturePath = texturePath.substring(1);
                }
                if (texturePath.endsWith("\"") || texturePath.endsWith("'")) {
                    texturePath = texturePath.substring(0, texturePath.length() - 1);
                }
                textureKey = new TextureKey(texturePath, flipY);
            }
            if (textureKey == null) {
                textureKey = new TextureKey(textureValues.get(textureValues.size() - 1), false);
            }
            if (!textureOptionValues.isEmpty()) {
                for (TextureOptionValue textureOptionValue : textureOptionValues) {
                    textureOptionValue.applyToTextureKey(textureKey);
                }
            }
        }
        switch (type) {
            case Texture3D: {
                textureKey.setTextureTypeHint(Texture.Type.ThreeDimensional);
                break;
            }
            case TextureArray: {
                textureKey.setTextureTypeHint(Texture.Type.TwoDimensionalArray);
                break;
            }
            case TextureCubeMap: {
                textureKey.setTextureTypeHint(Texture.Type.CubeMap);
            }
        }
        textureKey.setGenerateMips(true);
        try {
            texture = this.assetManager.loadTexture(textureKey);
        }
        catch (AssetNotFoundException ex) {
            logger.log(Level.WARNING, "Cannot locate {0} for material {1}", new Object[]{textureKey, this.key});
            texture = null;
        }
        if (texture == null) {
            texture = new Texture2D(PlaceholderAssets.getPlaceholderImage(this.assetManager));
            texture.setKey(textureKey);
            texture.setName(textureKey.getName());
        }
        if (!textureOptionValues.isEmpty()) {
            for (TextureOptionValue textureOptionValue : textureOptionValues) {
                textureOptionValue.applyToTexture(texture);
            }
        }
        return texture;
    }

    private Object readValue(VarType type, String value) throws IOException {
        if (type.isTextureType()) {
            return this.parseTextureType(type, value);
        }
        String[] split = value.trim().split(whitespacePattern);
        switch (type) {
            case Float: {
                if (split.length != 1) {
                    throw new IOException("Float value parameter must have 1 entry: " + value);
                }
                return Float.valueOf(Float.parseFloat(split[0]));
            }
            case Vector2: {
                if (split.length != 2) {
                    throw new IOException("Vector2 value parameter must have 2 entries: " + value);
                }
                return new Vector2f(Float.parseFloat(split[0]), Float.parseFloat(split[1]));
            }
            case Vector3: {
                if (split.length != 3) {
                    throw new IOException("Vector3 value parameter must have 3 entries: " + value);
                }
                return new Vector3f(Float.parseFloat(split[0]), Float.parseFloat(split[1]), Float.parseFloat(split[2]));
            }
            case Vector4: {
                if (split.length != 4) {
                    throw new IOException("Vector4 value parameter must have 4 entries: " + value);
                }
                return new ColorRGBA(Float.parseFloat(split[0]), Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
            }
            case Int: {
                if (split.length != 1) {
                    throw new IOException("Int value parameter must have 1 entry: " + value);
                }
                return Integer.parseInt(split[0]);
            }
            case Boolean: {
                if (split.length != 1) {
                    throw new IOException("Boolean value parameter must have 1 entry: " + value);
                }
                return Boolean.parseBoolean(split[0]);
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)type));
    }

    private void readParam(String statement) throws IOException {
        int startParen;
        String defaultVal = null;
        ColorSpace colorSpace = null;
        String[] split = statement.split(":");
        if (split.length != 1) {
            if (split.length != 2) {
                throw new IOException("Parameter statement syntax incorrect");
            }
            statement = split[0].trim();
            defaultVal = split[1].trim();
        }
        if (statement.endsWith("-LINEAR")) {
            colorSpace = ColorSpace.Linear;
            statement = statement.substring(0, statement.length() - "-LINEAR".length());
        }
        if ((startParen = statement.indexOf("(")) != -1) {
            int endParen = statement.indexOf(")", startParen);
            String bindingStr = statement.substring(startParen + 1, endParen).trim();
            statement = statement.substring(0, startParen);
        }
        if ((split = statement.split(whitespacePattern)).length != 2) {
            throw new IOException("Parameter statement syntax incorrect");
        }
        VarType type = split[0].equals("Color") ? VarType.Vector4 : VarType.valueOf(split[0]);
        String name = split[1];
        Object defaultValObj = null;
        if (defaultVal != null) {
            defaultValObj = this.readValue(type, defaultVal);
        }
        if (type.isTextureType()) {
            this.materialDef.addMaterialParamTexture(type, name, colorSpace, (Texture)defaultValObj);
        } else {
            this.materialDef.addMaterialParam(type, name, defaultValObj);
        }
    }

    private void readValueParam(String statement) throws IOException {
        String[] split = statement.split(":", 2);
        if (split.length != 2) {
            throw new IOException("Value parameter statement syntax incorrect");
        }
        String name = split[0].trim();
        MatParam p = this.material.getMaterialDef().getMaterialParam(name);
        if (p == null) {
            throw new IOException("The material parameter: " + name + " is undefined.");
        }
        Object valueObj = this.readValue(p.getVarType(), split[1]);
        if (p.getVarType().isTextureType()) {
            this.material.setTextureParam(name, p.getVarType(), (Texture)valueObj);
        } else {
            this.material.setParam(name, p.getVarType(), valueObj);
        }
    }

    private void readMaterialParams(List<Statement> paramsList) throws IOException {
        for (Statement statement : paramsList) {
            this.readParam(statement.getLine());
        }
    }

    private void readExtendingMaterialParams(List<Statement> paramsList) throws IOException {
        for (Statement statement : paramsList) {
            this.readValueParam(statement.getLine());
        }
    }

    private void readWorldParams(List<Statement> worldParams) throws IOException {
        for (Statement statement : worldParams) {
            this.technique.addWorldParam(statement.getLine());
        }
    }

    private boolean parseBoolean(String word) {
        switch (word) {
            case "On": {
                return true;
            }
            case "Off": {
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    private void readRenderStateStatement(Statement statement) throws IOException {
        String[] split = statement.getLine().split(whitespacePattern);
        if (split[0].equals("Wireframe")) {
            this.renderState.setWireframe(this.parseBoolean(split[1]));
        } else if (split[0].equals("FaceCull")) {
            this.renderState.setFaceCullMode(RenderState.FaceCullMode.valueOf(split[1]));
        } else if (split[0].equals("DepthWrite")) {
            this.renderState.setDepthWrite(this.parseBoolean(split[1]));
        } else if (split[0].equals("DepthTest")) {
            this.renderState.setDepthTest(this.parseBoolean(split[1]));
        } else if (split[0].equals("Blend")) {
            this.renderState.setBlendMode(RenderState.BlendMode.valueOf(split[1]));
        } else if (split[0].equals("BlendEquation")) {
            this.renderState.setBlendEquation(RenderState.BlendEquation.valueOf(split[1]));
        } else if (split[0].equals("BlendEquationAlpha")) {
            this.renderState.setBlendEquationAlpha(RenderState.BlendEquationAlpha.valueOf(split[1]));
        } else if (!split[0].equals("AlphaTestFalloff")) {
            if (split[0].equals("PolyOffset")) {
                float factor = Float.parseFloat(split[1]);
                float units = Float.parseFloat(split[2]);
                this.renderState.setPolyOffset(factor, units);
            } else if (split[0].equals("ColorWrite")) {
                this.renderState.setColorWrite(this.parseBoolean(split[1]));
            } else if (!split[0].equals("PointSprite")) {
                if (split[0].equals("DepthFunc")) {
                    this.renderState.setDepthFunc(RenderState.TestFunction.valueOf(split[1]));
                } else if (split[0].equals("AlphaFunc")) {
                    this.renderState.setAlphaFunc(RenderState.TestFunction.valueOf(split[1]));
                } else if (split[0].equals("LineWidth")) {
                    this.renderState.setLineWidth(Float.parseFloat(split[1]));
                } else {
                    throw new MatParseException(null, split[0], statement);
                }
            }
        }
    }

    private void readAdditionalRenderState(List<Statement> renderStates) throws IOException {
        this.renderState = this.material.getAdditionalRenderState();
        for (Statement statement : renderStates) {
            this.readRenderStateStatement(statement);
        }
        this.renderState = null;
    }

    private void readRenderState(List<Statement> renderStates) throws IOException {
        this.renderState = new RenderState();
        for (Statement statement : renderStates) {
            this.readRenderStateStatement(statement);
        }
        this.technique.setRenderState(this.renderState);
        this.renderState = null;
    }

    private void readForcedRenderState(List<Statement> renderStates) throws IOException {
        this.renderState = new RenderState();
        for (Statement statement : renderStates) {
            this.readRenderStateStatement(statement);
        }
        this.technique.setForcedRenderState(this.renderState);
        this.renderState = null;
    }

    private void readDefine(String statement) throws IOException {
        String[] split = statement.split(":");
        if (split.length == 1) {
            String defineName = split[0].trim();
            this.presetDefines.add(defineName);
        } else if (split.length == 2) {
            String defineName = split[0].trim();
            String paramName = split[1].trim();
            MatParam param = this.materialDef.getMaterialParam(paramName);
            if (param == null) {
                logger.log(Level.WARNING, "In technique ''{0}'':\nDefine ''{1}'' mapped to non-existent material parameter ''{2}'', ignoring.", new Object[]{this.technique.getName(), defineName, paramName});
                return;
            }
            VarType paramType = param.getVarType();
            this.technique.addShaderParamDefine(paramName, paramType, defineName);
        } else {
            throw new IOException("Define syntax incorrect");
        }
    }

    private void readDefines(List<Statement> defineList) throws IOException {
        for (Statement statement : defineList) {
            this.readDefine(statement.getLine());
        }
    }

    private void readTechniqueStatement(Statement statement) throws IOException {
        String[] split = statement.getLine().split("[ \\{]");
        if (split[0].equals("VertexShader") || split[0].equals("FragmentShader") || split[0].equals("GeometryShader") || split[0].equals("TessellationControlShader") || split[0].equals("TessellationEvaluationShader")) {
            this.readShaderStatement(statement.getLine());
        } else if (split[0].equals("LightMode")) {
            this.readLightMode(statement.getLine());
        } else if (split[0].equals("LightSpace")) {
            this.readLightSpace(statement.getLine());
        } else if (split[0].equals("ShadowMode")) {
            this.readShadowMode(statement.getLine());
        } else if (split[0].equals("WorldParameters")) {
            this.readWorldParams(statement.getContents());
        } else if (split[0].equals("RenderState")) {
            this.readRenderState(statement.getContents());
        } else if (split[0].equals("ForcedRenderState")) {
            this.readForcedRenderState(statement.getContents());
        } else if (split[0].equals("Defines")) {
            this.readDefines(statement.getContents());
        } else if (split[0].equals("ShaderNodesDefinitions")) {
            this.initNodesLoader();
            if (this.isUseNodes) {
                this.nodesLoaderDelegate.readNodesDefinitions(statement.getContents());
            }
        } else if (split[0].equals("VertexShaderNodes")) {
            this.initNodesLoader();
            if (this.isUseNodes) {
                this.nodesLoaderDelegate.readVertexShaderNodes(statement.getContents());
            }
        } else if (split[0].equals("FragmentShaderNodes")) {
            this.initNodesLoader();
            if (this.isUseNodes) {
                this.nodesLoaderDelegate.readFragmentShaderNodes(statement.getContents());
            }
        } else if (split[0].equals("NoRender")) {
            this.technique.setNoRender(true);
        } else {
            throw new MatParseException(null, split[0], statement);
        }
    }

    private void readTransparentStatement(String statement) throws IOException {
        String[] split = statement.split(whitespacePattern);
        if (split.length != 2) {
            throw new IOException("Transparent statement syntax incorrect");
        }
        this.material.setTransparent(this.parseBoolean(split[1]));
    }

    private static String createShaderPrologue(List<String> presetDefines) {
        DefineList dl = new DefineList(presetDefines.size());
        for (int i = 0; i < presetDefines.size(); ++i) {
            dl.set(i, 1);
        }
        StringBuilder sb = new StringBuilder();
        dl.generateSource(sb, presetDefines, null);
        return sb.toString();
    }

    private void readTechnique(Statement techStat) throws IOException {
        String name;
        this.isUseNodes = false;
        String[] split = techStat.getLine().split(whitespacePattern);
        Cloner cloner = new Cloner();
        if (split.length == 1) {
            name = "Default";
        } else if (split.length == 2) {
            name = split[1];
        } else {
            throw new IOException("Technique statement syntax incorrect");
        }
        String techniqueUniqueName = this.materialDef.getAssetName() + "@" + name;
        this.technique = new TechniqueDef(name, techniqueUniqueName.hashCode());
        for (Statement statement : techStat.getContents()) {
            this.readTechniqueStatement(statement);
        }
        this.technique.setShaderPrologue(J3MLoader.createShaderPrologue(this.presetDefines));
        switch (this.technique.getLightMode()) {
            case Disable: {
                this.technique.setLogic(new DefaultTechniqueDefLogic(this.technique));
                break;
            }
            case MultiPass: {
                this.technique.setLogic(new MultiPassLightingLogic(this.technique));
                break;
            }
            case SinglePass: {
                this.technique.setLogic(new SinglePassLightingLogic(this.technique));
                break;
            }
            case StaticPass: {
                this.technique.setLogic(new StaticPassLightingLogic(this.technique));
                break;
            }
            case SinglePassAndImageBased: {
                this.technique.setLogic(new SinglePassAndImageBasedLightingLogic(this.technique));
                break;
            }
            default: {
                throw new IOException("Light mode not supported:" + (Object)((Object)this.technique.getLightMode()));
            }
        }
        ArrayList<TechniqueDef> techniqueDefs = new ArrayList<TechniqueDef>();
        if (this.isUseNodes) {
            this.technique.setShaderFile(this.technique.hashCode() + "", this.technique.hashCode() + "", "GLSL100", "GLSL100");
            techniqueDefs.add(this.technique);
        } else if (this.shaderNames.containsKey((Object)Shader.ShaderType.Vertex) && this.shaderNames.containsKey((Object)Shader.ShaderType.Fragment)) {
            if (this.shaderLanguages.size() > 1) {
                for (int i = 1; i < this.shaderLanguages.size(); ++i) {
                    cloner.clearIndex();
                    TechniqueDef td = cloner.clone(this.technique);
                    td.setShaderFile(this.shaderNames, this.shaderLanguages.get(i));
                    techniqueDefs.add(td);
                }
            }
            this.technique.setShaderFile(this.shaderNames, this.shaderLanguages.get(0));
            techniqueDefs.add(this.technique);
        } else {
            this.technique = null;
            this.shaderLanguages.clear();
            this.shaderNames.clear();
            this.presetDefines.clear();
            this.langSize = 0;
            logger.log(Level.WARNING, "Fixed function technique was ignored");
            logger.log(Level.WARNING, "Fixed function technique ''{0}'' was ignored for material {1}", new Object[]{name, this.key});
            return;
        }
        for (TechniqueDef techniqueDef : techniqueDefs) {
            this.materialDef.addTechniqueDef(techniqueDef);
        }
        this.technique = null;
        this.langSize = 0;
        this.shaderLanguages.clear();
        this.shaderNames.clear();
        this.presetDefines.clear();
    }

    private void loadFromRoot(List<Statement> roots) throws IOException {
        if (roots.size() == 2) {
            Statement exception = roots.get(0);
            String line = exception.getLine();
            if (line.startsWith("Exception")) {
                throw new AssetLoadException(line.substring("Exception ".length()));
            }
            throw new IOException("In multiroot material, expected first statement to be 'Exception'");
        }
        if (roots.size() != 1) {
            throw new IOException("Too many roots in J3M/J3MD file");
        }
        boolean extending = false;
        Statement materialStat = roots.get(0);
        String materialName = materialStat.getLine();
        if (materialName.startsWith("MaterialDef")) {
            materialName = materialName.substring("MaterialDef ".length()).trim();
            extending = false;
        } else if (materialName.startsWith("Material")) {
            materialName = materialName.substring("Material ".length()).trim();
            extending = true;
        } else {
            throw new IOException("Specified file is not a Material file");
        }
        String[] split = materialName.split(":", 2);
        if (materialName.equals("")) {
            throw new MatParseException("Material name cannot be empty", materialStat);
        }
        if (split.length == 2) {
            if (!extending) {
                throw new MatParseException("Must use 'Material' when extending.", materialStat);
            }
            String extendedMat = split[1].trim();
            MaterialDef def = (MaterialDef)this.assetManager.loadAsset(new AssetKey(extendedMat));
            if (def == null) {
                throw new MatParseException("Extended material " + extendedMat + " cannot be found.", materialStat);
            }
            this.material = new Material(def);
            this.material.setKey(this.key);
            this.material.setName(split[0].trim());
        } else if (split.length == 1) {
            if (extending) {
                throw new MatParseException("Expected ':', got '{'", materialStat);
            }
            this.materialDef = new MaterialDef(this.assetManager, materialName);
            this.materialDef.setAssetName(this.key.getName());
        } else {
            throw new MatParseException("Cannot use colon in material name/path", materialStat);
        }
        for (Statement statement : materialStat.getContents()) {
            split = statement.getLine().split("[ \\{]");
            String statType = split[0];
            if (extending) {
                if (statType.equals("MaterialParameters")) {
                    this.readExtendingMaterialParams(statement.getContents());
                    continue;
                }
                if (statType.equals("AdditionalRenderState")) {
                    this.readAdditionalRenderState(statement.getContents());
                    continue;
                }
                if (!statType.equals("Transparent")) continue;
                this.readTransparentStatement(statement.getLine());
                continue;
            }
            if (statType.equals("Technique")) {
                this.readTechnique(statement);
                continue;
            }
            if (statType.equals("MaterialParameters")) {
                this.readMaterialParams(statement.getContents());
                continue;
            }
            throw new MatParseException("Expected material statement, got '" + statType + "'", statement);
        }
    }

    @Override
    public Object load(AssetInfo info) throws IOException {
        this.assetManager = info.getManager();
        try (InputStream in = info.openStream();){
            this.key = info.getKey();
            if (this.key.getExtension().equals("j3m") && !(this.key instanceof MaterialKey)) {
                throw new IOException("Material instances must be loaded via MaterialKey");
            }
            if (this.key.getExtension().equals("j3md") && this.key instanceof MaterialKey) {
                throw new IOException("Material definitions must be loaded via AssetKey");
            }
            this.loadFromRoot(BlockLanguageParser.parse(in));
        }
        if (this.material != null) {
            return this.material;
        }
        return this.materialDef;
    }

    public MaterialDef loadMaterialDef(List<Statement> roots, AssetManager manager, AssetKey key) throws IOException {
        this.key = key;
        this.assetManager = manager;
        this.loadFromRoot(roots);
        return this.materialDef;
    }

    protected void initNodesLoader() {
        if (!this.isUseNodes) {
            boolean bl = this.isUseNodes = this.shaderNames.get((Object)Shader.ShaderType.Vertex) == null && this.shaderNames.get((Object)Shader.ShaderType.Fragment) == null;
            if (this.isUseNodes) {
                if (this.nodesLoaderDelegate == null) {
                    this.nodesLoaderDelegate = new ShaderNodeLoaderDelegate();
                } else {
                    this.nodesLoaderDelegate.clear();
                }
                this.nodesLoaderDelegate.setTechniqueDef(this.technique);
                this.nodesLoaderDelegate.setMaterialDef(this.materialDef);
                this.nodesLoaderDelegate.setAssetManager(this.assetManager);
            }
        }
    }

    private static class TextureOptionValue {
        private final TextureOption textureOption;
        private final String value;

        public TextureOptionValue(TextureOption textureOption, String value) {
            this.textureOption = textureOption;
            this.value = value;
        }

        public void applyToTextureKey(TextureKey textureKey) {
            this.textureOption.applyToTextureKey(this.value, textureKey);
        }

        public void applyToTexture(Texture texture) {
            this.textureOption.applyToTexture(this.value, texture);
        }
    }

    private static enum TextureOption {
        Min{

            @Override
            public void applyToTexture(String option, Texture texture) {
                texture.setMinFilter(Texture.MinFilter.valueOf(option));
            }
        }
        ,
        Mag{

            @Override
            public void applyToTexture(String option, Texture texture) {
                texture.setMagFilter(Texture.MagFilter.valueOf(option));
            }
        }
        ,
        Wrap{

            @Override
            public void applyToTexture(String option, Texture texture) {
                int separatorPosition = option.indexOf("_");
                if (separatorPosition >= option.length() - 2) {
                    String axis = option.substring(separatorPosition + 1);
                    String mode = option.substring(0, separatorPosition);
                    Texture.WrapAxis wrapAxis = Texture.WrapAxis.valueOf(axis);
                    texture.setWrap(wrapAxis, Texture.WrapMode.valueOf(mode));
                } else {
                    texture.setWrap(Texture.WrapMode.valueOf(option));
                }
            }
        }
        ,
        Repeat{

            @Override
            public void applyToTexture(String option, Texture texture) {
                Wrap.applyToTexture("Repeat", texture);
            }
        }
        ,
        Flip{

            @Override
            public void applyToTextureKey(String option, TextureKey textureKey) {
                textureKey.setFlipY(true);
            }
        };


        public String getOptionValue(String option) {
            return option.substring(this.name().length());
        }

        public void applyToTexture(String option, Texture texture) {
        }

        public void applyToTextureKey(String option, TextureKey textureKey) {
        }

        public static TextureOption getTextureOption(String option) {
            for (TextureOption textureOption : TextureOption.values()) {
                if (!option.startsWith(textureOption.name())) continue;
                return textureOption;
            }
            return null;
        }
    }
}

