/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;

public class RenderState
implements Cloneable,
Savable {
    public static final RenderState DEFAULT = new RenderState();
    public static final RenderState NULL = new RenderState();
    public static final RenderState ADDITIONAL = new RenderState();
    boolean wireframe = false;
    boolean applyWireFrame = true;
    FaceCullMode cullMode = FaceCullMode.Back;
    boolean applyCullMode = true;
    boolean depthWrite = true;
    boolean applyDepthWrite = true;
    boolean depthTest = true;
    boolean applyDepthTest = true;
    boolean colorWrite = true;
    boolean applyColorWrite = true;
    BlendEquation blendEquation = BlendEquation.Add;
    BlendEquationAlpha blendEquationAlpha = BlendEquationAlpha.InheritColor;
    BlendMode blendMode = BlendMode.Off;
    boolean applyBlendMode = true;
    float offsetFactor = 0.0f;
    float offsetUnits = 0.0f;
    boolean offsetEnabled = false;
    boolean applyPolyOffset = true;
    boolean stencilTest = false;
    boolean applyStencilTest = false;
    float lineWidth = 1.0f;
    boolean applyLineWidth = false;
    TestFunction depthFunc = TestFunction.LessOrEqual;
    boolean applyDepthFunc = false;
    StencilOperation frontStencilStencilFailOperation = StencilOperation.Keep;
    StencilOperation frontStencilDepthFailOperation = StencilOperation.Keep;
    StencilOperation frontStencilDepthPassOperation = StencilOperation.Keep;
    StencilOperation backStencilStencilFailOperation = StencilOperation.Keep;
    StencilOperation backStencilDepthFailOperation = StencilOperation.Keep;
    StencilOperation backStencilDepthPassOperation = StencilOperation.Keep;
    TestFunction frontStencilFunction = TestFunction.Always;
    TestFunction backStencilFunction = TestFunction.Always;
    int cachedHashCode = -1;
    BlendFunc sfactorRGB = BlendFunc.One;
    BlendFunc dfactorRGB = BlendFunc.One;
    BlendFunc sfactorAlpha = BlendFunc.One;
    BlendFunc dfactorAlpha = BlendFunc.One;

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(true, "pointSprite", false);
        oc.write(this.wireframe, "wireframe", false);
        oc.write(this.cullMode, "cullMode", FaceCullMode.Back);
        oc.write(this.depthWrite, "depthWrite", true);
        oc.write(this.depthTest, "depthTest", true);
        oc.write(this.colorWrite, "colorWrite", true);
        oc.write(this.blendMode, "blendMode", BlendMode.Off);
        oc.write(this.offsetEnabled, "offsetEnabled", false);
        oc.write(this.offsetFactor, "offsetFactor", 0.0f);
        oc.write(this.offsetUnits, "offsetUnits", 0.0f);
        oc.write(this.stencilTest, "stencilTest", false);
        oc.write(this.frontStencilStencilFailOperation, "frontStencilStencilFailOperation", StencilOperation.Keep);
        oc.write(this.frontStencilDepthFailOperation, "frontStencilDepthFailOperation", StencilOperation.Keep);
        oc.write(this.frontStencilDepthPassOperation, "frontStencilDepthPassOperation", StencilOperation.Keep);
        oc.write(this.backStencilStencilFailOperation, "frontStencilStencilFailOperation", StencilOperation.Keep);
        oc.write(this.backStencilDepthFailOperation, "backStencilDepthFailOperation", StencilOperation.Keep);
        oc.write(this.backStencilDepthPassOperation, "backStencilDepthPassOperation", StencilOperation.Keep);
        oc.write(this.frontStencilFunction, "frontStencilFunction", TestFunction.Always);
        oc.write(this.backStencilFunction, "backStencilFunction", TestFunction.Always);
        oc.write(this.blendEquation, "blendEquation", BlendEquation.Add);
        oc.write(this.blendEquationAlpha, "blendEquationAlpha", BlendEquationAlpha.InheritColor);
        oc.write(this.depthFunc, "depthFunc", TestFunction.LessOrEqual);
        oc.write(this.lineWidth, "lineWidth", 1.0f);
        oc.write(this.sfactorRGB, "sfactorRGB", this.sfactorRGB);
        oc.write(this.dfactorRGB, "dfactorRGB", this.dfactorRGB);
        oc.write(this.sfactorAlpha, "sfactorAlpha", this.sfactorAlpha);
        oc.write(this.dfactorAlpha, "dfactorAlpha", this.dfactorAlpha);
        oc.write(this.applyWireFrame, "applyWireFrame", true);
        oc.write(this.applyCullMode, "applyCullMode", true);
        oc.write(this.applyDepthWrite, "applyDepthWrite", true);
        oc.write(this.applyDepthTest, "applyDepthTest", true);
        oc.write(this.applyColorWrite, "applyColorWrite", true);
        oc.write(this.applyBlendMode, "applyBlendMode", true);
        oc.write(this.applyPolyOffset, "applyPolyOffset", true);
        oc.write(this.applyDepthFunc, "applyDepthFunc", true);
        oc.write(this.applyLineWidth, "applyLineWidth", true);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.wireframe = ic.readBoolean("wireframe", false);
        this.cullMode = ic.readEnum("cullMode", FaceCullMode.class, FaceCullMode.Back);
        this.depthWrite = ic.readBoolean("depthWrite", true);
        this.depthTest = ic.readBoolean("depthTest", true);
        this.colorWrite = ic.readBoolean("colorWrite", true);
        this.blendMode = ic.readEnum("blendMode", BlendMode.class, BlendMode.Off);
        this.offsetEnabled = ic.readBoolean("offsetEnabled", false);
        this.offsetFactor = ic.readFloat("offsetFactor", 0.0f);
        this.offsetUnits = ic.readFloat("offsetUnits", 0.0f);
        this.stencilTest = ic.readBoolean("stencilTest", false);
        this.frontStencilStencilFailOperation = ic.readEnum("frontStencilStencilFailOperation", StencilOperation.class, StencilOperation.Keep);
        this.frontStencilDepthFailOperation = ic.readEnum("frontStencilDepthFailOperation", StencilOperation.class, StencilOperation.Keep);
        this.frontStencilDepthPassOperation = ic.readEnum("frontStencilDepthPassOperation", StencilOperation.class, StencilOperation.Keep);
        this.backStencilStencilFailOperation = ic.readEnum("backStencilStencilFailOperation", StencilOperation.class, StencilOperation.Keep);
        this.backStencilDepthFailOperation = ic.readEnum("backStencilDepthFailOperation", StencilOperation.class, StencilOperation.Keep);
        this.backStencilDepthPassOperation = ic.readEnum("backStencilDepthPassOperation", StencilOperation.class, StencilOperation.Keep);
        this.frontStencilFunction = ic.readEnum("frontStencilFunction", TestFunction.class, TestFunction.Always);
        this.backStencilFunction = ic.readEnum("backStencilFunction", TestFunction.class, TestFunction.Always);
        this.blendEquation = ic.readEnum("blendEquation", BlendEquation.class, BlendEquation.Add);
        this.blendEquationAlpha = ic.readEnum("blendEquationAlpha", BlendEquationAlpha.class, BlendEquationAlpha.InheritColor);
        this.depthFunc = ic.readEnum("depthFunc", TestFunction.class, TestFunction.LessOrEqual);
        this.lineWidth = ic.readFloat("lineWidth", 1.0f);
        this.sfactorRGB = ic.readEnum("sfactorRGB", BlendFunc.class, BlendFunc.One);
        this.dfactorAlpha = ic.readEnum("dfactorRGB", BlendFunc.class, BlendFunc.One);
        this.sfactorRGB = ic.readEnum("sfactorAlpha", BlendFunc.class, BlendFunc.One);
        this.dfactorAlpha = ic.readEnum("dfactorAlpha", BlendFunc.class, BlendFunc.One);
        this.applyWireFrame = ic.readBoolean("applyWireFrame", true);
        this.applyCullMode = ic.readBoolean("applyCullMode", true);
        this.applyDepthWrite = ic.readBoolean("applyDepthWrite", true);
        this.applyDepthTest = ic.readBoolean("applyDepthTest", true);
        this.applyColorWrite = ic.readBoolean("applyColorWrite", true);
        this.applyBlendMode = ic.readBoolean("applyBlendMode", true);
        this.applyPolyOffset = ic.readBoolean("applyPolyOffset", true);
        this.applyDepthFunc = ic.readBoolean("applyDepthFunc", true);
        this.applyLineWidth = ic.readBoolean("applyLineWidth", true);
    }

    public RenderState clone() {
        try {
            return (RenderState)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RenderState)) {
            return false;
        }
        RenderState rs = (RenderState)o;
        if (this.wireframe != rs.wireframe) {
            return false;
        }
        if (this.cullMode != rs.cullMode) {
            return false;
        }
        if (this.depthWrite != rs.depthWrite) {
            return false;
        }
        if (this.depthTest != rs.depthTest) {
            return false;
        }
        if (this.depthTest && this.depthFunc != rs.depthFunc) {
            return false;
        }
        if (this.colorWrite != rs.colorWrite) {
            return false;
        }
        if (this.blendMode != rs.blendMode) {
            return false;
        }
        if (this.blendMode == BlendMode.Custom) {
            if (this.blendEquation != rs.blendEquation) {
                return false;
            }
            if (this.blendEquationAlpha != rs.blendEquationAlpha) {
                return false;
            }
            if (this.sfactorRGB != rs.sfactorRGB) {
                return false;
            }
            if (this.dfactorRGB != rs.dfactorRGB) {
                return false;
            }
            if (this.sfactorAlpha != rs.sfactorAlpha) {
                return false;
            }
            if (this.dfactorAlpha != rs.dfactorAlpha) {
                return false;
            }
        }
        if (this.offsetEnabled != rs.offsetEnabled) {
            return false;
        }
        if (this.offsetFactor != rs.offsetFactor) {
            return false;
        }
        if (this.offsetUnits != rs.offsetUnits) {
            return false;
        }
        if (this.stencilTest != rs.stencilTest) {
            return false;
        }
        if (this.stencilTest) {
            if (this.frontStencilStencilFailOperation != rs.frontStencilStencilFailOperation) {
                return false;
            }
            if (this.frontStencilDepthFailOperation != rs.frontStencilDepthFailOperation) {
                return false;
            }
            if (this.frontStencilDepthPassOperation != rs.frontStencilDepthPassOperation) {
                return false;
            }
            if (this.backStencilStencilFailOperation != rs.backStencilStencilFailOperation) {
                return false;
            }
            if (this.backStencilDepthFailOperation != rs.backStencilDepthFailOperation) {
                return false;
            }
            if (this.backStencilDepthPassOperation != rs.backStencilDepthPassOperation) {
                return false;
            }
            if (this.frontStencilFunction != rs.frontStencilFunction) {
                return false;
            }
            if (this.backStencilFunction != rs.backStencilFunction) {
                return false;
            }
        }
        return this.lineWidth == rs.lineWidth;
    }

    @Deprecated
    public void setPointSprite(boolean pointSprite) {
    }

    @Deprecated
    public void setAlphaFallOff(float alphaFallOff) {
    }

    @Deprecated
    public void setAlphaTest(boolean alphaTest) {
    }

    public void setColorWrite(boolean colorWrite) {
        this.applyColorWrite = true;
        this.colorWrite = colorWrite;
        this.cachedHashCode = -1;
    }

    public void setFaceCullMode(FaceCullMode cullMode) {
        this.applyCullMode = true;
        this.cullMode = cullMode;
        this.cachedHashCode = -1;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.applyBlendMode = true;
        this.blendMode = blendMode;
        this.cachedHashCode = -1;
    }

    public void setBlendEquation(BlendEquation blendEquation) {
        this.blendEquation = blendEquation;
        this.cachedHashCode = -1;
    }

    public void setBlendEquationAlpha(BlendEquationAlpha blendEquationAlpha) {
        this.blendEquationAlpha = blendEquationAlpha;
        this.cachedHashCode = -1;
    }

    public void setCustomBlendFactors(BlendFunc sfactorRGB, BlendFunc dfactorRGB, BlendFunc sfactorAlpha, BlendFunc dfactorAlpha) {
        this.sfactorRGB = sfactorRGB;
        this.dfactorRGB = dfactorRGB;
        this.sfactorAlpha = sfactorAlpha;
        this.dfactorAlpha = dfactorAlpha;
        this.cachedHashCode = -1;
    }

    public void setDepthTest(boolean depthTest) {
        this.applyDepthTest = true;
        this.depthTest = depthTest;
        this.cachedHashCode = -1;
    }

    public void setDepthWrite(boolean depthWrite) {
        this.applyDepthWrite = true;
        this.depthWrite = depthWrite;
        this.cachedHashCode = -1;
    }

    public void setWireframe(boolean wireframe) {
        this.applyWireFrame = true;
        this.wireframe = wireframe;
        this.cachedHashCode = -1;
    }

    public void setPolyOffset(float factor, float units) {
        this.applyPolyOffset = true;
        if (factor == 0.0f && units == 0.0f) {
            this.offsetEnabled = false;
        } else {
            this.offsetEnabled = true;
            this.offsetFactor = factor;
            this.offsetUnits = units;
        }
        this.cachedHashCode = -1;
    }

    public void setStencil(boolean enabled, StencilOperation _frontStencilStencilFailOperation, StencilOperation _frontStencilDepthFailOperation, StencilOperation _frontStencilDepthPassOperation, StencilOperation _backStencilStencilFailOperation, StencilOperation _backStencilDepthFailOperation, StencilOperation _backStencilDepthPassOperation, TestFunction _frontStencilFunction, TestFunction _backStencilFunction) {
        this.stencilTest = enabled;
        this.applyStencilTest = true;
        this.frontStencilStencilFailOperation = _frontStencilStencilFailOperation;
        this.frontStencilDepthFailOperation = _frontStencilDepthFailOperation;
        this.frontStencilDepthPassOperation = _frontStencilDepthPassOperation;
        this.backStencilStencilFailOperation = _backStencilStencilFailOperation;
        this.backStencilDepthFailOperation = _backStencilDepthFailOperation;
        this.backStencilDepthPassOperation = _backStencilDepthPassOperation;
        this.frontStencilFunction = _frontStencilFunction;
        this.backStencilFunction = _backStencilFunction;
        this.cachedHashCode = -1;
    }

    public void setDepthFunc(TestFunction depthFunc) {
        this.applyDepthFunc = true;
        this.depthFunc = depthFunc;
        this.cachedHashCode = -1;
    }

    @Deprecated
    public void setAlphaFunc(TestFunction alphaFunc) {
    }

    public void setLineWidth(float lineWidth) {
        if (lineWidth < 1.0f) {
            throw new IllegalArgumentException("lineWidth must be greater than or equal to 1.0");
        }
        this.lineWidth = lineWidth;
        this.applyLineWidth = true;
        this.cachedHashCode = -1;
    }

    public boolean isStencilTest() {
        return this.stencilTest;
    }

    public StencilOperation getFrontStencilStencilFailOperation() {
        return this.frontStencilStencilFailOperation;
    }

    public StencilOperation getFrontStencilDepthFailOperation() {
        return this.frontStencilDepthFailOperation;
    }

    public StencilOperation getFrontStencilDepthPassOperation() {
        return this.frontStencilDepthPassOperation;
    }

    public StencilOperation getBackStencilStencilFailOperation() {
        return this.backStencilStencilFailOperation;
    }

    public StencilOperation getBackStencilDepthFailOperation() {
        return this.backStencilDepthFailOperation;
    }

    public StencilOperation getBackStencilDepthPassOperation() {
        return this.backStencilDepthPassOperation;
    }

    public TestFunction getFrontStencilFunction() {
        return this.frontStencilFunction;
    }

    public TestFunction getBackStencilFunction() {
        return this.backStencilFunction;
    }

    public BlendEquation getBlendEquation() {
        return this.blendEquation;
    }

    public BlendEquationAlpha getBlendEquationAlpha() {
        return this.blendEquationAlpha;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public BlendFunc getCustomSfactorRGB() {
        return this.sfactorRGB;
    }

    public BlendFunc getCustomDfactorRGB() {
        return this.dfactorRGB;
    }

    public BlendFunc getCustomSfactorAlpha() {
        return this.sfactorAlpha;
    }

    public BlendFunc getCustomDfactorAlpha() {
        return this.dfactorAlpha;
    }

    @Deprecated
    public boolean isPointSprite() {
        return true;
    }

    @Deprecated
    public boolean isAlphaTest() {
        return false;
    }

    public FaceCullMode getFaceCullMode() {
        return this.cullMode;
    }

    public boolean isDepthTest() {
        return this.depthTest;
    }

    public boolean isDepthWrite() {
        return this.depthWrite;
    }

    public boolean isWireframe() {
        return this.wireframe;
    }

    public boolean isColorWrite() {
        return this.colorWrite;
    }

    public float getPolyOffsetFactor() {
        return this.offsetFactor;
    }

    public float getPolyOffsetUnits() {
        return this.offsetUnits;
    }

    public boolean isPolyOffset() {
        return this.offsetEnabled;
    }

    @Deprecated
    public float getAlphaFallOff() {
        return 0.0f;
    }

    public TestFunction getDepthFunc() {
        return this.depthFunc;
    }

    @Deprecated
    public TestFunction getAlphaFunc() {
        return TestFunction.Greater;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public boolean isApplyBlendMode() {
        return this.applyBlendMode;
    }

    public boolean isApplyColorWrite() {
        return this.applyColorWrite;
    }

    public boolean isApplyCullMode() {
        return this.applyCullMode;
    }

    public boolean isApplyDepthTest() {
        return this.applyDepthTest;
    }

    public boolean isApplyDepthWrite() {
        return this.applyDepthWrite;
    }

    public boolean isApplyPolyOffset() {
        return this.applyPolyOffset;
    }

    public boolean isApplyWireFrame() {
        return this.applyWireFrame;
    }

    public boolean isApplyDepthFunc() {
        return this.applyDepthFunc;
    }

    public boolean isApplyLineWidth() {
        return this.applyLineWidth;
    }

    public int contentHashCode() {
        if (this.cachedHashCode == -1) {
            int hash = 7;
            hash = 79 * hash + (this.wireframe ? 1 : 0);
            hash = 79 * hash + (this.cullMode != null ? this.cullMode.hashCode() : 0);
            hash = 79 * hash + (this.depthWrite ? 1 : 0);
            hash = 79 * hash + (this.depthTest ? 1 : 0);
            hash = 79 * hash + (this.depthFunc != null ? this.depthFunc.hashCode() : 0);
            hash = 79 * hash + (this.colorWrite ? 1 : 0);
            hash = 79 * hash + (this.blendMode != null ? this.blendMode.hashCode() : 0);
            hash = 79 * hash + (this.blendEquation != null ? this.blendEquation.hashCode() : 0);
            hash = 79 * hash + (this.blendEquationAlpha != null ? this.blendEquationAlpha.hashCode() : 0);
            hash = 79 * hash + Float.floatToIntBits(this.offsetFactor);
            hash = 79 * hash + Float.floatToIntBits(this.offsetUnits);
            hash = 79 * hash + (this.offsetEnabled ? 1 : 0);
            hash = 79 * hash + (this.stencilTest ? 1 : 0);
            hash = 79 * hash + (this.frontStencilStencilFailOperation != null ? this.frontStencilStencilFailOperation.hashCode() : 0);
            hash = 79 * hash + (this.frontStencilDepthFailOperation != null ? this.frontStencilDepthFailOperation.hashCode() : 0);
            hash = 79 * hash + (this.frontStencilDepthPassOperation != null ? this.frontStencilDepthPassOperation.hashCode() : 0);
            hash = 79 * hash + (this.backStencilStencilFailOperation != null ? this.backStencilStencilFailOperation.hashCode() : 0);
            hash = 79 * hash + (this.backStencilDepthFailOperation != null ? this.backStencilDepthFailOperation.hashCode() : 0);
            hash = 79 * hash + (this.backStencilDepthPassOperation != null ? this.backStencilDepthPassOperation.hashCode() : 0);
            hash = 79 * hash + (this.frontStencilFunction != null ? this.frontStencilFunction.hashCode() : 0);
            hash = 79 * hash + (this.backStencilFunction != null ? this.backStencilFunction.hashCode() : 0);
            hash = 79 * hash + Float.floatToIntBits(this.lineWidth);
            hash = 79 * hash + this.sfactorRGB.hashCode();
            hash = 79 * hash + this.dfactorRGB.hashCode();
            hash = 79 * hash + this.sfactorAlpha.hashCode();
            this.cachedHashCode = hash = 79 * hash + this.dfactorAlpha.hashCode();
        }
        return this.cachedHashCode;
    }

    public RenderState copyMergedTo(RenderState additionalState, RenderState state) {
        if (additionalState == null) {
            return this;
        }
        state.wireframe = additionalState.applyWireFrame ? additionalState.wireframe : this.wireframe;
        state.cullMode = additionalState.applyCullMode ? additionalState.cullMode : this.cullMode;
        state.depthWrite = additionalState.applyDepthWrite ? additionalState.depthWrite : this.depthWrite;
        state.depthTest = additionalState.applyDepthTest ? additionalState.depthTest : this.depthTest;
        state.depthFunc = additionalState.applyDepthFunc ? additionalState.depthFunc : this.depthFunc;
        state.colorWrite = additionalState.applyColorWrite ? additionalState.colorWrite : this.colorWrite;
        if (additionalState.applyBlendMode) {
            state.blendMode = additionalState.blendMode;
            if (additionalState.blendMode == BlendMode.Custom) {
                state.blendEquation = additionalState.blendEquation;
                state.blendEquationAlpha = additionalState.blendEquationAlpha;
                state.sfactorRGB = additionalState.sfactorRGB;
                state.dfactorRGB = additionalState.dfactorRGB;
                state.sfactorAlpha = additionalState.sfactorAlpha;
                state.dfactorAlpha = additionalState.dfactorAlpha;
            }
        } else {
            state.blendMode = this.blendMode;
            if (this.blendMode == BlendMode.Custom) {
                state.blendEquation = this.blendEquation;
                state.blendEquationAlpha = this.blendEquationAlpha;
                state.sfactorRGB = this.sfactorRGB;
                state.dfactorRGB = this.dfactorRGB;
                state.sfactorAlpha = this.sfactorAlpha;
                state.dfactorAlpha = this.dfactorAlpha;
            }
        }
        if (additionalState.applyPolyOffset) {
            state.offsetEnabled = additionalState.offsetEnabled;
            state.offsetFactor = additionalState.offsetFactor;
            state.offsetUnits = additionalState.offsetUnits;
        } else {
            state.offsetEnabled = this.offsetEnabled;
            state.offsetFactor = this.offsetFactor;
            state.offsetUnits = this.offsetUnits;
        }
        if (additionalState.applyStencilTest) {
            state.stencilTest = additionalState.stencilTest;
            state.frontStencilStencilFailOperation = additionalState.frontStencilStencilFailOperation;
            state.frontStencilDepthFailOperation = additionalState.frontStencilDepthFailOperation;
            state.frontStencilDepthPassOperation = additionalState.frontStencilDepthPassOperation;
            state.backStencilStencilFailOperation = additionalState.backStencilStencilFailOperation;
            state.backStencilDepthFailOperation = additionalState.backStencilDepthFailOperation;
            state.backStencilDepthPassOperation = additionalState.backStencilDepthPassOperation;
            state.frontStencilFunction = additionalState.frontStencilFunction;
            state.backStencilFunction = additionalState.backStencilFunction;
        } else {
            state.stencilTest = this.stencilTest;
            state.frontStencilStencilFailOperation = this.frontStencilStencilFailOperation;
            state.frontStencilDepthFailOperation = this.frontStencilDepthFailOperation;
            state.frontStencilDepthPassOperation = this.frontStencilDepthPassOperation;
            state.backStencilStencilFailOperation = this.backStencilStencilFailOperation;
            state.backStencilDepthFailOperation = this.backStencilDepthFailOperation;
            state.backStencilDepthPassOperation = this.backStencilDepthPassOperation;
            state.frontStencilFunction = this.frontStencilFunction;
            state.backStencilFunction = this.backStencilFunction;
        }
        state.lineWidth = additionalState.applyLineWidth ? additionalState.lineWidth : this.lineWidth;
        state.cachedHashCode = -1;
        return state;
    }

    public void set(RenderState state) {
        this.wireframe = state.wireframe;
        this.cullMode = state.cullMode;
        this.depthWrite = state.depthWrite;
        this.depthTest = state.depthTest;
        this.colorWrite = state.colorWrite;
        this.blendMode = state.blendMode;
        this.offsetEnabled = state.offsetEnabled;
        this.offsetFactor = state.offsetFactor;
        this.offsetUnits = state.offsetUnits;
        this.stencilTest = state.stencilTest;
        this.frontStencilStencilFailOperation = state.frontStencilStencilFailOperation;
        this.frontStencilDepthFailOperation = state.frontStencilDepthFailOperation;
        this.frontStencilDepthPassOperation = state.frontStencilDepthPassOperation;
        this.backStencilStencilFailOperation = state.backStencilStencilFailOperation;
        this.backStencilDepthFailOperation = state.backStencilDepthFailOperation;
        this.backStencilDepthPassOperation = state.backStencilDepthPassOperation;
        this.frontStencilFunction = state.frontStencilFunction;
        this.backStencilFunction = state.backStencilFunction;
        this.blendEquationAlpha = state.blendEquationAlpha;
        this.blendEquation = state.blendEquation;
        this.depthFunc = state.depthFunc;
        this.lineWidth = state.lineWidth;
        this.applyWireFrame = true;
        this.applyCullMode = true;
        this.applyDepthWrite = true;
        this.applyDepthTest = true;
        this.applyColorWrite = true;
        this.applyBlendMode = true;
        this.applyPolyOffset = true;
        this.applyDepthFunc = true;
        this.applyLineWidth = true;
        this.sfactorRGB = state.sfactorRGB;
        this.dfactorRGB = state.dfactorRGB;
        this.sfactorAlpha = state.sfactorAlpha;
        this.dfactorAlpha = state.dfactorAlpha;
    }

    public String toString() {
        return "RenderState[\n\nwireframe=" + this.wireframe + "\napplyWireFrame=" + this.applyWireFrame + "\ncullMode=" + (Object)((Object)this.cullMode) + "\napplyCullMode=" + this.applyCullMode + "\ndepthWrite=" + this.depthWrite + "\napplyDepthWrite=" + this.applyDepthWrite + "\ndepthTest=" + this.depthTest + "\ndepthFunc=" + (Object)((Object)this.depthFunc) + "\napplyDepthTest=" + this.applyDepthTest + "\ncolorWrite=" + this.colorWrite + "\napplyColorWrite=" + this.applyColorWrite + "\nblendEquation=" + (Object)((Object)this.blendEquation) + "\nblendMode=" + (Object)((Object)this.blendMode) + "\napplyBlendMode=" + this.applyBlendMode + "\noffsetEnabled=" + this.offsetEnabled + "\napplyPolyOffset=" + this.applyPolyOffset + "\noffsetFactor=" + this.offsetFactor + "\noffsetUnits=" + this.offsetUnits + "\nlineWidth=" + this.lineWidth + (this.blendMode.equals((Object)BlendMode.Custom) ? "\ncustomBlendFactors=(" + (Object)((Object)this.sfactorRGB) + ", " + (Object)((Object)this.dfactorRGB) + ", " + (Object)((Object)this.sfactorAlpha) + ", " + (Object)((Object)this.dfactorAlpha) + ")" : "") + "\n]";
    }

    static {
        RenderState.NULL.cullMode = FaceCullMode.Off;
        RenderState.NULL.depthTest = false;
        RenderState.ADDITIONAL.applyWireFrame = false;
        RenderState.ADDITIONAL.applyCullMode = false;
        RenderState.ADDITIONAL.applyDepthWrite = false;
        RenderState.ADDITIONAL.applyDepthTest = false;
        RenderState.ADDITIONAL.applyColorWrite = false;
        RenderState.ADDITIONAL.applyBlendMode = false;
        RenderState.ADDITIONAL.applyPolyOffset = false;
    }

    public static enum StencilOperation {
        Keep,
        Zero,
        Replace,
        Increment,
        IncrementWrap,
        Decrement,
        DecrementWrap,
        Invert;

    }

    public static enum FaceCullMode {
        Off,
        Front,
        Back,
        FrontAndBack;

    }

    public static enum BlendMode {
        Off,
        Additive,
        PremultAlpha,
        AlphaAdditive,
        Color,
        Alpha,
        AlphaSumA,
        Modulate,
        ModulateX2,
        Screen,
        Exclusion,
        Custom;

    }

    public static enum BlendFunc {
        Zero,
        One,
        Src_Color,
        One_Minus_Src_Color,
        Dst_Color,
        One_Minus_Dst_Color,
        Src_Alpha,
        One_Minus_Src_Alpha,
        Dst_Alpha,
        One_Minus_Dst_Alpha,
        Src_Alpha_Saturate;

    }

    public static enum BlendEquationAlpha {
        InheritColor,
        Add,
        Subtract,
        ReverseSubtract,
        Min,
        Max;

    }

    public static enum BlendEquation {
        Add,
        Subtract,
        ReverseSubtract,
        Min,
        Max;

    }

    public static enum TestFunction {
        Never,
        Equal,
        Less,
        LessOrEqual,
        Greater,
        GreaterOrEqual,
        NotEqual,
        Always;

    }
}

