/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.light.ProbeArea;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Plane;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.util.TempVars;
import java.io.IOException;

public class OrientedBoxProbeArea
implements ProbeArea {
    private Transform transform = new Transform();
    private Matrix4f uniformMatrix = new Matrix4f();

    public OrientedBoxProbeArea() {
    }

    public OrientedBoxProbeArea(Transform transform) {
        this.transform.set(transform);
        this.updateMatrix();
    }

    @Override
    public boolean intersectsBox(BoundingBox box, TempVars vars) {
        Vector3f axis1 = this.getScaledAxis(0, vars.vect1);
        Vector3f axis2 = this.getScaledAxis(1, vars.vect2);
        Vector3f axis3 = this.getScaledAxis(2, vars.vect3);
        Vector3f tn = vars.vect4;
        Plane p = vars.plane;
        Vector3f c = box.getCenter();
        p.setNormal(0.0f, 0.0f, -1.0f);
        p.setConstant(-(c.z + box.getZExtent()));
        if (!this.insidePlane(p, axis1, axis2, axis3, tn)) {
            return false;
        }
        p.setNormal(0.0f, 0.0f, 1.0f);
        p.setConstant(c.z - box.getZExtent());
        if (!this.insidePlane(p, axis1, axis2, axis3, tn)) {
            return false;
        }
        p.setNormal(0.0f, -1.0f, 0.0f);
        p.setConstant(-(c.y + box.getYExtent()));
        if (!this.insidePlane(p, axis1, axis2, axis3, tn)) {
            return false;
        }
        p.setNormal(0.0f, 1.0f, 0.0f);
        p.setConstant(c.y - box.getYExtent());
        if (!this.insidePlane(p, axis1, axis2, axis3, tn)) {
            return false;
        }
        p.setNormal(-1.0f, 0.0f, 0.0f);
        p.setConstant(-(c.x + box.getXExtent()));
        if (!this.insidePlane(p, axis1, axis2, axis3, tn)) {
            return false;
        }
        p.setNormal(1.0f, 0.0f, 0.0f);
        p.setConstant(c.x - box.getXExtent());
        return this.insidePlane(p, axis1, axis2, axis3, tn);
    }

    @Override
    public float getRadius() {
        return Math.max(Math.max(this.transform.getScale().x, this.transform.getScale().y), this.transform.getScale().z);
    }

    @Override
    public void setRadius(float radius) {
        this.transform.setScale(radius, radius, radius);
    }

    @Override
    public boolean intersectsSphere(BoundingSphere sphere, TempVars vars) {
        Vector3f closestPoint = this.getClosestPoint(vars, sphere.getCenter());
        return sphere.intersects(closestPoint);
    }

    @Override
    public boolean intersectsFrustum(Camera camera, TempVars vars) {
        Vector3f axis1 = this.getScaledAxis(0, vars.vect1);
        Vector3f axis2 = this.getScaledAxis(1, vars.vect2);
        Vector3f axis3 = this.getScaledAxis(2, vars.vect3);
        Vector3f tn = vars.vect4;
        for (int i = 5; i >= 0; --i) {
            Plane p = camera.getWorldPlane(i);
            if (this.insidePlane(p, axis1, axis2, axis3, tn)) continue;
            return false;
        }
        return true;
    }

    private Vector3f getScaledAxis(int index, Vector3f store) {
        Matrix4f u = this.uniformMatrix;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float s = 1.0f;
        switch (index) {
            case 0: {
                x = u.m00;
                y = u.m10;
                z = u.m20;
                s = u.m30;
                break;
            }
            case 1: {
                x = u.m01;
                y = u.m11;
                z = u.m21;
                s = u.m31;
                break;
            }
            case 2: {
                x = u.m02;
                y = u.m12;
                z = u.m22;
                s = u.m32;
            }
        }
        return store.set(x, y, z).multLocal(s);
    }

    private boolean insidePlane(Plane p, Vector3f axis1, Vector3f axis2, Vector3f axis3, Vector3f tn) {
        tn.set(axis1.dot(p.getNormal()), axis2.dot(p.getNormal()), axis3.dot(p.getNormal()));
        float radius = FastMath.abs(tn.x) + FastMath.abs(tn.y) + FastMath.abs(tn.z);
        float distance = p.pseudoDistance(this.transform.getTranslation());
        return !(distance < -radius);
    }

    private Vector3f getClosestPoint(TempVars vars, Vector3f point) {
        Vector3f dir = vars.vect2.set(point).subtractLocal(this.transform.getTranslation());
        Vector3f closestPoint = vars.vect3.set(this.transform.getTranslation());
        float[] r = vars.fWdU;
        r[0] = this.transform.getScale().x;
        r[1] = this.transform.getScale().y;
        r[2] = this.transform.getScale().z;
        for (int i = 0; i < 3; ++i) {
            Vector3f axis = this.getScaledAxis(i, vars.vect1);
            axis.divideLocal(r[i]);
            float d = FastMath.clamp(dir.dot(axis), -r[i], r[i]);
            closestPoint.addLocal(vars.vect4.set(axis).multLocal(d));
        }
        return closestPoint;
    }

    private void updateMatrix() {
        TempVars vars = TempVars.get();
        Matrix3f r = vars.tempMat3;
        Matrix4f u = this.uniformMatrix;
        this.transform.getRotation().toRotationMatrix(r);
        u.m00 = r.get(0, 0);
        u.m10 = r.get(1, 0);
        u.m20 = r.get(2, 0);
        u.m01 = r.get(0, 1);
        u.m11 = r.get(1, 1);
        u.m21 = r.get(2, 1);
        u.m02 = r.get(0, 2);
        u.m12 = r.get(1, 2);
        u.m22 = r.get(2, 2);
        u.m30 = this.transform.getScale().x;
        u.m31 = this.transform.getScale().y;
        u.m32 = this.transform.getScale().z;
        u.m03 = this.transform.getTranslation().x;
        u.m13 = this.transform.getTranslation().y;
        u.m23 = this.transform.getTranslation().z;
        vars.release();
    }

    @Override
    public Matrix4f getUniformMatrix() {
        return this.uniformMatrix;
    }

    public Vector3f getExtent() {
        return this.transform.getScale();
    }

    public void setExtent(Vector3f extent) {
        this.transform.setScale(extent);
        this.updateMatrix();
    }

    public Vector3f getCenter() {
        return this.transform.getTranslation();
    }

    @Override
    public void setCenter(Vector3f center) {
        this.transform.setTranslation(center);
        this.updateMatrix();
    }

    public Quaternion getRotation() {
        return this.transform.getRotation();
    }

    public void setRotation(Quaternion rotation) {
        this.transform.setRotation(rotation);
        this.updateMatrix();
    }

    protected OrientedBoxProbeArea clone() throws CloneNotSupportedException {
        return new OrientedBoxProbeArea(this.transform);
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        OutputCapsule oc = e.getCapsule(this);
        oc.write(this.transform, "transform", new Transform());
    }

    @Override
    public void read(JmeImporter i) throws IOException {
        InputCapsule ic = i.getCapsule(this);
        this.transform = (Transform)ic.readSavable("transform", new Transform());
        this.updateMatrix();
    }
}

