/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JoystickCompatibilityMappings {
    private static final Logger logger = Logger.getLogger(JoystickCompatibilityMappings.class.getName());
    private static String[] searchPaths = new String[]{"joystick-mapping.properties"};
    private static Map<String, Map<String, String>> joystickMappings = new HashMap<String, Map<String, String>>();
    private static Map<Pattern, String> nameRemappings = new HashMap<Pattern, String>();
    private static Map<String, String> nameCache = new HashMap<String, String>();

    protected static Map<String, String> getMappings(String joystickName, boolean create) {
        Map<String, String> result = joystickMappings.get(joystickName.trim());
        if (result == null && create) {
            result = new HashMap<String, String>();
            joystickMappings.put(joystickName.trim(), result);
        }
        return result;
    }

    public static String remapComponent(String joystickName, String componentId) {
        logger.log(Level.FINE, "remapComponent(" + joystickName + ", " + componentId + ")");
        joystickName = joystickName.trim();
        Map<String, String> map = JoystickCompatibilityMappings.getMappings(joystickName, false);
        if (map != null && map.containsKey(componentId)) {
            logger.log(Level.FINE, "returning remapped:" + map.get(componentId));
            return map.get(componentId);
        }
        joystickName = JoystickCompatibilityMappings.getNormalizedName(joystickName);
        logger.log(Level.FINE, "normalized joystick name:" + joystickName);
        if (joystickName == null) {
            return componentId;
        }
        map = JoystickCompatibilityMappings.getMappings(joystickName, false);
        if (map == null) {
            return componentId;
        }
        if (!map.containsKey(componentId)) {
            return componentId;
        }
        logger.log(Level.FINE, "returning remapped:" + map.get(componentId));
        return map.get(componentId);
    }

    public static Map<String, String> getJoystickMappings(String joystickName) {
        Map<String, String> result = JoystickCompatibilityMappings.getMappings(joystickName.trim(), false);
        if (result == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(result);
    }

    public static void addMapping(String stickName, String sourceComponentId, String remapId) {
        logger.log(Level.FINE, "addMapping(" + stickName + ", " + sourceComponentId + ", " + remapId + ")");
        JoystickCompatibilityMappings.getMappings(stickName, true).put(sourceComponentId, remapId);
    }

    public static void addMappings(Properties p) {
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            String key = String.valueOf(e.getKey()).trim();
            int split = key.lastIndexOf(46);
            if (split < 0) {
                logger.log(Level.WARNING, "Skipping mapping:{0}", e);
                continue;
            }
            String stick = key.substring(0, split).trim();
            String component = key.substring(split + 1).trim();
            String value = String.valueOf(e.getValue()).trim();
            if ("regex".equals(component)) {
                JoystickCompatibilityMappings.addJoystickNameRegex(value, stick);
            }
            JoystickCompatibilityMappings.addMapping(stick, component, value);
        }
    }

    public static void addJoystickNameRegex(String regex, String name) {
        logger.log(Level.FINE, "addJoystickNameRegex(" + regex + ", " + name + ")");
        nameRemappings.put(Pattern.compile(regex), name);
    }

    protected static String getNormalizedName(String name) {
        String result = nameCache.get(name);
        if (result != null) {
            return result;
        }
        for (Map.Entry<Pattern, String> e : nameRemappings.entrySet()) {
            Pattern p = e.getKey();
            Matcher m = p.matcher(name);
            if (!m.matches()) continue;
            nameCache.put(name, e.getValue());
            return e.getValue();
        }
        return null;
    }

    public static void loadMappingProperties(URL u) throws IOException {
        logger.log(Level.FINE, "Loading mapping properties:{0}", u);
        try (InputStream in = u.openStream();){
            Properties p = new Properties();
            p.load(in);
            JoystickCompatibilityMappings.addMappings(p);
        }
    }

    protected static void loadMappings(ClassLoader cl, String path) throws IOException {
        logger.log(Level.FINE, "Searching for mappings for path:{0}", path);
        Enumeration<URL> en = cl.getResources(path);
        while (en.hasMoreElements()) {
            URL u = en.nextElement();
            try {
                JoystickCompatibilityMappings.loadMappingProperties(u);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error loading:" + u, e);
            }
        }
    }

    protected static void loadDefaultMappings() {
        for (String s : searchPaths) {
            try {
                JoystickCompatibilityMappings.loadMappings(JoystickCompatibilityMappings.class.getClassLoader(), s);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error searching resource path:{0}", s);
            }
        }
    }

    static {
        JoystickCompatibilityMappings.loadDefaultMappings();
    }
}

