/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input;

import com.jme3.collision.MotionAllowedListener;
import com.jme3.input.InputManager;
import com.jme3.input.Joystick;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseAxisTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;

public class FlyByCamera
implements AnalogListener,
ActionListener {
    private static String[] mappings = new String[]{"FLYCAM_Left", "FLYCAM_Right", "FLYCAM_Up", "FLYCAM_Down", "FLYCAM_StrafeLeft", "FLYCAM_StrafeRight", "FLYCAM_Forward", "FLYCAM_Backward", "FLYCAM_ZoomIn", "FLYCAM_ZoomOut", "FLYCAM_RotateDrag", "FLYCAM_Rise", "FLYCAM_Lower", "FLYCAM_InvertY"};
    protected Camera cam;
    protected Vector3f initialUpVec;
    protected float rotationSpeed = 1.0f;
    protected float moveSpeed = 3.0f;
    protected float zoomSpeed = 1.0f;
    protected MotionAllowedListener motionAllowed = null;
    protected boolean enabled = true;
    protected boolean dragToRotate = false;
    protected boolean canRotate = false;
    protected boolean invertY = false;
    protected InputManager inputManager;

    public FlyByCamera(Camera cam) {
        this.cam = cam;
        this.initialUpVec = cam.getUp().clone();
    }

    public void setUpVector(Vector3f upVec) {
        this.initialUpVec.set(upVec);
    }

    public void setMotionAllowedListener(MotionAllowedListener listener) {
        this.motionAllowed = listener;
    }

    public void setMoveSpeed(float moveSpeed) {
        this.moveSpeed = moveSpeed;
    }

    public float getMoveSpeed() {
        return this.moveSpeed;
    }

    public void setRotationSpeed(float rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setZoomSpeed(float zoomSpeed) {
        this.zoomSpeed = zoomSpeed;
    }

    public float getZoomSpeed() {
        return this.zoomSpeed;
    }

    public void setEnabled(boolean enable) {
        if (this.enabled && !enable && this.inputManager != null && (!this.dragToRotate || this.dragToRotate && this.canRotate)) {
            this.inputManager.setCursorVisible(true);
        }
        this.enabled = enable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDragToRotate() {
        return this.dragToRotate;
    }

    public void setDragToRotate(boolean dragToRotate) {
        this.dragToRotate = dragToRotate;
        if (this.inputManager != null) {
            this.inputManager.setCursorVisible(dragToRotate);
        }
    }

    public void registerWithInput(InputManager inputManager) {
        this.inputManager = inputManager;
        inputManager.addMapping("FLYCAM_Left", new MouseAxisTrigger(0, true), new KeyTrigger(203));
        inputManager.addMapping("FLYCAM_Right", new MouseAxisTrigger(0, false), new KeyTrigger(205));
        inputManager.addMapping("FLYCAM_Up", new MouseAxisTrigger(1, false), new KeyTrigger(200));
        inputManager.addMapping("FLYCAM_Down", new MouseAxisTrigger(1, true), new KeyTrigger(208));
        inputManager.addMapping("FLYCAM_ZoomIn", new MouseAxisTrigger(2, false));
        inputManager.addMapping("FLYCAM_ZoomOut", new MouseAxisTrigger(2, true));
        inputManager.addMapping("FLYCAM_RotateDrag", new MouseButtonTrigger(0));
        inputManager.addMapping("FLYCAM_StrafeLeft", new KeyTrigger(30));
        inputManager.addMapping("FLYCAM_StrafeRight", new KeyTrigger(32));
        inputManager.addMapping("FLYCAM_Forward", new KeyTrigger(17));
        inputManager.addMapping("FLYCAM_Backward", new KeyTrigger(31));
        inputManager.addMapping("FLYCAM_Rise", new KeyTrigger(16));
        inputManager.addMapping("FLYCAM_Lower", new KeyTrigger(44));
        inputManager.addListener(this, mappings);
        inputManager.setCursorVisible(this.dragToRotate || !this.isEnabled());
        Joystick[] joysticks = inputManager.getJoysticks();
        if (joysticks != null && joysticks.length > 0) {
            for (Joystick j : joysticks) {
                this.mapJoystick(j);
            }
        }
    }

    protected void mapJoystick(Joystick joystick) {
        if (joystick.getAxis("rz") != null && joystick.getAxis("z") != null) {
            joystick.getXAxis().assignAxis("FLYCAM_StrafeRight", "FLYCAM_StrafeLeft");
            joystick.getYAxis().assignAxis("FLYCAM_Backward", "FLYCAM_Forward");
            joystick.getAxis("rz").assignAxis("FLYCAM_Down", "FLYCAM_Up");
            joystick.getAxis("z").assignAxis("FLYCAM_Right", "FLYCAM_Left");
            joystick.getPovYAxis().assignAxis("FLYCAM_Rise", "FLYCAM_Lower");
            if (joystick.getButton("Button 8") != null) {
                joystick.getButton("Button 8").assignButton("FLYCAM_InvertY");
            }
        } else {
            joystick.getPovXAxis().assignAxis("FLYCAM_StrafeRight", "FLYCAM_StrafeLeft");
            joystick.getPovYAxis().assignAxis("FLYCAM_Forward", "FLYCAM_Backward");
            joystick.getXAxis().assignAxis("FLYCAM_Right", "FLYCAM_Left");
            joystick.getYAxis().assignAxis("FLYCAM_Down", "FLYCAM_Up");
        }
    }

    public void unregisterInput() {
        if (this.inputManager == null) {
            return;
        }
        for (String s : mappings) {
            if (!this.inputManager.hasMapping(s)) continue;
            this.inputManager.deleteMapping(s);
        }
        this.inputManager.removeListener(this);
        this.inputManager.setCursorVisible(!this.dragToRotate);
        Joystick[] joysticks = this.inputManager.getJoysticks();
        if (joysticks == null || joysticks.length > 0) {
            // empty if block
        }
    }

    protected void rotateCamera(float value, Vector3f axis) {
        if (this.dragToRotate && !this.canRotate) {
            return;
        }
        Matrix3f mat = new Matrix3f();
        mat.fromAngleNormalAxis(this.rotationSpeed * value, axis);
        Vector3f up = this.cam.getUp();
        Vector3f left = this.cam.getLeft();
        Vector3f dir = this.cam.getDirection();
        mat.mult(up, up);
        mat.mult(left, left);
        mat.mult(dir, dir);
        Quaternion q = new Quaternion();
        q.fromAxes(left, up, dir);
        q.normalizeLocal();
        this.cam.setAxes(q);
    }

    protected void zoomCamera(float value) {
        float h = this.cam.getFrustumTop();
        float w = this.cam.getFrustumRight();
        float aspect = w / h;
        float near = this.cam.getFrustumNear();
        float fovY = FastMath.atan(h / near) / ((float)Math.PI / 360);
        float newFovY = fovY + value * 0.1f * this.zoomSpeed;
        if (newFovY > 0.0f) {
            fovY = newFovY;
        }
        h = FastMath.tan(fovY * ((float)Math.PI / 180) * 0.5f) * near;
        w = h * aspect;
        this.cam.setFrustumTop(h);
        this.cam.setFrustumBottom(-h);
        this.cam.setFrustumLeft(-w);
        this.cam.setFrustumRight(w);
    }

    protected void riseCamera(float value) {
        Vector3f vel = this.initialUpVec.mult(value * this.moveSpeed);
        Vector3f pos = this.cam.getLocation().clone();
        if (this.motionAllowed != null) {
            this.motionAllowed.checkMotionAllowed(pos, vel);
        } else {
            pos.addLocal(vel);
        }
        this.cam.setLocation(pos);
    }

    protected void moveCamera(float value, boolean sideways) {
        Vector3f vel = new Vector3f();
        Vector3f pos = this.cam.getLocation().clone();
        if (sideways) {
            this.cam.getLeft(vel);
        } else {
            this.cam.getDirection(vel);
        }
        vel.multLocal(value * this.moveSpeed);
        if (this.motionAllowed != null) {
            this.motionAllowed.checkMotionAllowed(pos, vel);
        } else {
            pos.addLocal(vel);
        }
        this.cam.setLocation(pos);
    }

    @Override
    public void onAnalog(String name, float value, float tpf) {
        if (!this.enabled) {
            return;
        }
        if (name.equals("FLYCAM_Left")) {
            this.rotateCamera(value, this.initialUpVec);
        } else if (name.equals("FLYCAM_Right")) {
            this.rotateCamera(-value, this.initialUpVec);
        } else if (name.equals("FLYCAM_Up")) {
            this.rotateCamera(-value * (float)(this.invertY ? -1 : 1), this.cam.getLeft());
        } else if (name.equals("FLYCAM_Down")) {
            this.rotateCamera(value * (float)(this.invertY ? -1 : 1), this.cam.getLeft());
        } else if (name.equals("FLYCAM_Forward")) {
            this.moveCamera(value, false);
        } else if (name.equals("FLYCAM_Backward")) {
            this.moveCamera(-value, false);
        } else if (name.equals("FLYCAM_StrafeLeft")) {
            this.moveCamera(value, true);
        } else if (name.equals("FLYCAM_StrafeRight")) {
            this.moveCamera(-value, true);
        } else if (name.equals("FLYCAM_Rise")) {
            this.riseCamera(value);
        } else if (name.equals("FLYCAM_Lower")) {
            this.riseCamera(-value);
        } else if (name.equals("FLYCAM_ZoomIn")) {
            this.zoomCamera(value);
        } else if (name.equals("FLYCAM_ZoomOut")) {
            this.zoomCamera(-value);
        }
    }

    @Override
    public void onAction(String name, boolean value, float tpf) {
        if (!this.enabled) {
            return;
        }
        if (name.equals("FLYCAM_RotateDrag") && this.dragToRotate) {
            this.canRotate = value;
            this.inputManager.setCursorVisible(!value);
        } else if (name.equals("FLYCAM_InvertY") && !value) {
            this.invertY = !this.invertY;
        }
    }
}

