/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export;

import com.jme3.animation.Animation;
import com.jme3.effect.shapes.EmitterBoxShape;
import com.jme3.effect.shapes.EmitterMeshConvexHullShape;
import com.jme3.effect.shapes.EmitterMeshFaceShape;
import com.jme3.effect.shapes.EmitterMeshVertexShape;
import com.jme3.effect.shapes.EmitterPointShape;
import com.jme3.effect.shapes.EmitterSphereShape;
import com.jme3.export.NullSavable;
import com.jme3.export.Savable;
import com.jme3.material.MatParamTexture;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SavableClassUtil {
    private static final HashMap<String, String> CLASS_REMAPPINGS = new HashMap();

    private static void addRemapping(String oldClass, Class<? extends Savable> newClass) {
        CLASS_REMAPPINGS.put(oldClass, newClass.getName());
    }

    private static String remapClass(String className) throws ClassNotFoundException {
        String result = CLASS_REMAPPINGS.get(className);
        if (result == null) {
            return className;
        }
        return result;
    }

    public static boolean isImplementingSavable(Class clazz) {
        boolean result = Savable.class.isAssignableFrom(clazz);
        return result;
    }

    public static int[] getSavableVersions(Class<? extends Savable> clazz) throws IOException {
        ArrayList<Integer> versionList = new ArrayList<Integer>();
        Class<? extends Savable> superclass = clazz;
        do {
            versionList.add(SavableClassUtil.getSavableVersion(superclass));
        } while ((superclass = superclass.getSuperclass()) != null && SavableClassUtil.isImplementingSavable(superclass));
        int[] versions = new int[versionList.size()];
        for (int i = 0; i < versionList.size(); ++i) {
            versions[i] = (Integer)versionList.get(i);
        }
        return versions;
    }

    public static int getSavableVersion(Class<? extends Savable> clazz) throws IOException {
        try {
            Field field = clazz.getField("SAVABLE_VERSION");
            Class<?> declaringClass = field.getDeclaringClass();
            if (declaringClass == clazz) {
                return field.getInt(null);
            }
            return 0;
        }
        catch (IllegalAccessException ex) {
            IOException ioEx = new IOException();
            ioEx.initCause(ex);
            throw ioEx;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (NoSuchFieldException ex) {
            return 0;
        }
    }

    public static int getSavedSavableVersion(Object savable, Class<? extends Savable> desiredClass, int[] versions, int formatVersion) {
        Class<?> thisClass = savable.getClass();
        int count = 0;
        while (thisClass != desiredClass && (thisClass = thisClass.getSuperclass()) != null && SavableClassUtil.isImplementingSavable(thisClass)) {
            ++count;
        }
        if (thisClass == null) {
            throw new IllegalArgumentException(savable.getClass().getName() + " does not extend " + desiredClass.getName() + "!");
        }
        if (count >= versions.length) {
            if (formatVersion <= 1) {
                return 0;
            }
            throw new IllegalArgumentException(savable.getClass().getName() + " cannot access version of " + desiredClass.getName() + " because it doesn't implement Savable");
        }
        return versions[count];
    }

    public static Savable fromName(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        className = SavableClassUtil.remapClass(className);
        Constructor noArgConstructor = SavableClassUtil.findNoArgConstructor(className);
        noArgConstructor.setAccessible(true);
        try {
            return (Savable)noArgConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException | InvocationTargetException e) {
            Logger.getLogger(SavableClassUtil.class.getName()).log(Level.SEVERE, "Could not access constructor of class ''{0}''! \nSome types need to have the BinaryImporter set up in a special way. Please doublecheck the setup.", className);
            throw e;
        }
        catch (IllegalAccessException e) {
            Logger.getLogger(SavableClassUtil.class.getName()).log(Level.SEVERE, "{0} \nSome types need to have the BinaryImporter set up in a special way. Please doublecheck the setup.", e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Savable fromName(String className, List<ClassLoader> loaders) throws InstantiationException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException, IOException {
        if (loaders == null) {
            return SavableClassUtil.fromName(className);
        }
        String newClassName = SavableClassUtil.remapClass(className);
        List<ClassLoader> list = loaders;
        synchronized (list) {
            for (ClassLoader classLoader : loaders) {
                Class<?> loadedClass;
                try {
                    loadedClass = classLoader.loadClass(newClassName);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                try {
                    return (Savable)loadedClass.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
            }
        }
        return SavableClassUtil.fromName(className);
    }

    private static Constructor findNoArgConstructor(String className) throws ClassNotFoundException, InstantiationException {
        Constructor<?> result;
        Class<?> clazz = Class.forName(className);
        try {
            result = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException("Loading requires a no-arg constructor, but class " + className + " lacks one.");
        }
        return result;
    }

    static {
        SavableClassUtil.addRemapping("com.jme3.effect.EmitterSphereShape", EmitterSphereShape.class);
        SavableClassUtil.addRemapping("com.jme3.effect.EmitterBoxShape", EmitterBoxShape.class);
        SavableClassUtil.addRemapping("com.jme3.effect.EmitterMeshConvexHullShape", EmitterMeshConvexHullShape.class);
        SavableClassUtil.addRemapping("com.jme3.effect.EmitterMeshFaceShape", EmitterMeshFaceShape.class);
        SavableClassUtil.addRemapping("com.jme3.effect.EmitterMeshVertexShape", EmitterMeshVertexShape.class);
        SavableClassUtil.addRemapping("com.jme3.effect.EmitterPointShape", EmitterPointShape.class);
        SavableClassUtil.addRemapping("com.jme3.material.Material$MatParamTexture", MatParamTexture.class);
        SavableClassUtil.addRemapping("com.jme3.animation.BoneAnimation", Animation.class);
        SavableClassUtil.addRemapping("com.jme3.animation.SpatialAnimation", Animation.class);
        SavableClassUtil.addRemapping("com.jme3.scene.plugins.blender.objects.Properties", NullSavable.class);
    }
}

