/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.profile.AppProfiler;
import com.jme3.profile.AppStep;
import com.jme3.profile.SpStep;
import com.jme3.profile.VpStep;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DetailedProfiler
implements AppProfiler {
    private static final int MAX_FRAMES = 100;
    private Map<String, StatLine> data;
    private Map<String, StatLine> pool;
    private long startFrame;
    private static int currentFrame = 0;
    private String prevPath = null;
    private boolean frameEnded = false;
    private Renderer renderer;
    private boolean ongoingGpuProfiling = false;
    private String curAppPath = null;
    private String curVpPath = null;
    private String curSpPath = null;
    private VpStep lastVpStep = null;
    private StringBuilder path = new StringBuilder(256);
    private StringBuilder vpPath = new StringBuilder(256);
    private Deque<Integer> idsPool = new ArrayDeque<Integer>(100);
    StatLine frameTime;

    @Override
    public void appStep(AppStep step) {
        this.curAppPath = step.name();
        if (step == AppStep.BeginFrame) {
            if (this.data == null) {
                this.data = new LinkedHashMap<String, StatLine>();
                this.pool = new HashMap<String, StatLine>();
                this.frameTime = new StatLine(currentFrame);
            }
            if (this.frameTime.isActive()) {
                this.frameTime.setValueCpu(System.nanoTime() - this.frameTime.getValueCpu());
                this.frameTime.closeFrame();
            }
            this.frameTime.setNewFrameValueCpu(System.nanoTime());
            this.frameEnded = false;
            for (StatLine statLine : this.data.values()) {
                Iterator<Integer> i = statLine.taskIds.iterator();
                while (i.hasNext()) {
                    int id = i.next();
                    if (!this.renderer.isTaskResultAvailable(id)) continue;
                    long val = this.renderer.getProfilingTime(id);
                    statLine.setValueGpu(val);
                    i.remove();
                    this.idsPool.push(id);
                }
            }
            this.data.clear();
        }
        if (this.data != null) {
            String path = this.getPath(step.name(), new String[0]);
            if (step == AppStep.EndFrame) {
                if (this.frameEnded) {
                    return;
                }
                this.addStep(path, System.nanoTime());
                StatLine end = this.data.get(path);
                end.setValueCpu(System.nanoTime() - this.startFrame);
                this.frameEnded = true;
            } else {
                this.addStep(path, System.nanoTime());
            }
        }
        if (step == AppStep.EndFrame) {
            this.closeFrame();
        }
    }

    @Override
    public void appSubStep(String ... additionalInfo) {
        if (this.data != null) {
            String pathStep = this.getPath("", additionalInfo);
            this.path.setLength(0);
            this.path.append(this.curAppPath).append(pathStep);
            this.addStep(this.path.toString(), System.nanoTime());
        }
    }

    private void closeFrame() {
        if (this.data != null) {
            if (this.ongoingGpuProfiling && this.renderer != null) {
                this.renderer.stopProfiling();
                this.ongoingGpuProfiling = false;
            }
            this.prevPath = null;
            for (StatLine statLine : this.data.values()) {
                statLine.closeFrame();
            }
            ++currentFrame;
        }
    }

    @Override
    public void vpStep(VpStep step, ViewPort vp, RenderQueue.Bucket bucket) {
        if (this.data != null) {
            this.vpPath.setLength(0);
            this.vpPath.append(vp.getName()).append("/").append(bucket == null ? step.name() : bucket.name() + " Bucket");
            this.path.setLength(0);
            if ((this.lastVpStep == VpStep.PostQueue || this.lastVpStep == VpStep.PostFrame) && bucket != null) {
                this.path.append(this.curAppPath).append("/").append(this.curVpPath).append(this.curSpPath).append("/").append((CharSequence)this.vpPath);
                this.curVpPath = this.vpPath.toString();
            } else if (bucket != null) {
                this.path.append(this.curAppPath).append("/").append(this.curVpPath).append("/").append(bucket.name() + " Bucket");
            } else {
                this.path.append(this.curAppPath).append("/").append((CharSequence)this.vpPath);
                this.curVpPath = this.vpPath.toString();
            }
            this.lastVpStep = step;
            this.addStep(this.path.toString(), System.nanoTime());
        }
    }

    @Override
    public void spStep(SpStep step, String ... additionalInfo) {
        if (this.data != null) {
            this.curSpPath = this.getPath("", additionalInfo);
            this.path.setLength(0);
            this.path.append(this.curAppPath).append("/").append(this.curVpPath).append(this.curSpPath);
            this.addStep(this.path.toString(), System.nanoTime());
        }
    }

    public Map<String, StatLine> getStats() {
        if (this.data != null) {
            return this.data;
        }
        return null;
    }

    public double getAverageFrameTime() {
        return this.frameTime.getAverageCpu();
    }

    private void addStep(String path, long value) {
        StatLine line;
        StatLine prevLine;
        if (this.ongoingGpuProfiling && this.renderer != null) {
            this.renderer.stopProfiling();
            this.ongoingGpuProfiling = false;
        }
        if (this.prevPath != null && (prevLine = this.data.get(this.prevPath)) != null) {
            prevLine.setValueCpu(value - prevLine.getValueCpu());
        }
        if ((line = this.pool.get(path)) == null) {
            line = new StatLine(currentFrame);
            this.pool.put(path, line);
        }
        this.data.put(path, line);
        line.setNewFrameValueCpu(value);
        if (this.renderer != null) {
            int id = this.getUnusedTaskId();
            line.taskIds.add(id);
            this.renderer.startProfiling(id);
        }
        this.ongoingGpuProfiling = true;
        this.prevPath = path;
    }

    private String getPath(String step, String ... subPath) {
        StringBuilder path = new StringBuilder(step);
        if (subPath != null) {
            for (String s : subPath) {
                path.append("/").append(s);
            }
        }
        return path.toString();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
        this.poolTaskIds(renderer);
    }

    private void poolTaskIds(Renderer renderer) {
        int[] ids;
        for (int id : ids = renderer.generateProfilingTasks(100)) {
            this.idsPool.push(id);
        }
    }

    private int getUnusedTaskId() {
        if (this.idsPool.isEmpty()) {
            this.poolTaskIds(this.renderer);
        }
        return this.idsPool.pop();
    }

    public static class StatLine {
        private long[] cpuTimes = new long[100];
        private long[] gpuTimes = new long[100];
        private int startCursor = 0;
        private int cpuCursor = 0;
        private int gpuCursor = 0;
        private long cpuSum = 0L;
        private long gpuSum = 0L;
        private long lastValue = 0L;
        private int nbFramesCpu;
        private int nbFramesGpu;
        List<Integer> taskIds = new ArrayList<Integer>();

        private StatLine(int currentFrame) {
            this.cpuCursor = this.startCursor = currentFrame % 100;
            this.gpuCursor = this.startCursor;
        }

        private void setNewFrameValueCpu(long value) {
            int newCursor = currentFrame % 100;
            if (this.nbFramesCpu == 0) {
                this.startCursor = newCursor;
            }
            this.cpuCursor = newCursor;
            this.lastValue = value;
        }

        private void setValueCpu(long val) {
            this.lastValue = val;
        }

        private long getValueCpu() {
            return this.lastValue;
        }

        private void closeFrame() {
            if (this.isActive()) {
                this.cpuSum -= this.cpuTimes[this.cpuCursor];
                this.cpuTimes[this.cpuCursor] = this.lastValue;
                this.cpuSum += this.lastValue;
                ++this.nbFramesCpu;
            } else {
                this.nbFramesCpu = 0;
            }
        }

        public void setValueGpu(long value) {
            this.gpuSum -= this.gpuTimes[this.gpuCursor];
            this.gpuTimes[this.gpuCursor] = value;
            this.gpuSum += value;
            ++this.nbFramesGpu;
            this.gpuCursor = (this.gpuCursor + 1) % 100;
        }

        public boolean isActive() {
            return this.cpuCursor >= currentFrame % 100 - 1;
        }

        public double getAverageCpu() {
            if (this.nbFramesCpu == 0) {
                return 0.0;
            }
            return (double)this.cpuSum / (double)Math.min(this.nbFramesCpu, 100);
        }

        public double getAverageGpu() {
            if (this.nbFramesGpu == 0) {
                return 0.0;
            }
            return (double)this.gpuSum / (double)Math.min(this.nbFramesGpu, 100);
        }
    }
}

