/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.ClonableTrack;
import com.jme3.animation.Track;
import com.jme3.animation.TrackInfo;
import com.jme3.effect.ParticleEmitter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class EffectTrack
implements ClonableTrack {
    private static final Logger logger = Logger.getLogger(EffectTrack.class.getName());
    private ParticleEmitter emitter;
    private float startOffset = 0.0f;
    private float particlesPerSeconds = 0.0f;
    private float length = 0.0f;
    private boolean emitted = false;
    private boolean initialized = false;
    private KillParticleControl killParticles = new KillParticleControl();

    protected EffectTrack() {
    }

    public EffectTrack(ParticleEmitter emitter, float length) {
        this.emitter = emitter;
        this.particlesPerSeconds = emitter.getParticlesPerSec();
        this.emitter.setParticlesPerSec(0.0f);
        this.length = length;
        this.setUserData(this);
    }

    public EffectTrack(ParticleEmitter emitter, float length, float startOffset) {
        this(emitter, length);
        this.startOffset = startOffset;
    }

    @Override
    public void setTime(float time, float weight, AnimControl control, AnimChannel channel, TempVars vars) {
        if (time >= this.length) {
            return;
        }
        if (!this.initialized) {
            control.addListener(new OnEndListener());
            this.initialized = true;
        }
        if (!this.emitted && time >= this.startOffset) {
            this.emitted = true;
            this.emitter.setCullHint(Spatial.CullHint.Dynamic);
            this.emitter.setEnabled(true);
            if (this.particlesPerSeconds == 0.0f) {
                this.emitter.emitAllParticles();
                if (!this.killParticles.stopRequested) {
                    this.emitter.addControl(this.killParticles);
                    this.killParticles.stopRequested = true;
                }
            } else {
                this.emitter.setParticlesPerSec(this.particlesPerSeconds);
            }
        }
    }

    private void stop() {
        this.emitter.setParticlesPerSec(0.0f);
        this.emitted = false;
        if (!this.killParticles.stopRequested) {
            this.emitter.addControl(this.killParticles);
            this.killParticles.stopRequested = true;
        }
    }

    @Override
    public float getLength() {
        return this.length;
    }

    @Override
    public float[] getKeyFrameTimes() {
        return new float[]{this.startOffset};
    }

    @Override
    public Track clone() {
        return new EffectTrack(this.emitter, this.length, this.startOffset);
    }

    @Override
    public Track cloneForSpatial(Spatial spatial) {
        EffectTrack effectTrack = new EffectTrack();
        effectTrack.particlesPerSeconds = this.particlesPerSeconds;
        effectTrack.length = this.length;
        effectTrack.startOffset = this.startOffset;
        effectTrack.emitter = this.findEmitter(spatial);
        if (effectTrack.emitter == null) {
            logger.log(Level.WARNING, "{0} was not found in {1} or is not bound to this track", new Object[]{this.emitter.getName(), spatial.getName()});
            effectTrack.emitter = this.emitter;
        }
        this.removeUserData(this);
        this.setUserData(effectTrack);
        effectTrack.emitter.setParticlesPerSec(0.0f);
        return effectTrack;
    }

    @Override
    public Object jmeClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning", e);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.emitter = cloner.clone(this.emitter);
    }

    private ParticleEmitter findEmitter(Spatial spat) {
        if (spat instanceof ParticleEmitter) {
            ParticleEmitter em = (ParticleEmitter)spat;
            TrackInfo t = (TrackInfo)em.getUserData("TrackInfo");
            if (t != null && t.getTracks().contains(this)) {
                return em;
            }
            return null;
        }
        if (spat instanceof Node) {
            for (Spatial child : ((Node)spat).getChildren()) {
                ParticleEmitter em = this.findEmitter(child);
                if (em == null) continue;
                return em;
            }
        }
        return null;
    }

    @Override
    public void cleanUp() {
        TrackInfo t = (TrackInfo)this.emitter.getUserData("TrackInfo");
        t.getTracks().remove(this);
        if (t.getTracks().isEmpty()) {
            this.emitter.setUserData("TrackInfo", null);
        }
    }

    public ParticleEmitter getEmitter() {
        return this.emitter;
    }

    public void setEmitter(ParticleEmitter emitter) {
        if (this.emitter != null) {
            TrackInfo data = (TrackInfo)emitter.getUserData("TrackInfo");
            data.getTracks().remove(this);
        }
        this.emitter = emitter;
        this.particlesPerSeconds = emitter.getParticlesPerSec();
        this.emitter.setParticlesPerSec(0.0f);
        this.setUserData(this);
    }

    public float getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(float startOffset) {
        this.startOffset = startOffset;
    }

    private void setUserData(EffectTrack effectTrack) {
        TrackInfo data = (TrackInfo)effectTrack.emitter.getUserData("TrackInfo");
        if (data == null) {
            data = new TrackInfo();
            effectTrack.emitter.setUserData("TrackInfo", data);
        }
        data.addTrack(effectTrack);
    }

    private void removeUserData(EffectTrack effectTrack) {
        TrackInfo data = (TrackInfo)effectTrack.emitter.getUserData("TrackInfo");
        if (data == null) {
            return;
        }
        data.getTracks().remove(effectTrack);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule out = ex.getCapsule(this);
        this.emitter.setParticlesPerSec(this.particlesPerSeconds);
        out.write(this.emitter, "emitter", null);
        out.write(this.particlesPerSeconds, "particlesPerSeconds", 0.0f);
        out.write(this.length, "length", 0.0f);
        out.write(this.startOffset, "startOffset", 0.0f);
        this.emitter.setParticlesPerSec(0.0f);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.particlesPerSeconds = in.readFloat("particlesPerSeconds", 0.0f);
        this.emitter = (ParticleEmitter)in.readSavable("emitter", null);
        this.emitter.setParticlesPerSec(0.0f);
        this.length = in.readFloat("length", this.length);
        this.startOffset = in.readFloat("startOffset", 0.0f);
    }

    private class OnEndListener
    implements AnimEventListener {
        private OnEndListener() {
        }

        @Override
        public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
            EffectTrack.this.stop();
        }

        @Override
        public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
        }
    }

    public static class KillParticleControl
    extends AbstractControl {
        ParticleEmitter emitter;
        boolean stopRequested = false;
        boolean remove = false;

        @Override
        public void setSpatial(Spatial spatial) {
            super.setSpatial(spatial);
            if (spatial != null) {
                if (spatial instanceof ParticleEmitter) {
                    this.emitter = (ParticleEmitter)spatial;
                } else {
                    throw new IllegalArgumentException("KillParticleEmitter can only ba attached to ParticleEmitter");
                }
            }
        }

        @Override
        protected void controlUpdate(float tpf) {
            if (this.remove) {
                this.emitter.removeControl(this);
                return;
            }
            if (this.emitter.getNumVisibleParticles() == 0) {
                this.emitter.setCullHint(Spatial.CullHint.Always);
                this.emitter.setEnabled(false);
                this.emitter.removeControl(this);
                this.stopRequested = false;
            }
        }

        @Override
        public Object jmeClone() {
            KillParticleControl c = new KillParticleControl();
            c.remove = true;
            c.spatial = this.spatial;
            return c;
        }

        @Override
        protected void controlRender(RenderManager rm, ViewPort vp) {
        }
    }
}

