/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim.tween.action;

import com.jme3.anim.tween.action.Action;
import com.jme3.anim.tween.action.BlendAction;
import com.jme3.anim.tween.action.BlendSpace;

public class LinearBlendSpace
implements BlendSpace {
    private BlendAction action;
    private float value;
    private float maxValue;
    private float minValue;
    private float step;

    public LinearBlendSpace(float minValue, float maxValue) {
        this.maxValue = maxValue;
        this.minValue = minValue;
    }

    @Override
    public void setBlendAction(BlendAction action) {
        this.action = action;
        Action[] actions = action.getActions();
        this.step = (this.maxValue - this.minValue) / (float)(actions.length - 1);
    }

    @Override
    public float getWeight() {
        float highStep;
        Action[] actions = this.action.getActions();
        float lowStep = this.minValue;
        int lowIndex = 0;
        int highIndex = 0;
        int i = 0;
        for (highStep = this.minValue; i < actions.length && highStep < this.value; highStep += this.step) {
            lowStep = highStep;
            lowIndex = i++;
        }
        highIndex = lowIndex + 1;
        this.action.setFirstActiveIndex(lowIndex);
        this.action.setSecondActiveIndex(highIndex);
        if (highStep == lowStep) {
            return 0.0f;
        }
        return (this.value - lowStep) / (highStep - lowStep);
    }

    @Override
    public void setValue(float value) {
        this.value = value;
    }
}

