/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim.tween.action;

import com.jme3.anim.tween.action.Action;
import com.jme3.anim.tween.action.BlendSpace;
import com.jme3.anim.tween.action.BlendableAction;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.math.Transform;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BlendAction
extends BlendableAction {
    private int firstActiveIndex;
    private int secondActiveIndex;
    private BlendSpace blendSpace;
    private float blendWeight;
    private double[] timeFactor;
    private Map<HasLocalTransform, Transform> targetMap = new HashMap<HasLocalTransform, Transform>();

    public BlendAction(BlendSpace blendSpace, BlendableAction ... actions) {
        super(actions);
        this.timeFactor = new double[actions.length];
        this.blendSpace = blendSpace;
        blendSpace.setBlendAction(this);
        for (BlendableAction action : actions) {
            if (action.getLength() > this.getLength()) {
                this.setLength(action.getLength());
            }
            Collection<HasLocalTransform> targets = action.getTargets();
            for (HasLocalTransform target : targets) {
                Transform t = this.targetMap.get(target);
                if (t != null) continue;
                t = new Transform();
                this.targetMap.put(target, t);
            }
        }
        for (int i = 0; i < this.actions.length; ++i) {
            double actionLength;
            this.timeFactor[i] = 1.0;
            if (this.actions[i].getLength() == this.getLength() || !((actionLength = this.actions[i].getLength()) > 0.0) || !(this.getLength() > 0.0)) continue;
            this.timeFactor[i] = this.actions[i].getLength() / this.getLength();
        }
    }

    @Override
    public void doInterpolate(double t) {
        this.blendWeight = this.blendSpace.getWeight();
        BlendableAction firstActiveAction = (BlendableAction)this.actions[this.firstActiveIndex];
        BlendableAction secondActiveAction = (BlendableAction)this.actions[this.secondActiveIndex];
        firstActiveAction.setCollectTransformDelegate(this);
        secondActiveAction.setCollectTransformDelegate(this);
        if (this.blendWeight < 1.0f) {
            firstActiveAction.setWeight(1.0f);
            firstActiveAction.interpolate(t * this.timeFactor[this.firstActiveIndex]);
            if (this.blendWeight == 0.0f) {
                for (HasLocalTransform target : this.targetMap.keySet()) {
                    this.collect(target, this.targetMap.get(target));
                }
            }
        }
        secondActiveAction.setWeight(this.blendWeight);
        secondActiveAction.interpolate(t * this.timeFactor[this.secondActiveIndex]);
        firstActiveAction.setCollectTransformDelegate(null);
        secondActiveAction.setCollectTransformDelegate(null);
    }

    protected Action[] getActions() {
        return this.actions;
    }

    public BlendSpace getBlendSpace() {
        return this.blendSpace;
    }

    protected void setFirstActiveIndex(int index) {
        this.firstActiveIndex = index;
    }

    protected void setSecondActiveIndex(int index) {
        this.secondActiveIndex = index;
    }

    @Override
    public Collection<HasLocalTransform> getTargets() {
        return this.targetMap.keySet();
    }

    @Override
    public void collectTransform(HasLocalTransform target, Transform t, float weight, BlendableAction source) {
        Transform tr = this.targetMap.get(target);
        if (weight == 1.0f) {
            tr.set(t);
        } else if (weight > 0.0f) {
            tr.interpolateTransforms(tr, t, weight);
        }
        if (source == this.actions[this.secondActiveIndex]) {
            this.collect(target, tr);
        }
    }

    private void collect(HasLocalTransform target, Transform tr) {
        if (this.collectTransformDelegate != null) {
            this.collectTransformDelegate.collectTransform(target, tr, this.getWeight(), this);
        } else if (this.getTransitionWeight() == 1.0f) {
            target.setLocalTransform(tr);
        } else {
            Transform trans = target.getLocalTransform();
            trans.interpolateTransforms(trans, tr, this.getTransitionWeight());
            target.setLocalTransform(trans);
        }
    }
}

