/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.export.Savable;
import com.jme3.material.MatParam;
import com.jme3.material.MatParamOverride;
import com.jme3.material.Material;
import com.jme3.renderer.Limits;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.RendererException;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.mesh.MorphTarget;
import com.jme3.shader.VarType;
import com.jme3.util.BufferUtils;
import com.jme3.util.SafeArrayList;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MorphControl
extends AbstractControl
implements Savable {
    private static final Logger logger = Logger.getLogger(MorphControl.class.getName());
    private static final int MAX_MORPH_BUFFERS = 14;
    private static final float MIN_WEIGHT = 0.005f;
    private SafeArrayList<Geometry> targets = new SafeArrayList<Geometry>(Geometry.class);
    private TargetLocator targetLocator = new TargetLocator();
    private boolean approximateTangents = true;
    private MatParamOverride nullNumberOfBones = new MatParamOverride(VarType.Int, "NumberOfBones", null);
    private float[] tmpPosArray;
    private float[] tmpNormArray;
    private float[] tmpTanArray;
    private static final VertexBuffer.Type[] bufferTypes = VertexBuffer.Type.values();

    @Override
    protected void controlUpdate(float tpf) {
        if (!this.enabled) {
            return;
        }
        this.targets.clear();
        this.spatial.depthFirstTraversal(this.targetLocator);
    }

    @Override
    protected void controlRender(RenderManager rm, ViewPort vp) {
        if (!this.enabled) {
            return;
        }
        for (Geometry geom : this.targets) {
            int i;
            Mesh mesh = geom.getMesh();
            if (!geom.isDirtyMorph()) continue;
            Material m = geom.getMaterial();
            float[] weights = geom.getMorphState();
            MorphTarget[] morphTargets = mesh.getMorphTargets();
            int targetNumBuffers = this.getTargetNumBuffers(morphTargets[0]);
            int maxGPUTargets = this.getMaxGPUTargets(rm, geom, m, targetNumBuffers);
            MatParam param2 = m.getParam("MorphWeights");
            float[] matWeights = (float[])param2.getValue();
            int nbGPUTargets = 0;
            int lastGpuTargetIndex = 0;
            int boundBufferIdx = 0;
            float cpuWeightSum = 0.0f;
            for (i = 0; i < morphTargets.length; ++i) {
                if (weights[i] < 0.005f) continue;
                if (nbGPUTargets >= maxGPUTargets) {
                    cpuWeightSum += weights[i];
                    continue;
                }
                lastGpuTargetIndex = i;
                MorphTarget t = morphTargets[i];
                boundBufferIdx = this.bindMorphtargetBuffer(mesh, targetNumBuffers, boundBufferIdx, t);
                matWeights[nbGPUTargets] = weights[i];
                ++nbGPUTargets;
            }
            if (nbGPUTargets < matWeights.length) {
                for (i = nbGPUTargets; i < matWeights.length; ++i) {
                    matWeights[i] = 0.0f;
                }
            } else if (cpuWeightSum > 0.0f) {
                MorphTarget mt = geom.getFallbackMorphTarget();
                if (mt == null) {
                    mt = this.initCpuMorphTarget(geom);
                    geom.setFallbackMorphTarget(mt);
                }
                cpuWeightSum += matWeights[nbGPUTargets - 1];
                this.ensureTmpArraysCapacity(geom.getVertexCount() * 3, targetNumBuffers);
                for (int i2 = lastGpuTargetIndex; i2 < morphTargets.length; ++i2) {
                    if (weights[i2] < 0.005f) continue;
                    float weight = weights[i2] / cpuWeightSum;
                    MorphTarget t = geom.getMesh().getMorphTargets()[i2];
                    this.mergeMorphTargets(targetNumBuffers, weight, t, i2 == lastGpuTargetIndex);
                }
                this.writeCpuBuffer(targetNumBuffers, mt);
                this.bindMorphtargetBuffer(mesh, targetNumBuffers, (nbGPUTargets - 1) * targetNumBuffers, mt);
                matWeights[nbGPUTargets - 1] = cpuWeightSum;
            }
            geom.setDirtyMorph(false);
        }
    }

    private int getMaxGPUTargets(RenderManager rm, Geometry geom, Material mat, int targetNumBuffers) {
        if (geom.getNbSimultaneousGPUMorph() > -1) {
            return geom.getNbSimultaneousGPUMorph();
        }
        int nbMaxBuffers = this.getRemainingBuffers(geom.getMesh(), rm.getRenderer());
        int realNumTargetsBuffers = geom.getMesh().getMorphTargets().length * targetNumBuffers;
        int maxGPUTargets = Math.min(realNumTargetsBuffers, Math.min(nbMaxBuffers, 14)) / targetNumBuffers;
        MatParam param = mat.getParam("MorphWeights");
        if (param == null) {
            float[] wts = new float[maxGPUTargets];
            mat.setParam("MorphWeights", VarType.FloatArray, wts);
        }
        mat.setInt("NumberOfTargetsBuffers", targetNumBuffers);
        boolean compilationOk = false;
        while (!compilationOk && maxGPUTargets > 0) {
            mat.setInt("NumberOfMorphTargets", maxGPUTargets);
            try {
                rm.preloadScene(this.spatial);
                compilationOk = true;
            }
            catch (RendererException e) {
                logger.log(Level.FINE, geom.getName() + ": failed at " + maxGPUTargets);
                --maxGPUTargets;
            }
        }
        logger.log(Level.FINE, geom.getName() + ": " + maxGPUTargets);
        geom.setNbSimultaneousGPUMorph(maxGPUTargets);
        return maxGPUTargets;
    }

    private int bindMorphtargetBuffer(Mesh mesh, int targetNumBuffers, int boundBufferIdx, MorphTarget t) {
        int start = VertexBuffer.Type.MorphTarget0.ordinal();
        if (targetNumBuffers >= 1) {
            this.activateBuffer(mesh, boundBufferIdx, start, t.getBuffer(VertexBuffer.Type.Position));
            ++boundBufferIdx;
        }
        if (targetNumBuffers >= 2) {
            this.activateBuffer(mesh, boundBufferIdx, start, t.getBuffer(VertexBuffer.Type.Normal));
            ++boundBufferIdx;
        }
        if (!this.approximateTangents && targetNumBuffers == 3) {
            this.activateBuffer(mesh, boundBufferIdx, start, t.getBuffer(VertexBuffer.Type.Tangent));
            ++boundBufferIdx;
        }
        return boundBufferIdx;
    }

    private void writeCpuBuffer(int targetNumBuffers, MorphTarget mt) {
        FloatBuffer dest;
        if (targetNumBuffers >= 1) {
            dest = mt.getBuffer(VertexBuffer.Type.Position);
            dest.rewind();
            dest.put(this.tmpPosArray, 0, dest.capacity());
        }
        if (targetNumBuffers >= 2) {
            dest = mt.getBuffer(VertexBuffer.Type.Normal);
            dest.rewind();
            dest.put(this.tmpNormArray, 0, dest.capacity());
        }
        if (!this.approximateTangents && targetNumBuffers == 3) {
            dest = mt.getBuffer(VertexBuffer.Type.Tangent);
            dest.rewind();
            dest.put(this.tmpTanArray, 0, dest.capacity());
        }
    }

    private void mergeMorphTargets(int targetNumBuffers, float weight, MorphTarget t, boolean init) {
        if (targetNumBuffers >= 1) {
            this.mergeTargetBuffer(this.tmpPosArray, weight, t.getBuffer(VertexBuffer.Type.Position), init);
        }
        if (targetNumBuffers >= 2) {
            this.mergeTargetBuffer(this.tmpNormArray, weight, t.getBuffer(VertexBuffer.Type.Normal), init);
        }
        if (!this.approximateTangents && targetNumBuffers == 3) {
            this.mergeTargetBuffer(this.tmpTanArray, weight, t.getBuffer(VertexBuffer.Type.Tangent), init);
        }
    }

    private void ensureTmpArraysCapacity(int capacity, int targetNumBuffers) {
        if (targetNumBuffers >= 1) {
            this.tmpPosArray = this.ensureCapacity(this.tmpPosArray, capacity);
        }
        if (targetNumBuffers >= 2) {
            this.tmpNormArray = this.ensureCapacity(this.tmpNormArray, capacity);
        }
        if (!this.approximateTangents && targetNumBuffers == 3) {
            this.tmpTanArray = this.ensureCapacity(this.tmpTanArray, capacity);
        }
    }

    private void mergeTargetBuffer(float[] array, float weight, FloatBuffer src, boolean init) {
        src.rewind();
        int j = 0;
        while (j < src.capacity()) {
            if (init) {
                array[j] = 0.0f;
            }
            int n = j++;
            array[n] = array[n] + weight * src.get();
        }
    }

    private void activateBuffer(Mesh mesh, int idx, int start, FloatBuffer b) {
        VertexBuffer.Type t = bufferTypes[start + idx];
        VertexBuffer vb = mesh.getBuffer(t);
        if (vb == null || vb.getData() != b) {
            mesh.setBuffer(t, 3, b);
        }
    }

    private float[] ensureCapacity(float[] tmpArray, int size) {
        if (tmpArray == null || tmpArray.length < size) {
            return new float[size];
        }
        return tmpArray;
    }

    private MorphTarget initCpuMorphTarget(Geometry geom) {
        MorphTarget res = new MorphTarget();
        MorphTarget mt = geom.getMesh().getMorphTargets()[0];
        FloatBuffer b = mt.getBuffer(VertexBuffer.Type.Position);
        if (b != null) {
            res.setBuffer(VertexBuffer.Type.Position, BufferUtils.createFloatBuffer(b.capacity()));
        }
        if ((b = mt.getBuffer(VertexBuffer.Type.Normal)) != null) {
            res.setBuffer(VertexBuffer.Type.Normal, BufferUtils.createFloatBuffer(b.capacity()));
        }
        if (!this.approximateTangents && (b = mt.getBuffer(VertexBuffer.Type.Tangent)) != null) {
            res.setBuffer(VertexBuffer.Type.Tangent, BufferUtils.createFloatBuffer(b.capacity()));
        }
        return res;
    }

    private int getTargetNumBuffers(MorphTarget morphTarget) {
        int num = 0;
        if (morphTarget.getBuffer(VertexBuffer.Type.Position) != null) {
            ++num;
        }
        if (morphTarget.getBuffer(VertexBuffer.Type.Normal) != null) {
            ++num;
        }
        if (!this.approximateTangents && morphTarget.getBuffer(VertexBuffer.Type.Tangent) != null) {
            ++num;
        }
        return num;
    }

    private int getRemainingBuffers(Mesh mesh, Renderer renderer) {
        int nbUsedBuffers = 0;
        for (VertexBuffer vb : mesh.getBufferList().getArray()) {
            boolean isMorphBuffer;
            boolean bl = isMorphBuffer = vb.getBufferType().ordinal() >= VertexBuffer.Type.MorphTarget0.ordinal() && vb.getBufferType().ordinal() <= VertexBuffer.Type.MorphTarget9.ordinal();
            if (vb.getBufferType() == VertexBuffer.Type.Index || isMorphBuffer || vb.getUsage() == VertexBuffer.Usage.CpuOnly) continue;
            ++nbUsedBuffers;
        }
        return renderer.getLimits().get((Object)Limits.VertexAttributes) - nbUsedBuffers;
    }

    public void setApproximateTangents(boolean approximateTangents) {
        this.approximateTangents = approximateTangents;
    }

    public boolean isApproximateTangents() {
        return this.approximateTangents;
    }

    private class TargetLocator
    extends SceneGraphVisitorAdapter {
        private TargetLocator() {
        }

        @Override
        public void visit(Geometry geom) {
            MatParam p = geom.getMaterial().getMaterialDef().getMaterialParam("MorphWeights");
            if (p == null) {
                return;
            }
            Mesh mesh = geom.getMesh();
            if (mesh != null && mesh.hasMorphTargets()) {
                MorphControl.this.targets.add(geom);
                if (mesh.getBuffer(VertexBuffer.Type.HWBoneIndex) == null && !geom.getLocalMatParamOverrides().contains(MorphControl.this.nullNumberOfBones)) {
                    geom.addMatParamOverride(MorphControl.this.nullNumberOfBones);
                }
            }
        }
    }
}

