/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.util.HasLocalTransform;
import com.jme3.anim.util.JointModelTransform;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.MatParamOverride;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.jme3.util.SafeArrayList;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Joint
implements Savable,
JmeCloneable,
HasLocalTransform {
    private String name;
    private int id;
    private Joint parent;
    private SafeArrayList<Joint> children = new SafeArrayList<Joint>(Joint.class);
    private Geometry targetGeometry;
    private Node attachedNode;
    private Transform localTransform = new Transform();
    private Transform initialTransform = new Transform();
    private JointModelTransform jointModelTransform;
    private Matrix4f inverseModelBindMatrix = new Matrix4f();

    public Joint() {
    }

    public Joint(String name) {
        this.name = name;
    }

    public final void update() {
        this.updateModelTransforms();
        for (Joint child : this.children.getArray()) {
            child.update();
        }
    }

    public final void updateModelTransforms() {
        this.jointModelTransform.updateModelTransform(this.localTransform, this.parent);
        this.updateAttachNode();
    }

    private void updateAttachNode() {
        if (this.attachedNode == null) {
            return;
        }
        Node attachParent = this.attachedNode.getParent();
        if (attachParent == null || this.targetGeometry == null || this.targetGeometry.getParent() == attachParent && this.targetGeometry.getLocalTransform().isIdentity()) {
            this.attachedNode.setLocalTransform(this.getModelTransform());
        } else {
            Transform combined = this.getModelTransform().clone();
            for (Spatial loopSpatial = this.targetGeometry; loopSpatial != attachParent && loopSpatial != null; loopSpatial = loopSpatial.getParent()) {
                Transform localTransform = loopSpatial.getLocalTransform();
                combined.combineWithParent(localTransform);
            }
            this.attachedNode.setLocalTransform(combined);
        }
    }

    void getOffsetTransform(Matrix4f outTransform) {
        this.jointModelTransform.getOffsetTransform(outTransform, this.inverseModelBindMatrix);
    }

    protected void saveBindPose() {
        this.getModelTransform().toTransformMatrix(this.inverseModelBindMatrix);
        this.inverseModelBindMatrix.invertLocal();
    }

    protected void saveInitialPose() {
        this.initialTransform.set(this.localTransform);
    }

    public void applyBindPose() {
        this.jointModelTransform.applyBindPose(this.localTransform, this.inverseModelBindMatrix, this.parent);
        this.updateModelTransforms();
        for (Joint child : this.children.getArray()) {
            child.applyBindPose();
        }
    }

    protected void applyInitialPose() {
        this.setLocalTransform(this.initialTransform);
        this.updateModelTransforms();
        for (Joint child : this.children.getArray()) {
            child.applyInitialPose();
        }
    }

    protected JointModelTransform getJointModelTransform() {
        return this.jointModelTransform;
    }

    protected void setJointModelTransform(JointModelTransform jointModelTransform) {
        this.jointModelTransform = jointModelTransform;
    }

    public Vector3f getLocalTranslation() {
        return this.localTransform.getTranslation();
    }

    public Quaternion getLocalRotation() {
        return this.localTransform.getRotation();
    }

    public Vector3f getLocalScale() {
        return this.localTransform.getScale();
    }

    public void setLocalTranslation(Vector3f translation) {
        this.localTransform.setTranslation(translation);
    }

    public void setLocalRotation(Quaternion rotation) {
        this.localTransform.setRotation(rotation);
    }

    public void setLocalScale(Vector3f scale) {
        this.localTransform.setScale(scale);
    }

    public void addChild(Joint child) {
        this.children.add(child);
        child.parent = this;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setLocalTransform(Transform localTransform) {
        this.localTransform.set(localTransform);
    }

    public void setInverseModelBindMatrix(Matrix4f inverseModelBindMatrix) {
        this.inverseModelBindMatrix = inverseModelBindMatrix;
    }

    public String getName() {
        return this.name;
    }

    public Joint getParent() {
        return this.parent;
    }

    public List<Joint> getChildren() {
        return this.children;
    }

    Node getAttachmentsNode(int jointIndex, SafeArrayList<Geometry> targets) {
        this.targetGeometry = null;
        for (Geometry geometry : targets) {
            Mesh mesh = geometry.getMesh();
            if (mesh == null || !mesh.isAnimatedByJoint(jointIndex)) continue;
            this.targetGeometry = geometry;
            break;
        }
        if (this.attachedNode == null) {
            this.attachedNode = new Node(this.name + "_attachnode");
            this.attachedNode.setUserData("AttachedBone", this);
            this.attachedNode.addMatParamOverride(new MatParamOverride(VarType.Int, "NumberOfBones", null));
        }
        return this.attachedNode;
    }

    public Transform getInitialTransform() {
        return this.initialTransform;
    }

    @Override
    public Transform getLocalTransform() {
        return this.localTransform;
    }

    public Transform getModelTransform() {
        return this.jointModelTransform.getModelTransform();
    }

    public Matrix4f getInverseModelBindMatrix() {
        return this.inverseModelBindMatrix;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public Object jmeClone() {
        try {
            Joint clone = (Joint)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.children = cloner.clone(this.children);
        this.parent = cloner.clone(this.parent);
        this.attachedNode = cloner.clone(this.attachedNode);
        this.targetGeometry = cloner.clone(this.targetGeometry);
        this.localTransform = cloner.clone(this.localTransform);
        this.inverseModelBindMatrix = cloner.clone(this.inverseModelBindMatrix);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule input = im.getCapsule(this);
        this.name = input.readString("name", null);
        this.attachedNode = (Node)input.readSavable("attachedNode", null);
        this.targetGeometry = (Geometry)input.readSavable("targetGeometry", null);
        this.initialTransform = (Transform)input.readSavable("initialTransform", new Transform());
        this.inverseModelBindMatrix = (Matrix4f)input.readSavable("inverseModelBindMatrix", this.inverseModelBindMatrix);
        ArrayList childList = input.readSavableArrayList("children", null);
        for (int i = childList.size() - 1; i >= 0; --i) {
            this.addChild((Joint)childList.get(i));
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule output = ex.getCapsule(this);
        output.write(this.name, "name", null);
        output.write(this.attachedNode, "attachedNode", null);
        output.write(this.targetGeometry, "targetGeometry", null);
        output.write(this.initialTransform, "initialTransform", new Transform());
        output.write(this.inverseModelBindMatrix, "inverseModelBindMatrix", new Matrix4f());
        output.writeSavableArrayList(new ArrayList<Joint>(this.children), "children", null);
    }
}

