/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimationMask;
import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import java.util.BitSet;

public class ArmatureMask
implements AnimationMask {
    private BitSet affectedJoints = new BitSet();

    @Override
    public boolean contains(Object target) {
        return this.affectedJoints.get(((Joint)target).getId());
    }

    public static ArmatureMask createMask(Armature armature, String fromJoint) {
        ArmatureMask mask = new ArmatureMask();
        mask.addFromJoint(armature, fromJoint);
        return mask;
    }

    public static ArmatureMask createMask(Armature armature, String ... joints) {
        ArmatureMask mask = new ArmatureMask();
        mask.addBones(armature, joints);
        for (String joint : joints) {
            mask.affectedJoints.set(armature.getJoint(joint).getId());
        }
        return mask;
    }

    public void addBones(Armature armature, String ... jointNames) {
        for (String jointName : jointNames) {
            Joint joint = this.findJoint(armature, jointName);
            this.affectedJoints.set(joint.getId());
        }
    }

    private Joint findJoint(Armature armature, String jointName) {
        Joint joint = armature.getJoint(jointName);
        if (joint == null) {
            throw new IllegalArgumentException("Cannot find joint " + jointName);
        }
        return joint;
    }

    public void addFromJoint(Armature armature, String jointName) {
        Joint joint = this.findJoint(armature, jointName);
        this.recurseAddJoint(joint);
    }

    private void recurseAddJoint(Joint joint) {
        this.affectedJoints.set(joint.getId());
        for (Joint j : joint.getChildren()) {
            this.recurseAddJoint(j);
        }
    }
}

