/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.archunit;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.CompositeArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.jmolecules.archunit.FormatableJavaClass;
import org.jmolecules.ddd.annotation.Identity;
import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Entity;
import org.springframework.core.ResolvableType;

public class JMoleculesDddRules {
    public static ArchRule all() {
        return CompositeArchRule.of((ArchRule)JMoleculesDddRules.entitiesShouldBeDeclaredForUseInSameAggregate()).and(JMoleculesDddRules.aggregateReferencesShouldBeViaIdOrAssociation()).and(JMoleculesDddRules.annotatedEntitiesAndAggregatesNeedToHaveAnIdentifier());
    }

    public static ArchRule entitiesShouldBeDeclaredForUseInSameAggregate() {
        return ArchRuleDefinition.fields().that(JMoleculesDddRules.areAssignableTo(Entity.class).and(DescribedPredicate.not((DescribedPredicate)JMoleculesDddRules.areAssignableTo(AggregateRoot.class)))).should((ArchCondition)JMoleculesDddRules.beDeclaredToBeUsedWithDeclaringAggregate());
    }

    public static ArchRule aggregateReferencesShouldBeViaIdOrAssociation() {
        return ArchRuleDefinition.fields().that((DescribedPredicate)JMoleculesDddRules.areAssignableTo(AggregateRoot.class)).or((DescribedPredicate)JMoleculesDddRules.hasFieldTypeAnnotatedWith(org.jmolecules.ddd.annotation.AggregateRoot.class)).should((ArchCondition)new ShouldUseIdReferenceOrAssociation());
    }

    public static ArchRule annotatedEntitiesAndAggregatesNeedToHaveAnIdentifier() {
        DescribedPredicate areIdentifiable = CanBeAnnotated.Predicates.annotatedWith(org.jmolecules.ddd.annotation.AggregateRoot.class).or(CanBeAnnotated.Predicates.annotatedWith(org.jmolecules.ddd.annotation.Entity.class));
        return ((GivenClassesConjunction)ArchRuleDefinition.classes().that(areIdentifiable).and().areNotAnnotations()).should((ArchCondition)new DeclaresAnnotatedField(Identity.class));
    }

    private static IsDeclaredToUseTheSameAggregate beDeclaredToBeUsedWithDeclaringAggregate() {
        return new IsDeclaredToUseTheSameAggregate();
    }

    private static IsAssignableTypeField areAssignableTo(Class<?> type) {
        return new IsAssignableTypeField(type);
    }

    private static FieldTypeIsAnnotatedWith hasFieldTypeAnnotatedWith(Class<? extends Annotation> type) {
        return new FieldTypeIsAnnotatedWith(type);
    }

    private static class DeclaresAnnotatedField
    extends ArchCondition<JavaClass> {
        private final Class<? extends Annotation> annotation;

        DeclaresAnnotatedField(Class<? extends Annotation> annotation) {
            super("declares field (meta-)annotated with %s", new Object[]{annotation.getName()});
            this.annotation = annotation;
        }

        public void check(JavaClass input, ConditionEvents events) {
            boolean annotatedFieldDeclared = input.getAllFields().stream().anyMatch(it -> it.isAnnotatedWith(this.annotation) || it.isMetaAnnotatedWith(this.annotation));
            if (!annotatedFieldDeclared) {
                String message = String.format("Type %s must declare a field annotated with %s!", FormatableJavaClass.of(input).getAbbreviatedFullName(), this.annotation.getName());
                events.add(SimpleConditionEvent.violated((Object)input, (String)message));
            }
        }
    }

    private static class IsAssignableTypeField
    extends DescribedPredicate<JavaField> {
        private static final ResolvableType COLLECTION_TYPE = ResolvableType.forClass(Collection.class);
        private static final ResolvableType MAP_TYPE = ResolvableType.forClass(Map.class);
        private final Class<?> type;

        private IsAssignableTypeField(Class<?> type) {
            super("are assignable to %s", new Object[]{type.getName()});
            this.type = type;
        }

        public boolean apply(JavaField input) {
            ResolvableType fieldType = ResolvableType.forField((Field)input.reflect());
            ResolvableType domainType = IsAssignableTypeField.unwrapDomainType(fieldType);
            return ResolvableType.forClass(this.type).isAssignableFrom(domainType);
        }

        private static ResolvableType unwrapDomainType(ResolvableType fieldType) {
            if (COLLECTION_TYPE.isAssignableFrom(fieldType)) {
                return fieldType.as(Collection.class).getGeneric(new int[]{0});
            }
            if (MAP_TYPE.isAssignableFrom(fieldType)) {
                return fieldType.as(Map.class).getGeneric(new int[]{1});
            }
            return fieldType;
        }
    }

    private static class FieldTypeIsAnnotatedWith
    extends DescribedPredicate<JavaField> {
        private final DescribedPredicate<CanBeAnnotated> isAnnotatedWith;

        public FieldTypeIsAnnotatedWith(Class<? extends Annotation> type) {
            super("is of type annotated with %s", new Object[]{type.getSimpleName()});
            this.isAnnotatedWith = CanBeAnnotated.Predicates.annotatedWith(type);
        }

        public boolean apply(JavaField input) {
            return this.isAnnotatedWith.apply((Object)input.getRawType());
        }
    }

    private static class ShouldUseIdReferenceOrAssociation
    extends ArchCondition<JavaField> {
        public ShouldUseIdReferenceOrAssociation() {
            super("use id reference or Association", new Object[0]);
        }

        public void check(JavaField field, ConditionEvents events) {
            events.add(SimpleConditionEvent.violated((Object)field, (String)String.format("Field %s.%s refers to an aggregate root (%s). Rather use an identifier reference or Association!", FormatableJavaClass.of(field.getOwner()).getAbbreviatedFullName(), field.getName(), FormatableJavaClass.of(field.getRawType()).getAbbreviatedFullName())));
        }
    }

    private static class IsDeclaredToUseTheSameAggregate
    extends ArchCondition<JavaField> {
        private static final ResolvableType COLLECTION_TYPE = ResolvableType.forClass(Collection.class);
        private static final ResolvableType MAP_TYPE = ResolvableType.forClass(Map.class);

        private IsDeclaredToUseTheSameAggregate() {
            super("belong to aggregate the field is declared in", new Object[0]);
        }

        public void check(JavaField item, ConditionEvents events) {
            Field field = item.reflect();
            ResolvableType type = IsDeclaredToUseTheSameAggregate.getActualType(ResolvableType.forField((Field)field));
            ResolvableType expectedAggregateType = type.as(Entity.class).getGeneric(new int[]{0});
            ResolvableType owningType = ResolvableType.forClass(field.getDeclaringClass());
            String ownerName = FormatableJavaClass.of(item.getOwner()).getAbbreviatedFullName();
            events.add(owningType.isAssignableFrom(expectedAggregateType) ? SimpleConditionEvent.satisfied((Object)field, (String)"Matches") : SimpleConditionEvent.violated((Object)item, (String)String.format("Field %s.%s is of type %s and declared to be used from aggregate %s!", ownerName, item.getName(), item.getRawType().getSimpleName(), expectedAggregateType.resolve(Object.class).getSimpleName())));
        }

        private static ResolvableType getActualType(ResolvableType type) {
            if (COLLECTION_TYPE.isAssignableFrom(type)) {
                return type.getGeneric(new int[]{0});
            }
            return MAP_TYPE.isAssignableFrom(type) ? type.getGeneric(new int[]{1}) : type;
        }
    }
}

