/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.archunit;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.library.Architectures;
import java.lang.annotation.Annotation;
import org.jmolecules.architecture.layered.ApplicationLayer;
import org.jmolecules.architecture.layered.DomainLayer;
import org.jmolecules.architecture.layered.InfrastructureLayer;
import org.jmolecules.architecture.layered.InterfaceLayer;
import org.jmolecules.architecture.onion.classical.ApplicationServiceRing;
import org.jmolecules.architecture.onion.classical.DomainModelRing;
import org.jmolecules.architecture.onion.classical.DomainServiceRing;
import org.jmolecules.architecture.onion.simplified.ApplicationRing;
import org.jmolecules.architecture.onion.simplified.DomainRing;
import org.jmolecules.architecture.onion.simplified.InfrastructureRing;

public class JMoleculesArchitectureRules {
    private static final String INTERFACE = "Interface";
    private static final String APPLICATION = "Application";
    private static final String DOMAIN = "Domain";
    private static final String INFRASTRUCTURE = "Infrastructure";
    private static final String ONION_CLASSICAL_DOMAIN_MODEL = "Domain model";
    private static final String ONION_CLASSICAL_DOMAIN_SERVICE = "Domain service";
    private static final String ONION_CLASSICAL_APPLICATION = "Application";
    private static final String ONION_CLASSICAL_INFRASTRUCTURE = "Infrastructure";
    private static final String ONION_SIMPLE_DOMAIN = "Domain";
    private static final String ONION_SIMPLE_APPLICATION = "Application";
    private static final String ONION_SIMPLE_INFRASTRUCTURE = "Infrastructure";

    public static Architectures.LayeredArchitecture ensureLayering() {
        return JMoleculesArchitectureRules.layeredArchitecture().whereLayer(INTERFACE).mayNotBeAccessedByAnyLayer().whereLayer("Application").mayOnlyBeAccessedByLayers(new String[]{INTERFACE}).whereLayer("Domain").mayOnlyBeAccessedByLayers(new String[]{"Application", INTERFACE}).whereLayer("Infrastructure").mayOnlyBeAccessedByLayers(new String[]{"Domain", "Application", INTERFACE});
    }

    public static Architectures.LayeredArchitecture ensureLayeringStrict() {
        return JMoleculesArchitectureRules.layeredArchitecture().whereLayer(INTERFACE).mayNotBeAccessedByAnyLayer().whereLayer("Application").mayOnlyBeAccessedByLayers(new String[]{INTERFACE}).whereLayer("Domain").mayOnlyBeAccessedByLayers(new String[]{"Application"}).whereLayer("Infrastructure").mayOnlyBeAccessedByLayers(new String[]{"Domain"});
    }

    public static ArchRule ensureOnionSimple() {
        return JMoleculesArchitectureRules.onionArchitectureSimple().whereLayer("Infrastructure").mayNotBeAccessedByAnyLayer().whereLayer("Application").mayOnlyBeAccessedByLayers(new String[]{"Infrastructure"}).whereLayer("Domain").mayOnlyBeAccessedByLayers(new String[]{"Application", "Infrastructure"});
    }

    public static ArchRule ensureOnionClassical() {
        return JMoleculesArchitectureRules.onionArchitecture().whereLayer("Infrastructure").mayNotBeAccessedByAnyLayer().whereLayer("Application").mayOnlyBeAccessedByLayers(new String[]{"Infrastructure"}).whereLayer(ONION_CLASSICAL_DOMAIN_SERVICE).mayOnlyBeAccessedByLayers(new String[]{"Application", "Infrastructure"}).whereLayer(ONION_CLASSICAL_DOMAIN_MODEL).mayOnlyBeAccessedByLayers(new String[]{ONION_CLASSICAL_DOMAIN_SERVICE, ONION_CLASSICAL_DOMAIN_SERVICE, "Application", "Infrastructure"});
    }

    private static Architectures.LayeredArchitecture layeredArchitecture() {
        return Architectures.layeredArchitecture().withOptionalLayers(true).layer("Infrastructure").definedBy(JMoleculesArchitectureRules.layerType(InfrastructureLayer.class)).layer("Domain").definedBy(JMoleculesArchitectureRules.layerType(DomainLayer.class)).layer("Application").definedBy(JMoleculesArchitectureRules.layerType(ApplicationLayer.class)).layer(INTERFACE).definedBy(JMoleculesArchitectureRules.layerType(InterfaceLayer.class));
    }

    private static Architectures.LayeredArchitecture onionArchitecture() {
        return Architectures.layeredArchitecture().withOptionalLayers(true).layer("Infrastructure").definedBy(JMoleculesArchitectureRules.layerType(org.jmolecules.architecture.onion.classical.InfrastructureRing.class)).layer("Application").definedBy(JMoleculesArchitectureRules.layerType(ApplicationServiceRing.class)).layer(ONION_CLASSICAL_DOMAIN_SERVICE).definedBy(JMoleculesArchitectureRules.layerType(DomainServiceRing.class)).layer(ONION_CLASSICAL_DOMAIN_MODEL).definedBy(JMoleculesArchitectureRules.layerType(DomainModelRing.class));
    }

    private static Architectures.LayeredArchitecture onionArchitectureSimple() {
        return Architectures.layeredArchitecture().layer("Infrastructure").definedBy(JMoleculesArchitectureRules.layerType(InfrastructureRing.class)).layer("Application").definedBy(JMoleculesArchitectureRules.layerType(ApplicationRing.class)).layer("Domain").definedBy(JMoleculesArchitectureRules.layerType(DomainRing.class));
    }

    private static DescribedPredicate<JavaClass> layerType(Class<? extends Annotation> annotation) {
        return new IsLayerType(annotation);
    }

    private static class IsLayerType
    extends DescribedPredicate<JavaClass> {
        private final Class<? extends Annotation> annotation;

        public IsLayerType(Class<? extends Annotation> annotation) {
            super("(meta-) annotated with %s or residing in package (meta-)annotated with %s", new Object[]{annotation.getTypeName(), annotation.getTypeName()});
            this.annotation = annotation;
        }

        public boolean apply(JavaClass input) {
            return input.isAnnotatedWith(this.annotation) || input.isMetaAnnotatedWith(this.annotation) || this.hasAnnotationOnPackageOrParent(input.getPackage());
        }

        private boolean hasAnnotationOnPackageOrParent(JavaPackage javaPackage) {
            if (javaPackage.isAnnotatedWith(this.annotation) || javaPackage.isMetaAnnotatedWith(this.annotation)) {
                return true;
            }
            return (Boolean)javaPackage.getParent().map(this::hasAnnotationOnPackageOrParent).orElse((Object)false);
        }
    }
}

