/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.junit5;

import java.lang.reflect.Field;
import java.util.List;
import org.jmock.Mockery;
import org.jmock.api.ExpectationErrorTranslator;
import org.jmock.auto.internal.Mockomatic;
import org.jmock.internal.AllDeclaredFields;
import org.jmock.lib.AssertionErrorTranslator;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JUnit5Mockery
extends Mockery
implements Extension,
BeforeEachCallback,
AfterEachCallback {
    private final Mockomatic mockomatic = new Mockomatic((Mockery)this);

    public JUnit5Mockery() {
        this.setExpectationErrorTranslator((ExpectationErrorTranslator)AssertionErrorTranslator.INSTANCE);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (context.getTestClass().isPresent()) {
            Class testCaseClass = (Class)context.getTestClass().get();
            List allFields = AllDeclaredFields.in((Class)testCaseClass);
            this.fillInAutoMocks(context.getRequiredTestInstance(), allFields);
            JUnit5Mockery.checkMockery(context, testCaseClass);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.assertIsSatisfied();
    }

    private void fillInAutoMocks(Object target, List<Field> allFields) {
        this.mockomatic.fillIn(target, allFields);
    }

    private static void checkMockery(ExtensionContext context, Class<?> testCaseClass) {
        Field mockeryField = JUnit5Mockery.findMockeryField(testCaseClass, context);
        try {
            mockeryField.setAccessible(true);
            if (mockeryField.get(context.getRequiredTestInstance()) == null) {
                throw new IllegalStateException("JUnit5Mockery field should not be null");
            }
        }
        catch (IllegalArgumentException e) {
            throw new ExtensionConfigurationException("Could not check the mockery", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionConfigurationException("Could not check the mockery", (Throwable)e);
        }
    }

    private static Field findMockeryField(Class<?> testClass, ExtensionContext context) {
        Field mockeryField = null;
        for (Field field : AllDeclaredFields.in(testClass)) {
            if (!Mockery.class.isAssignableFrom(field.getType())) continue;
            if (mockeryField != null) {
                throw new ExtensionConfigurationException("more than one Mockery found in test class " + testClass);
            }
            mockeryField = field;
        }
        if (mockeryField == null) {
            throw new ExtensionConfigurationException("no Mockery found in test class " + testClass);
        }
        return mockeryField;
    }
}

