/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.example.announcer;

import java.util.EventListener;
import org.jmock.Expectations;
import org.jmock.Sequence;
import org.jmock.example.announcer.Announcer;
import org.jmock.integration.junit3.MockObjectTestCase;
import org.jmock.internal.ExpectationBuilder;

public class AnnouncerTests
extends MockObjectTestCase {
    Announcer<Listener> announcer = Announcer.to(Listener.class);
    Listener listener1 = (Listener)this.mock(Listener.class, "listener1");
    Listener listener2 = (Listener)this.mock(Listener.class, "listener2");

    public void setUp() {
        this.announcer.addListener(this.listener1);
        this.announcer.addListener(this.listener2);
    }

    public void testAnnouncesToRegisteredListenersInOrderOfAddition() {
        final Sequence eventOrder = this.sequence("eventOrder");
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Listener)this.oneOf(AnnouncerTests.this.listener1)).eventA();
                this.inSequence(eventOrder);
                ((Listener)this.oneOf(AnnouncerTests.this.listener2)).eventA();
                this.inSequence(eventOrder);
                ((Listener)this.oneOf(AnnouncerTests.this.listener1)).eventB();
                this.inSequence(eventOrder);
                ((Listener)this.oneOf(AnnouncerTests.this.listener2)).eventB();
                this.inSequence(eventOrder);
            }
        });
        this.announcer.announce().eventA();
        this.announcer.announce().eventB();
    }

    public void testPassesEventArgumentsToListeners() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Listener)this.oneOf(AnnouncerTests.this.listener1)).eventWithArguments(1, 2);
                ((Listener)this.oneOf(AnnouncerTests.this.listener2)).eventWithArguments(1, 2);
                ((Listener)this.oneOf(AnnouncerTests.this.listener1)).eventWithArguments(3, 4);
                ((Listener)this.oneOf(AnnouncerTests.this.listener2)).eventWithArguments(3, 4);
            }
        });
        this.announcer.announce().eventWithArguments(1, 2);
        this.announcer.announce().eventWithArguments(3, 4);
    }

    public void testCanRemoveListeners() {
        this.announcer.removeListener(this.listener1);
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Listener)this.oneOf(AnnouncerTests.this.listener2)).eventA();
            }
        });
        this.announcer.announce().eventA();
    }

    public void testDoesNotAllowListenersToThrowCheckedExceptions() throws Exception {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Listener)this.allowing(AnnouncerTests.this.listener1)).badEvent();
                this.will(4.throwException((Throwable)new CheckedException()));
            }
        });
        try {
            this.announcer.announce().badEvent();
            AnnouncerTests.fail((String)"should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static interface Listener
    extends EventListener {
        public void eventA();

        public void eventB();

        public void eventWithArguments(int var1, int var2);

        public void badEvent() throws CheckedException;
    }

    public static class CheckedException
    extends Exception {
    }
}

