/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.example.sniper;

import org.jmock.example.sniper.Auction;
import org.jmock.example.sniper.AuctionException;
import org.jmock.example.sniper.AuctionListener;
import org.jmock.example.sniper.AuctionSniperListener;
import org.jmock.example.sniper.Money;

public class AuctionSniper
implements AuctionListener {
    private Auction lotToBidFor;
    private Money bidIncrement;
    private Money maximumBid;
    private AuctionSniperListener listener;

    public AuctionSniper(Auction lotToBidFor, Money bidIncrement, Money maximumBid, AuctionSniperListener listener) {
        this.lotToBidFor = lotToBidFor;
        this.bidIncrement = bidIncrement;
        this.maximumBid = maximumBid;
        this.listener = listener;
    }

    @Override
    public void bidAccepted(Auction lot, Money amount) {
        if (lot != this.lotToBidFor) {
            return;
        }
        if (amount.compareTo(this.maximumBid) <= 0) {
            this.placeBid(lot, amount);
        } else {
            this.listener.sniperFinished(this);
        }
    }

    private void placeBid(Auction item, Money amount) {
        try {
            item.bid(Money.min(this.maximumBid, amount.add(this.bidIncrement)));
        }
        catch (AuctionException ex) {
            this.listener.sniperBidFailed(this, ex);
        }
    }
}

