/*
 * Decompiled with CFR 0.152.
 */
package org.jmisb.core.klv;

import java.nio.ByteBuffer;
import java.util.UUID;

public class UuidUtils {
    public static UUID parseUUID(String identifier) {
        String[] uuidParts = identifier.split("-");
        if (uuidParts.length != 8) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(uuidParts[0]);
        sb.append(uuidParts[1]);
        sb.append("-");
        sb.append(uuidParts[2]);
        sb.append("-");
        sb.append(uuidParts[3]);
        sb.append("-");
        sb.append(uuidParts[4]);
        sb.append("-");
        sb.append(uuidParts[5]);
        sb.append(uuidParts[6]);
        sb.append(uuidParts[7]);
        UUID uuid = UUID.fromString(sb.toString());
        return uuid;
    }

    public static byte[] uuidToArray(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static UUID arrayToUuid(byte[] bytes, int index) {
        ByteBuffer bb = ByteBuffer.wrap(bytes, index, 16);
        return new UUID(bb.getLong(), bb.getLong());
    }

    public static String formatUUID(UUID uuid) {
        String standardFormatUUID = uuid.toString().toUpperCase();
        String misbFormatUUID = standardFormatUUID.substring(0, 4) + "-" + standardFormatUUID.substring(4, 28) + "-" + standardFormatUUID.substring(28, 32) + "-" + standardFormatUUID.substring(32);
        return misbFormatUUID;
    }
}

