/*
 * Decompiled with CFR 0.152.
 */
package org.jmisb.core.klv;

import java.util.Collection;
import java.util.Formatter;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static String toHexString(byte[] bytes) {
        return ArrayUtils.internalToHex(bytes, 16, false);
    }

    public static String toHexString(byte[] bytes, int columns) {
        return ArrayUtils.internalToHex(bytes, columns, false);
    }

    public static String toHexString(byte[] bytes, int columns, boolean decorate) {
        return ArrayUtils.internalToHex(bytes, columns, decorate);
    }

    private static String internalToHex(byte[] bytes, int columns, boolean decorate) {
        Formatter formatter = new Formatter();
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0 && i % columns == 0) {
                formatter.format(System.lineSeparator(), new Object[0]);
            }
            if (decorate) {
                formatter.format("0x%02x, ", bytes[i]);
                continue;
            }
            formatter.format("%02x ", bytes[i]);
        }
        return formatter.toString();
    }

    public static byte[] arrayFromChunks(Collection<byte[]> chunks, int totalLength) {
        byte[] array = new byte[totalLength];
        int i = 0;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, array, i, chunk.length);
            i += chunk.length;
        }
        return array;
    }
}

