/*
 * Decompiled with CFR 0.152.
 */
package org.jmisb.core.video;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.ffmpeg.avcodec.AVCodecDescriptor;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;

public class FfmpegUtils {
    private FfmpegUtils() {
    }

    public static String formatError(int error) {
        byte[] bytes = new byte[256];
        if (avutil.av_strerror((int)error, (byte[])bytes, (long)256L) < 0) {
            return "(" + error + ") Unknown to strerror";
        }
        return "(" + error + ") " + new String(bytes, StandardCharsets.UTF_8);
    }

    public static AVStream getVideoStream(AVFormatContext context) {
        return FfmpegUtils.getStreamOfType(context, 0);
    }

    public static AVStream getDataStream(AVFormatContext context) {
        return FfmpegUtils.getStreamOfType(context, 2);
    }

    public static AVStream getStreamByIndex(AVFormatContext context, int index) {
        return index < 0 ? null : context.streams(index);
    }

    private static AVStream getStreamOfType(AVFormatContext context, int streamType) {
        int index = FfmpegUtils.getStreamIndex(context, streamType);
        return index < 0 ? null : context.streams(index);
    }

    public static int getVideoStreamIndex(AVFormatContext context) {
        return FfmpegUtils.getStreamIndex(context, 0);
    }

    public static int getDataStreamIndex(AVFormatContext context) {
        return FfmpegUtils.getStreamIndex(context, 2);
    }

    public static List<Integer> getDataStreamIndices(AVFormatContext context) {
        ArrayList<Integer> dataStreamIndices = new ArrayList<Integer>();
        int numStreams = context.nb_streams();
        for (int i = 0; i < numStreams; ++i) {
            String fourcc;
            AVStream st = context.streams(i);
            if (st.codecpar().codec_type() != 2 || !(fourcc = FfmpegUtils.tagToFourCc(st.codecpar().codec_tag())).equals("KLVA")) continue;
            dataStreamIndices.add(i);
        }
        return dataStreamIndices;
    }

    public static String tagToFourCc(int i) {
        return new String(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(i).array(), StandardCharsets.US_ASCII);
    }

    public static int fourCcToTag(String str) {
        if (str.length() != 4) {
            throw new IllegalArgumentException("Four CC must be 4 characters");
        }
        return ByteBuffer.wrap(str.getBytes(StandardCharsets.US_ASCII)).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static double getDuration(AVFormatContext context) {
        return (double)context.duration() / 1000000.0;
    }

    public static double getFrameRate(AVFormatContext context) {
        AVRational rational = avformat.av_guess_frame_rate((AVFormatContext)context, (AVStream)FfmpegUtils.getVideoStream(context), null);
        return avutil.av_q2d((AVRational)rational);
    }

    public static int getNumStreams(AVFormatContext context) {
        return context.nb_streams();
    }

    public static int getStreamType(AVFormatContext context, int index) {
        return context.streams(index).codecpar().codec_type();
    }

    public static String getCodecName(AVFormatContext context, int index) {
        AVCodecDescriptor descriptor = avcodec.avcodec_descriptor_get((int)context.streams(index).codecpar().codec_id());
        if (descriptor != null) {
            return descriptor.name().getString();
        }
        return "Unknown";
    }

    private static int getStreamIndex(AVFormatContext context, int streamType) {
        int numStreams = context.nb_streams();
        for (int i = 0; i < numStreams; ++i) {
            AVStream st = context.streams(i);
            if (st.codecpar().codec_type() != streamType) continue;
            if (streamType == 2) {
                String fourcc = FfmpegUtils.tagToFourCc(st.codecpar().codec_tag());
                if (!fourcc.equals("KLVA")) continue;
                return i;
            }
            return i;
        }
        return -1;
    }
}

