/*
 * Decompiled with CFR 0.152.
 */
package org.jmisb.core.klv;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class PrimitiveConverter {
    private static final ThreadLocal<ByteBuffer> shortBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(2));
    private static final ThreadLocal<ByteBuffer> intBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(4));
    private static final ThreadLocal<ByteBuffer> longBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(8));
    private static final ThreadLocal<ByteBuffer> floatBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(4));
    private static final ThreadLocal<ByteBuffer> doubleBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(8));

    static long arrayToUnsignedLongInternal(byte[] bytes) {
        long res = 0L;
        for (byte b : bytes) {
            int i = b & 0xFF;
            res = (res << 8) + (long)i;
        }
        return res;
    }

    public static byte[] uint32ToVariableBytes(long longValue) {
        if (longValue > 65535L) {
            byte[] bytes = PrimitiveConverter.uint32ToBytes(longValue);
            if (bytes[0] == 0) {
                return new byte[]{bytes[1], bytes[2], bytes[3]};
            }
            return bytes;
        }
        if (longValue > 255L) {
            return PrimitiveConverter.uint16ToBytes((int)longValue);
        }
        return PrimitiveConverter.uint8ToBytes((short)longValue);
    }

    public static byte[] uintToVariableBytesV6(long longValue) {
        if (longValue > 0xFFFFFFFFFFL) {
            byte[] bytes = PrimitiveConverter.int64ToBytes(longValue);
            return new byte[]{bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], bytes[7]};
        }
        if (longValue > 0xFFFFFFFFL) {
            byte[] bytes = PrimitiveConverter.int64ToBytes(longValue);
            return new byte[]{bytes[3], bytes[4], bytes[5], bytes[6], bytes[7]};
        }
        return PrimitiveConverter.uint32ToVariableBytes(longValue);
    }

    public static byte[] uintToVariableBytes(long longValue) {
        if (Long.compareUnsigned(longValue, 0xFFFFFFFFFFFFFFL) > 0) {
            return PrimitiveConverter.int64ToBytes(longValue);
        }
        if (Long.compareUnsigned(longValue, 0xFFFFFFFFFFFFL) > 0) {
            byte[] bytes = PrimitiveConverter.int64ToBytes(longValue);
            return new byte[]{bytes[1], bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], bytes[7]};
        }
        return PrimitiveConverter.uintToVariableBytesV6(longValue);
    }

    private PrimitiveConverter() {
    }

    public static int toInt32(byte[] bytes) {
        if (bytes.length == 4) {
            return ByteBuffer.wrap(bytes).getInt();
        }
        if (bytes.length == 3) {
            short res = ByteBuffer.wrap(bytes, 0, 2).getShort();
            return (res << 8) + (bytes[2] & 0xFF);
        }
        if (bytes.length == 2) {
            return ByteBuffer.wrap(bytes).getShort();
        }
        if (bytes.length == 1) {
            return ByteBuffer.wrap(bytes).get();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static short toInt16(byte[] bytes) {
        if (bytes.length == 2) {
            return ByteBuffer.wrap(bytes).getShort();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static short toInt16(byte[] bytes, int offset) {
        if (offset + 2 <= bytes.length) {
            return ByteBuffer.wrap(bytes, offset, 2).getShort();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] int16ToBytes(short val) {
        shortBuffer.get().putShort(0, val);
        return (byte[])shortBuffer.get().array().clone();
    }

    public static byte[] int32ToBytes(int val) {
        intBuffer.get().putInt(0, val);
        return (byte[])intBuffer.get().array().clone();
    }

    public static byte[] int32ToVariableBytes(int intValue) {
        if (intValue > Short.MAX_VALUE || intValue < Short.MIN_VALUE) {
            return PrimitiveConverter.int32ToBytes(intValue);
        }
        if ((short)intValue > 127 || (short)intValue < -128) {
            return PrimitiveConverter.int16ToBytes((short)intValue);
        }
        return new byte[]{(byte)intValue};
    }

    public static int toUint24(byte[] bytes) {
        if (bytes.length == 3) {
            int res = 0;
            for (byte b : bytes) {
                int i = b & 0xFF;
                res = (res << 8) + i;
            }
            return res;
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] uint24ToBytes(int intValue) {
        if (intValue < 0 || intValue > 0xFFFFFF) {
            throw new IllegalArgumentException("Value out of range");
        }
        byte[] bytes = PrimitiveConverter.uint32ToBytes(intValue);
        return new byte[]{bytes[1], bytes[2], bytes[3]};
    }

    public static long toUint32(byte[] bytes) {
        if (bytes.length == 4) {
            return Integer.toUnsignedLong(ByteBuffer.wrap(bytes).getInt());
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static long variableBytesToUint32(byte[] bytes) {
        switch (bytes.length) {
            case 4: {
                return PrimitiveConverter.toUint32(bytes);
            }
            case 3: {
                return PrimitiveConverter.arrayToUnsignedLongInternal(bytes);
            }
            case 2: {
                return PrimitiveConverter.toUint16(bytes);
            }
            case 1: {
                return PrimitiveConverter.toUint8(bytes);
            }
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static int variableBytesToUint16(byte[] bytes) {
        switch (bytes.length) {
            case 2: {
                return PrimitiveConverter.toUint16(bytes);
            }
            case 1: {
                return PrimitiveConverter.toUint8(bytes);
            }
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] uint32ToBytes(long val) {
        if (val < 0L || val > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value out of range");
        }
        longBuffer.get().putLong(0, val);
        return Arrays.copyOfRange(longBuffer.get().array(), 4, 8);
    }

    public static int toUint16(byte[] bytes) {
        if (bytes.length == 2) {
            return Short.toUnsignedInt(ByteBuffer.wrap(bytes).getShort());
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] uint16ToBytes(int val) {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException("Value out of range");
        }
        intBuffer.get().putInt(0, val);
        return Arrays.copyOfRange(intBuffer.get().array(), 2, 4);
    }

    public static int toUint8(byte[] bytes) {
        if (bytes.length == 1) {
            return Byte.toUnsignedInt(bytes[0]);
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] uint8ToBytes(short val) {
        if (val < 0 || val > 255) {
            throw new IllegalArgumentException("Value out of range");
        }
        shortBuffer.get().putShort(0, val);
        return Arrays.copyOfRange(shortBuffer.get().array(), 1, 2);
    }

    public static long toInt64(byte[] bytes) {
        return PrimitiveConverter.toInt64(bytes, 0);
    }

    public static long toInt64(byte[] bytes, int offset) {
        if (offset + 8 <= bytes.length) {
            return ByteBuffer.wrap(bytes, offset, 8).getLong();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static long variableBytesToInt64(byte[] bytes) {
        return new BigInteger(bytes).longValue();
    }

    public static long variableBytesToUint64(byte[] bytes) {
        switch (bytes.length) {
            case 8: {
                return ByteBuffer.wrap(bytes, 0, 8).getLong();
            }
            case 7: {
                return PrimitiveConverter.arrayToUnsignedLongInternal(bytes);
            }
            case 6: {
                return PrimitiveConverter.arrayToUnsignedLongInternal(bytes);
            }
            case 5: {
                return PrimitiveConverter.arrayToUnsignedLongInternal(bytes);
            }
            case 4: {
                return PrimitiveConverter.toUint32(bytes);
            }
            case 3: {
                return PrimitiveConverter.arrayToUnsignedLongInternal(bytes);
            }
            case 2: {
                return PrimitiveConverter.toUint16(bytes);
            }
            case 1: {
                return PrimitiveConverter.toUint8(bytes);
            }
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] int64ToBytes(long val) {
        longBuffer.get().putLong(0, val);
        return (byte[])longBuffer.get().array().clone();
    }

    public static byte[] int64ToVariableBytes(long val) {
        return BigInteger.valueOf(val).toByteArray();
    }

    public static float toFloat32(byte[] bytes) {
        if (bytes.length == 4) {
            return ByteBuffer.wrap(bytes).getFloat();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static float toFloat32(byte[] bytes, int offset) {
        if (bytes.length >= offset + 4) {
            return ByteBuffer.wrap(bytes, offset, 4).getFloat();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] float32ToBytes(float val) {
        floatBuffer.get().putFloat(0, val);
        return (byte[])floatBuffer.get().array().clone();
    }

    public static double toFloat64(byte[] bytes) {
        if (bytes.length == 8) {
            return ByteBuffer.wrap(bytes).getDouble();
        }
        if (bytes.length == 4) {
            return ByteBuffer.wrap(bytes).getFloat();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static double toFloat64(byte[] bytes, int offset) {
        if (bytes.length >= offset + 8) {
            return ByteBuffer.wrap(bytes, offset, 8).getDouble();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] float64ToBytes(double val) {
        doubleBuffer.get().putDouble(0, val);
        return (byte[])doubleBuffer.get().array().clone();
    }
}

