/*
 * Decompiled with CFR 0.152.
 */
package org.jmisb.core.video;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.avutil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameConverter {
    private static Logger logger = LoggerFactory.getLogger(FrameConverter.class);
    private BufferedImage bufferedImage;

    public BufferedImage convert(avutil.AVFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("Input frame cannot be null");
        }
        if (frame.format() != 3) {
            throw new IllegalArgumentException("Input format must be BGR24");
        }
        if (this.bufferedImage == null || this.bufferedImage.getWidth() != frame.width() || this.bufferedImage.getHeight() != frame.height()) {
            logger.debug("Allocating buffer of size " + frame.width() + "x" + frame.height());
            this.bufferedImage = new BufferedImage(frame.width(), frame.height(), 5);
        }
        SampleModel sm = this.bufferedImage.getSampleModel();
        WritableRaster r = this.bufferedImage.getRaster();
        DataBuffer out = r.getDataBuffer();
        int x = -r.getSampleModelTranslateX();
        int y = -r.getSampleModelTranslateY();
        int step = ((ComponentSampleModel)sm).getScanlineStride();
        int channels = ((ComponentSampleModel)sm).getPixelStride();
        int start = y * step + x * channels;
        byte[] a = ((DataBufferByte)out).getData();
        ByteBuffer src = frame.data(0).capacity((long)(frame.width() * frame.linesize(0))).asBuffer();
        FrameConverter.copy(src, frame.linesize(0), ByteBuffer.wrap(a, start, a.length - start), step);
        return this.bufferedImage;
    }

    private static void copy(ByteBuffer srcBuf, int srcStep, ByteBuffer dstBuf, int dstStep) {
        assert (srcBuf != dstBuf);
        int srcLine = srcBuf.position();
        int w = Math.min(srcStep, dstStep);
        for (int dstLine = dstBuf.position(); srcLine < srcBuf.capacity() && dstLine < dstBuf.capacity(); srcLine += srcStep, dstLine += dstStep) {
            srcBuf.position(srcLine);
            dstBuf.position(dstLine);
            ByteBuffer srcRow = srcBuf.slice();
            ByteBuffer dstRow = dstBuf.slice();
            srcRow.limit(w);
            dstRow.limit(w);
            dstRow.put(srcRow);
        }
    }
}

