/*
 * Decompiled with CFR 0.152.
 */
package org.jmisb.core.video;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;

public class FfmpegUtils {
    private FfmpegUtils() {
    }

    public static String formatError(int error) {
        byte[] bytes = new byte[256];
        if (avutil.av_strerror((int)error, (byte[])bytes, (long)256L) < 0) {
            return "(" + error + ") Unknown to strerror";
        }
        return "(" + error + ") " + new String(bytes);
    }

    public static avformat.AVStream getVideoStream(avformat.AVFormatContext context) {
        return FfmpegUtils.getStreamOfType(context, 0);
    }

    public static avformat.AVStream getDataStream(avformat.AVFormatContext context) {
        return FfmpegUtils.getStreamOfType(context, 2);
    }

    private static avformat.AVStream getStreamOfType(avformat.AVFormatContext context, int streamType) {
        int index = FfmpegUtils.getStreamIndex(context, streamType);
        return index < 0 ? null : context.streams(index);
    }

    public static int getVideoStreamIndex(avformat.AVFormatContext context) {
        return FfmpegUtils.getStreamIndex(context, 0);
    }

    public static int getDataStreamIndex(avformat.AVFormatContext context) {
        return FfmpegUtils.getStreamIndex(context, 2);
    }

    public static String tagToFourCc(int i) {
        return new String(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(i).array());
    }

    public static int fourCcToTag(String str) {
        if (str.length() != 4) {
            throw new IllegalArgumentException("Four CC must be 4 characters");
        }
        return ByteBuffer.wrap(str.getBytes()).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static double getDuration(avformat.AVFormatContext context) {
        return context.duration() / 1000000L;
    }

    public static double getFrameRate(avformat.AVFormatContext context) {
        avutil.AVRational rational = avformat.av_guess_frame_rate((avformat.AVFormatContext)context, (avformat.AVStream)FfmpegUtils.getVideoStream(context), null);
        return avutil.av_q2d((avutil.AVRational)rational);
    }

    private static int getStreamIndex(avformat.AVFormatContext context, int streamType) {
        int numStreams = context.nb_streams();
        for (int i = 0; i < numStreams; ++i) {
            avformat.AVStream st = context.streams(i);
            if (st.codecpar().codec_type() != streamType) continue;
            return i;
        }
        return -1;
    }
}

