/*
 * Decompiled with CFR 0.152.
 */
package org.jmisb.core.klv;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class PrimitiveConverter {
    private static final ThreadLocal<ByteBuffer> shortBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(2));
    private static final ThreadLocal<ByteBuffer> intBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(4));
    private static final ThreadLocal<ByteBuffer> longBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(8));
    private static final ThreadLocal<ByteBuffer> floatBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(4));
    private static final ThreadLocal<ByteBuffer> doubleBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(8));

    private PrimitiveConverter() {
    }

    public static int toInt32(byte[] bytes) {
        if (bytes.length == 4) {
            return ByteBuffer.wrap(bytes).getInt();
        }
        if (bytes.length == 2) {
            return ByteBuffer.wrap(bytes).getShort();
        }
        if (bytes.length == 1) {
            return ByteBuffer.wrap(bytes).get();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static short toInt16(byte[] bytes) {
        if (bytes.length == 2) {
            return ByteBuffer.wrap(bytes).getShort();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] int16ToBytes(short val) {
        shortBuffer.get().putShort(0, val);
        return shortBuffer.get().array();
    }

    public static byte[] int32ToBytes(int val) {
        intBuffer.get().putInt(0, val);
        return intBuffer.get().array();
    }

    public static long toUint32(byte[] bytes) {
        if (bytes.length == 4) {
            return Integer.toUnsignedLong(ByteBuffer.wrap(bytes).getInt());
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] uint32ToBytes(long val) {
        if (val < 0L || val > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value out of range");
        }
        longBuffer.get().putLong(0, val);
        return Arrays.copyOfRange(longBuffer.get().array(), 4, 8);
    }

    public static int toUint16(byte[] bytes) {
        if (bytes.length == 2) {
            return Short.toUnsignedInt(ByteBuffer.wrap(bytes).getShort());
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] uint16ToBytes(int val) {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException("Value out of range");
        }
        intBuffer.get().putInt(0, val);
        return Arrays.copyOfRange(intBuffer.get().array(), 2, 4);
    }

    public static long toInt64(byte[] bytes) {
        if (bytes.length == 8) {
            return ByteBuffer.wrap(bytes).getLong();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] int64ToBytes(long val) {
        longBuffer.get().putLong(0, val);
        return longBuffer.get().array();
    }

    public static float toFloat32(byte[] bytes) {
        if (bytes.length == 4) {
            return ByteBuffer.wrap(bytes).getFloat();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] float32ToBytes(float val) {
        floatBuffer.get().putFloat(0, val);
        return floatBuffer.get().array();
    }

    public static double toFloat64(byte[] bytes) {
        if (bytes.length == 8) {
            return ByteBuffer.wrap(bytes).getDouble();
        }
        if (bytes.length == 4) {
            return ByteBuffer.wrap(bytes).getFloat();
        }
        throw new IllegalArgumentException("Invalid buffer length");
    }

    public static byte[] float64ToBytes(double val) {
        doubleBuffer.get().putDouble(0, val);
        return doubleBuffer.get().array();
    }
}

