/*
 * Decompiled with CFR 0.152.
 */
package org.jline.curses.impl;

import java.util.ArrayList;
import java.util.List;
import org.jline.curses.Screen;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class VirtualScreen
implements Screen {
    private final int width;
    private final int height;
    private final char[] chars;
    private final long[] styles;

    public VirtualScreen(int width, int height) {
        this.width = width;
        this.height = height;
        this.chars = new char[width * height];
        this.styles = new long[width * height];
    }

    @Override
    public void text(int x, int y, AttributedString s) {
        int p = y * this.width + x;
        int i = 0;
        while (i < s.length()) {
            this.chars[p] = s.charAt(i);
            this.styles[p] = s.styleAt(i).getStyle();
            ++i;
            ++p;
        }
    }

    @Override
    public void fill(int x, int y, int w, int h, AttributedStyle style) {
        long s = style.getStyle();
        for (int j = 0; j < h; ++j) {
            int p = (y + j) * this.width + x;
            int i = 0;
            while (i < w) {
                this.chars[p] = 32;
                this.styles[p] = s;
                ++i;
                ++p;
            }
        }
    }

    public List<AttributedString> lines() {
        ArrayList<AttributedString> lines = new ArrayList<AttributedString>(this.height);
        AttributedStringBuilder sb = new AttributedStringBuilder(this.width);
        int p = 0;
        for (int j = 0; j < this.height; ++j) {
            sb.setLength(0);
            for (int i = 0; i < this.width; ++i) {
                sb.style(new AttributedStyle(this.styles[p], -1L));
                sb.append(this.chars[p]);
                ++p;
            }
            lines.add(sb.toAttributedString());
        }
        return lines;
    }
}

