/*
 * Decompiled with CFR 0.152.
 */
package org.jline.curses.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jline.curses.Component;
import org.jline.curses.Constraint;
import org.jline.curses.Container;
import org.jline.curses.Screen;
import org.jline.curses.Size;
import org.jline.curses.impl.AbstractComponent;
import org.jline.terminal.MouseEvent;

public abstract class AbstractPanel
extends AbstractComponent
implements Container {
    protected final Map<Component, Constraint> components = new LinkedHashMap<Component, Constraint>();

    public void addComponent(Component component, Constraint constraint) {
        if (!(component instanceof AbstractComponent)) {
            throw new IllegalArgumentException("Components should extend AbstractComponent");
        }
        this.components.put(component, constraint);
        ((AbstractComponent)component).setParent(this);
    }

    @Override
    public Collection<Component> getComponents() {
        return Collections.unmodifiableSet(this.components.keySet());
    }

    @Override
    public void setSize(Size size) {
        super.setSize(size);
        this.layout();
    }

    protected abstract void layout();

    @Override
    protected void doDraw(Screen screen) {
        this.getComponents().forEach(c -> c.draw(screen));
    }

    @Override
    public void handleMouse(MouseEvent event) {
        for (Component component : this.components.keySet()) {
            if (!component.isIn(event.getX(), event.getY())) continue;
            component.handleMouse(event);
            return;
        }
        super.handleMouse(event);
    }

    @Override
    public void handleInput(String input) {
        super.handleInput(input);
    }
}

