/*
 * Decompiled with CFR 0.152.
 */
package org.jline.curses.impl;

import java.util.EnumSet;
import org.jline.curses.Component;
import org.jline.curses.Container;
import org.jline.curses.GUI;
import org.jline.curses.Position;
import org.jline.curses.Renderer;
import org.jline.curses.Screen;
import org.jline.curses.Size;
import org.jline.curses.Theme;
import org.jline.curses.Window;
import org.jline.terminal.MouseEvent;

public abstract class AbstractComponent
implements Component {
    private Size size;
    private Size preferredSize;
    private Position position;
    private boolean enabled;
    private boolean focused;
    private Container parent;
    private Renderer renderer;
    private Theme theme;
    private EnumSet<Component.Behavior> behaviors = EnumSet.noneOf(Component.Behavior.class);

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public Position getScreenPosition() {
        Position p = this.parent != null ? this.parent.getScreenPosition() : new Position(0, 0);
        return new Position(this.position.x() + p.x(), this.position.y() + p.y());
    }

    @Override
    public boolean isIn(int x, int y) {
        Position p = this.getScreenPosition();
        Size s = this.getSize();
        return p.x() <= x && x <= p.x() + s.w() && p.y() <= y && y <= p.y() + s.h();
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    @Override
    public void setSize(Size size) {
        this.size = size;
    }

    @Override
    public Size getPreferredSize() {
        if (this.preferredSize == null) {
            return this.computePreferredSize();
        }
        return this.preferredSize;
    }

    public void setPreferredSize(Size preferredSize) {
        this.preferredSize = preferredSize;
    }

    @Override
    public EnumSet<Component.Behavior> getBehaviors() {
        return this.behaviors;
    }

    public void setBehaviors(EnumSet<Component.Behavior> behaviors) {
        this.behaviors = behaviors;
    }

    @Override
    public void draw(Screen screen) {
        this.getRenderer().draw(screen, this);
    }

    public Renderer getRenderer() {
        if (this.renderer == null) {
            return this.computeRenderer();
        }
        return this.renderer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Theme getTheme() {
        if (this.theme == null) {
            return this.getWindow().getGUI().getTheme();
        }
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    public Window getWindow() {
        Container parent;
        Container container = parent = this instanceof Container ? (Container)((Object)this) : this.getParent();
        while (parent != null) {
            if (parent instanceof Window) {
                return (Window)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Override
    public void enable(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void focus() {
        if (this.getWindow() != null) {
            this.getWindow().focus(this);
        }
    }

    void focused(boolean focused) {
        this.focused = focused;
        if (focused) {
            this.onFocus();
        } else {
            this.onUnfocus();
        }
    }

    public void onFocus() {
    }

    public void onUnfocus() {
    }

    protected Size computePreferredSize() {
        return this.getRenderer().getPreferredSize(this);
    }

    protected Renderer computeRenderer() {
        Window window = this.getWindow();
        GUI gui = window != null ? window.getGUI() : null;
        Renderer renderer = gui != null ? gui.getRenderer(this.getClass()) : null;
        return renderer != null ? renderer : this.getDefaultRenderer();
    }

    protected Renderer getDefaultRenderer() {
        return new Renderer(){

            @Override
            public void draw(Screen screen, Component component) {
                ((AbstractComponent)component).doDraw(screen);
            }

            @Override
            public Size getPreferredSize(Component component) {
                return ((AbstractComponent)component).doGetPreferredSize();
            }
        };
    }

    protected abstract void doDraw(Screen var1);

    protected abstract Size doGetPreferredSize();

    @Override
    public void handleMouse(MouseEvent event) {
    }

    @Override
    public void handleInput(String input) {
    }
}

