/*
 * Decompiled with CFR 0.152.
 */
package org.jline.curses.impl;

import java.util.Collection;
import java.util.Collections;
import org.jline.curses.Component;
import org.jline.curses.Container;
import org.jline.curses.Curses;
import org.jline.curses.Position;
import org.jline.curses.Renderer;
import org.jline.curses.Screen;
import org.jline.curses.Size;
import org.jline.curses.impl.AbstractComponent;

public class Box
extends AbstractComponent
implements Container {
    private final String title;
    private final Curses.Border border;
    private final Component component;

    public Box(String title, Curses.Border border, Component component) {
        this.title = title;
        this.border = border;
        this.component = component;
        ((AbstractComponent)component).setParent(this);
    }

    @Override
    public BoxRenderer getRenderer() {
        return (BoxRenderer)super.getRenderer();
    }

    @Override
    public void setRenderer(Renderer renderer) {
        super.setRenderer((BoxRenderer)renderer);
    }

    public String getTitle() {
        return this.title;
    }

    public Curses.Border getBorder() {
        return this.border;
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setSize(Size size) {
        super.setSize(size);
        this.component.setPosition(this.getRenderer().getComponentOffset());
        this.component.setSize(this.getRenderer().getComponentSize(size));
    }

    @Override
    public Collection<Component> getComponents() {
        return Collections.singleton(this.component);
    }

    @Override
    protected void doDraw(Screen screen) {
    }

    @Override
    protected Size doGetPreferredSize() {
        Size sz = this.getComponent().getPreferredSize();
        if (this.getBehaviors().contains((Object)Component.Behavior.NoDecoration)) {
            return sz;
        }
        return new Size(sz.w() + 2, sz.h() + 2);
    }

    @Override
    protected BoxRenderer getDefaultRenderer() {
        return new BoxRenderer(){

            @Override
            public void draw(Screen screen, Component box) {
                ((Box)box).doDraw(screen);
            }

            @Override
            public Size getPreferredSize(Component box) {
                return ((Box)box).doGetPreferredSize();
            }

            @Override
            public Position getComponentOffset() {
                return new Position(1, 1);
            }

            @Override
            public Size getComponentSize(Size box) {
                return new Size(Math.max(0, box.w() - 2), Math.max(0, box.h() - 2));
            }
        };
    }

    public static interface BoxRenderer
    extends Renderer {
        public Position getComponentOffset();

        public Size getComponentSize(Size var1);
    }
}

