/*
 * Decompiled with CFR 0.152.
 */
package org.jline.curses.impl;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jline.curses.Component;
import org.jline.curses.Curses;
import org.jline.curses.Position;
import org.jline.curses.Screen;
import org.jline.curses.Size;
import org.jline.curses.impl.AbstractComponent;
import org.jline.curses.impl.AbstractWindow;
import org.jline.curses.impl.MenuItem;
import org.jline.curses.impl.SubMenu;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;
import org.jline.utils.NonBlockingReader;

public class Menu
extends AbstractComponent {
    private final List<SubMenu> contents;
    private SubMenu selected;
    private KeyMap<Object> keyMap;
    private KeyMap<Object> global;
    private final BindingReader bindingReader = new BindingReader(new NonBlockingReader(){

        protected int read(long timeout, boolean isPeek) {
            return -1;
        }

        public int readBuffered(char[] b) {
            return -1;
        }

        public int readBuffered(char[] b, int off, int len, long timeout) {
            return -1;
        }

        public void close() {
        }
    });
    private final Map<SubMenu, MenuWindow> windows = new HashMap<SubMenu, MenuWindow>();

    public Menu(List<SubMenu> contents) {
        this.contents = contents;
        for (SubMenu s : contents) {
            this.windows.put(s, new MenuWindow(s));
        }
    }

    public List<SubMenu> getContents() {
        return this.contents;
    }

    @Override
    protected void doDraw(Screen screen) {
        AttributedStyle tn = this.getTheme().getStyle(".menu.text.normal");
        AttributedStyle kn = this.getTheme().getStyle(".menu.key.normal");
        AttributedStyle ts = this.getTheme().getStyle(".menu.text.selected");
        AttributedStyle ks = this.getTheme().getStyle(".menu.key.selected");
        int x = this.getScreenPosition().x();
        int y = this.getScreenPosition().y();
        int w = this.getSize().w();
        AttributedStringBuilder sb = new AttributedStringBuilder();
        for (SubMenu c : this.getContents()) {
            int ki;
            boolean selected = c == this.selected;
            String n = c.getName();
            String k = c.getKey();
            sb.style(tn);
            sb.append((CharSequence)" ");
            sb.style(selected ? ts : tn);
            sb.append((CharSequence)" ");
            int n2 = ki = k != null ? n.indexOf(k) : -1;
            if (ki >= 0) {
                sb.style(selected ? ts : tn);
                sb.append((CharSequence)n, 0, ki);
                sb.style(selected ? ks : kn);
                sb.append((CharSequence)n, ki, ki + k.length());
                sb.style(selected ? ts : tn);
                sb.append((CharSequence)n, ki + k.length(), n.length());
            } else {
                sb.style(selected ? ts : tn);
                sb.append((CharSequence)n);
            }
            sb.style(selected ? ts : tn);
            sb.append((CharSequence)" ");
            sb.style(tn);
            sb.append((CharSequence)" ");
        }
        sb.style(tn);
        while (sb.length() < w) {
            sb.append(' ');
        }
        screen.text(x, y, sb.toAttributedString());
    }

    @Override
    protected Size doGetPreferredSize() {
        int size = -1;
        for (SubMenu mc : this.getContents()) {
            size += mc.getName().length() + 5;
        }
        return new Size(size, 1);
    }

    @Override
    public void handleMouse(MouseEvent event) {
        int dx = event.getX() - this.getScreenPosition().x();
        SubMenu sel = null;
        for (SubMenu mc : this.getContents()) {
            int l = 4 + mc.getName().length();
            if (dx < l) {
                sel = mc;
                break;
            }
            dx -= l + 1;
        }
        this.select(sel);
    }

    @Override
    public void handleInput(String input) {
        if (this.keyMap == null) {
            Terminal terminal = this.getWindow().getGUI().getTerminal();
            this.keyMap = new KeyMap();
            this.keyMap.bind((Object)Action.Up, (CharSequence)KeyMap.key((Terminal)terminal, (InfoCmp.Capability)InfoCmp.Capability.key_up));
            this.keyMap.bind((Object)Action.Down, (CharSequence)KeyMap.key((Terminal)terminal, (InfoCmp.Capability)InfoCmp.Capability.key_down));
            this.keyMap.bind((Object)Action.Left, (CharSequence)KeyMap.key((Terminal)terminal, (InfoCmp.Capability)InfoCmp.Capability.key_left));
            this.keyMap.bind((Object)Action.Right, (CharSequence)KeyMap.key((Terminal)terminal, (InfoCmp.Capability)InfoCmp.Capability.key_right));
            this.keyMap.bind((Object)Action.Execute, new CharSequence[]{KeyMap.key((Terminal)terminal, (InfoCmp.Capability)InfoCmp.Capability.key_enter), " ", "\n", "\r"});
            this.keyMap.bind((Object)Action.Close, (CharSequence)KeyMap.esc());
            this.global = new KeyMap();
            for (SubMenu subMenu : this.contents) {
                for (MenuItem item : subMenu.getContents()) {
                    String s = item.getShortcut();
                    if (s == null) continue;
                    this.global.bind((Object)item, (CharSequence)KeyMap.translate((String)s));
                }
            }
        }
        this.bindingReader.runMacro(input);
        Object binding = this.bindingReader.readBinding(this.keyMap, this.windows.get(this.selected).keyMap);
        if (binding instanceof Action) {
            Action action = (Action)((Object)binding);
            switch (action.ordinal()) {
                case 0: {
                    this.select(this.contents.get((this.contents.indexOf(this.selected) + this.contents.size() - 1) % this.contents.size()));
                    break;
                }
                case 1: {
                    this.select(this.contents.get((this.contents.indexOf(this.selected) + this.contents.size() + 1) % this.contents.size()));
                    break;
                }
                case 2: {
                    if (this.selected == null) break;
                    this.windows.get(this.selected).up();
                    break;
                }
                case 3: {
                    if (this.selected == null) break;
                    this.windows.get(this.selected).down();
                    break;
                }
                case 5: {
                    if (this.selected == null) break;
                    this.windows.get(this.selected).close();
                    break;
                }
                case 4: {
                    if (this.selected == null) break;
                    this.closeAndExecute(this.windows.get(this.selected).selected);
                }
            }
        } else if (binding instanceof MenuItem) {
            this.closeAndExecute((MenuItem)binding);
        }
    }

    private void closeAndExecute(MenuItem item) {
        MenuWindow w = this.windows.get(this.selected);
        w.close();
        if (item.getAction() != null) {
            item.getAction().run();
        }
    }

    private void select(SubMenu s) {
        if (s != this.selected) {
            if (this.selected != null) {
                this.windows.get(this.selected).close();
            }
            this.selected = s;
            if (this.selected != null) {
                this.getWindow().getGUI().addWindow(this.windows.get(this.selected));
            }
        }
    }

    @Override
    public void setPosition(Position position) {
        super.setPosition(position);
        Position p = this.getScreenPosition();
        int x = p.x();
        for (SubMenu mc : this.getContents()) {
            MenuWindow w = this.windows.get(mc);
            w.setPosition(new Position(x, p.y() + 1));
            w.setSize(w.getPreferredSize());
            int l = 4 + mc.getName().length();
            x += l + 1;
        }
    }

    class MenuWindow
    extends AbstractWindow {
        private final SubMenu subMenu;
        private final KeyMap<Object> keyMap;
        private MenuItem selected;

        public MenuWindow(SubMenu subMenu) {
            this.subMenu = subMenu;
            this.selected = subMenu.getContents().stream().filter(c -> c != MenuItem.SEPARATOR).findFirst().orElse(null);
            this.setBehaviors(EnumSet.of(Component.Behavior.NoDecoration, Component.Behavior.Popup, Component.Behavior.ManualLayout));
            this.keyMap = new KeyMap();
            for (MenuItem item : subMenu.getContents()) {
                if (item.getKey() == null) continue;
                this.keyMap.bind((Object)item, (CharSequence)item.getKey().toLowerCase());
            }
        }

        @Override
        protected void doDraw(Screen screen) {
            AttributedStyle tn = this.getTheme().getStyle(".menu.text.normal");
            AttributedStyle kn = this.getTheme().getStyle(".menu.key.normal");
            AttributedStyle ts = this.getTheme().getStyle(".menu.text.selected");
            AttributedStyle ks = this.getTheme().getStyle(".menu.key.selected");
            Position p = this.getScreenPosition();
            Size s = this.getSize();
            if (s.h() <= 0 || s.w() <= 0) {
                return;
            }
            this.getTheme().box(screen, p.x(), p.y(), s.w(), s.h(), Curses.Border.Single, ".menu.border");
            int y = p.y() + 1;
            int ws = 0;
            for (MenuItem mi : this.subMenu.getContents()) {
                if (mi.getShortcut() == null) continue;
                ws = Math.max(ws, mi.getShortcut().length());
            }
            for (MenuItem c : this.subMenu.getContents()) {
                int ki;
                if (c == MenuItem.SEPARATOR) {
                    this.getTheme().separatorH(screen, p.x(), y++, s.w(), Curses.Border.Single, Curses.Border.Single, this.getTheme().getStyle(".menu.border"));
                    continue;
                }
                boolean selected = c == this.selected;
                String n = c.getName();
                String k = c.getKey();
                String t = c.getShortcut();
                AttributedStringBuilder sb = new AttributedStringBuilder(s.w());
                sb.style(selected ? ts : tn);
                sb.append((CharSequence)" ");
                int n2 = ki = k != null ? n.indexOf(k) : -1;
                if (ki >= 0) {
                    sb.style(selected ? ts : tn);
                    sb.append((CharSequence)n, 0, ki);
                    sb.style(selected ? ks : kn);
                    sb.append((CharSequence)n, ki, ki + k.length());
                    sb.style(selected ? ts : tn);
                    sb.append((CharSequence)n, ki + k.length(), n.length());
                } else {
                    sb.style(selected ? ts : tn);
                    sb.append((CharSequence)n);
                }
                sb.style(selected ? ts : tn);
                if (ws > 0) {
                    while (sb.length() < s.w() - 2 - ws) {
                        sb.append((CharSequence)" ");
                    }
                }
                if (t != null) {
                    sb.append((CharSequence)t);
                }
                sb.style(selected ? ts : tn);
                while (sb.length() < s.w() - 2) {
                    sb.append((CharSequence)" ");
                }
                screen.text(p.x() + 1, y++, sb.toAttributedString());
            }
        }

        @Override
        public void handleInput(String input) {
            Menu.this.handleInput(input);
        }

        void up() {
            this.move(-1);
        }

        void down() {
            this.move(1);
        }

        void move(int dir) {
            List<MenuItem> contents = this.subMenu.getContents();
            int idx = contents.indexOf(this.selected);
            while (contents.get(idx = (idx + contents.size() + dir) % contents.size()) == MenuItem.SEPARATOR) {
            }
            this.selected = contents.get(idx);
        }

        @Override
        public void handleMouse(MouseEvent event) {
            if (event.getType() == MouseEvent.Type.Pressed && !this.isIn(event.getX(), event.getY())) {
                this.close();
            } else {
                Position p = this.getScreenPosition();
                Size s = this.getSize();
                int x = p.x() + 1;
                int w = s.w() - 2;
                int y = p.y() + 1;
                if (x <= event.getX() && event.getX() <= x + w) {
                    MenuItem clicked = null;
                    for (MenuItem item : this.subMenu.getContents()) {
                        if (event.getY() == y) {
                            clicked = item;
                            break;
                        }
                        ++y;
                    }
                    if (clicked != null && clicked != MenuItem.SEPARATOR) {
                        Menu.this.closeAndExecute(clicked);
                    }
                }
                super.handleMouse(event);
            }
        }

        @Override
        public Size getPreferredSize() {
            int wn = 0;
            int ws = 0;
            int h = 0;
            for (MenuItem mi : this.subMenu.getContents()) {
                ++h;
                if (mi == MenuItem.SEPARATOR) continue;
                wn = Math.max(wn, mi.getName().length());
                if (mi.getShortcut() == null) continue;
                ws = Math.max(ws, mi.getShortcut().length());
            }
            return new Size(ws > 0 ? 2 + wn + 2 + ws + 1 : 2 + wn + 2, h + 2);
        }
    }

    static enum Action {
        Left,
        Right,
        Up,
        Down,
        Execute,
        Close;

    }
}

