/*
 * Decompiled with CFR 0.152.
 */
package org.jline.curses;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jline.curses.Component;
import org.jline.curses.Constraint;
import org.jline.curses.Container;
import org.jline.curses.GUI;
import org.jline.curses.Window;
import org.jline.curses.impl.AbstractPanel;
import org.jline.curses.impl.BasicWindow;
import org.jline.curses.impl.BorderPanel;
import org.jline.curses.impl.Box;
import org.jline.curses.impl.Button;
import org.jline.curses.impl.GUIImpl;
import org.jline.curses.impl.GridPanel;
import org.jline.curses.impl.Menu;
import org.jline.curses.impl.MenuItem;
import org.jline.curses.impl.SubMenu;
import org.jline.curses.impl.TextArea;
import org.jline.terminal.Terminal;

public class Curses {
    public static GUI gui(Terminal terminal) {
        return new GUIImpl(terminal);
    }

    public static WindowBuilder window() {
        return new WindowBuilder();
    }

    public static Button button() {
        return new Button();
    }

    public static TextArea textArea() {
        return new TextArea();
    }

    public static ContainerBuilder<Location> border() {
        return new ContainerBuilder<Location>(BorderPanel::new);
    }

    public static ContainerBuilder<GridConstraint> grid() {
        return new ContainerBuilder<GridConstraint>(GridPanel::new);
    }

    public static MenuBuilder menu() {
        return new MenuBuilder();
    }

    public static MenuBuilder menu(SubMenu ... subMenus) {
        MenuBuilder builder = new MenuBuilder();
        builder.contents.addAll(Arrays.asList(subMenus));
        return builder;
    }

    public static MenuBuilder menu(SubMenuBuilder ... subMenus) {
        MenuBuilder builder = new MenuBuilder();
        for (SubMenuBuilder subMenu : subMenus) {
            builder.contents.add(subMenu.build());
        }
        return builder;
    }

    public static SubMenuBuilder submenu() {
        return new SubMenuBuilder();
    }

    public static Box box(String title, Border border, ComponentBuilder<?> component) {
        return Curses.box(title, border, component.build());
    }

    public static Box box(String title, Border border, Component component) {
        return new Box(title, border, component);
    }

    public static class WindowBuilder {
        private GUI gui;
        private String title;
        private Component component;

        public WindowBuilder gui(GUI gui) {
            this.gui = gui;
            return this;
        }

        public WindowBuilder title(String title) {
            this.title = title;
            return this;
        }

        public WindowBuilder component(ComponentBuilder<?> component) {
            this.component = component.build();
            return this;
        }

        public WindowBuilder component(Component component) {
            this.component = component;
            return this;
        }

        public Window build() {
            BasicWindow w = new BasicWindow();
            w.setGUI(this.gui);
            w.setTitle(this.title);
            w.setComponent(this.component);
            return w;
        }
    }

    public static class ContainerBuilder<C extends Constraint>
    implements ComponentBuilder<Container> {
        private final Map<Component, C> components = new LinkedHashMap<Component, C>();
        private final Supplier<AbstractPanel> supplier;

        ContainerBuilder(Supplier<AbstractPanel> supplier) {
            this.supplier = supplier;
        }

        public ContainerBuilder<C> add(Component component, C constraint) {
            this.components.put(component, constraint);
            return this;
        }

        public ContainerBuilder<C> add(ComponentBuilder<?> component, C constraint) {
            return this.add((Component)component.build(), constraint);
        }

        @Override
        public Container build() {
            AbstractPanel container = this.supplier.get();
            this.components.forEach(container::addComponent);
            return container;
        }
    }

    public static class MenuBuilder
    implements ComponentBuilder<Menu> {
        List<SubMenu> contents = new ArrayList<SubMenu>();

        public MenuBuilder submenu(String name, String key, List<MenuItem> menu) {
            return this.submenu(new SubMenu(name, key, menu));
        }

        public MenuBuilder submenu(SubMenuBuilder menu) {
            return this.submenu(menu.build());
        }

        public MenuBuilder submenu(SubMenu subMenu) {
            this.contents.add(subMenu);
            return this;
        }

        @Override
        public Menu build() {
            return new Menu(this.contents);
        }
    }

    public static class SubMenuBuilder {
        private String name;
        private String key;
        List<MenuItem> contents = new ArrayList<MenuItem>();

        public SubMenuBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SubMenuBuilder key(String key) {
            this.key = key;
            return this;
        }

        public SubMenuBuilder item(String name, Runnable action) {
            return this.item().name(name).action(action).add();
        }

        public SubMenuBuilder item(String name, String key, String shortcut, Runnable action) {
            return this.item().name(name).key(key).shortcut(shortcut).action(action).add();
        }

        public MenuItemBuilder item() {
            return new MenuItemBuilder();
        }

        public SubMenuBuilder separator() {
            this.contents.add(MenuItem.SEPARATOR);
            return this;
        }

        public SubMenu build() {
            return new SubMenu(this.name, this.key, this.contents);
        }

        public class MenuItemBuilder {
            private String name;
            private String key;
            private String shortcut;
            private Runnable action;

            public MenuItemBuilder name(String name) {
                this.name = name;
                return this;
            }

            public MenuItemBuilder key(String key) {
                this.key = key;
                return this;
            }

            public MenuItemBuilder shortcut(String shortcut) {
                this.shortcut = shortcut;
                return this;
            }

            public MenuItemBuilder action(Runnable action) {
                this.action = action;
                return this;
            }

            public MenuItem build() {
                MenuItem item = new MenuItem();
                item.setName(this.name);
                item.setAction(this.action);
                item.setKey(this.key);
                item.setShortcut(this.shortcut);
                return item;
            }

            public SubMenuBuilder add() {
                SubMenuBuilder.this.contents.add(this.build());
                return SubMenuBuilder.this;
            }
        }
    }

    public static interface ComponentBuilder<C extends Component> {
        public C build();
    }

    public static enum Border {
        Single,
        SingleBevel,
        Double,
        DoubleBevel;

    }

    public static class GridConstraint
    implements Constraint {
    }

    public static enum Location implements Constraint
    {
        Center,
        Top,
        Bottom,
        Left,
        Right;

    }

    public static enum Alignment {
        Beginning,
        Center,
        End,
        Fill;

    }
}

