/*
 * Decompiled with CFR 0.152.
 */
package org.jline.curses.impl;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jline.curses.Component;
import org.jline.curses.GUI;
import org.jline.curses.Position;
import org.jline.curses.Renderer;
import org.jline.curses.Screen;
import org.jline.curses.Size;
import org.jline.curses.Theme;
import org.jline.curses.Window;
import org.jline.curses.impl.AbstractWindow;
import org.jline.curses.impl.BasicWindow;
import org.jline.curses.impl.DefaultTheme;
import org.jline.curses.impl.VirtualScreen;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Attributes;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;

public class GUIImpl
implements GUI {
    private final Terminal terminal;
    private final Deque<Window> windows = new ArrayDeque<Window>();
    private Window activeWindow;
    private final AbstractWindow background;
    private Size size;
    private Display display;
    private final Map<Class<?>, Renderer> renderers = new HashMap();
    private Theme theme = new DefaultTheme();

    public GUIImpl(Terminal terminal) {
        this.terminal = terminal;
        this.background = new BasicWindow(){

            @Override
            protected void doDraw(Screen screen) {
                AttributedStyle st = this.getTheme().getStyle(".background");
                screen.fill(this.getPosition().x(), this.getPosition().y(), this.getSize().w(), this.getSize().h(), st);
            }
        };
        this.background.setGUI(this);
        this.background.setBehaviors(EnumSet.of(Component.Behavior.NoDecoration, Component.Behavior.FullScreen));
    }

    @Override
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public <C extends Component> Renderer getRenderer(Class<C> clazz) {
        return this.renderers.get(clazz);
    }

    @Override
    public <C extends Component> void setRenderer(Class<C> clazz, Renderer renderer) {
        this.renderers.put(clazz, renderer);
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    @Override
    public void addWindow(Window window) {
        if (window.getGUI() != null) {
            window.getGUI().removeWindow(window);
        }
        this.windows.add(window);
        ((AbstractWindow)window).setGUI(this);
        if (!window.getBehaviors().contains((Object)Component.Behavior.NoFocus)) {
            this.activeWindow = window;
        }
    }

    @Override
    public void removeWindow(Window window) {
        if (this.windows.remove(window)) {
            ((AbstractWindow)window).setGUI(null);
            if (this.activeWindow == window) {
                this.activeWindow = null;
                for (Window w : this.windows) {
                    if (w.getBehaviors().contains((Object)Component.Behavior.NoFocus)) continue;
                    this.activeWindow = w;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BindingReader bindingReader = new BindingReader(this.terminal.reader());
        KeyMap map = new KeyMap();
        map.setNomatch((Object)Event.Key);
        map.setUnicode((Object)Event.Key);
        map.bind((Object)Event.Mouse, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_mouse));
        Attributes attributes = this.terminal.getAttributes();
        Attributes newAttr = new Attributes(attributes);
        newAttr.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.IEXTEN), false);
        newAttr.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
        newAttr.setControlChar(Attributes.ControlChar.VMIN, 0);
        newAttr.setControlChar(Attributes.ControlChar.VTIME, 1);
        newAttr.setControlChar(Attributes.ControlChar.VINTR, 0);
        this.terminal.setAttributes(newAttr);
        Terminal.SignalHandler prevHandler = this.terminal.handle(Terminal.Signal.WINCH, this::handle);
        this.terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
        this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
        this.terminal.trackMouse(Terminal.MouseTracking.Button);
        this.terminal.puts(InfoCmp.Capability.cursor_invisible, new Object[0]);
        this.display = new Display(this.terminal, true);
        try {
            this.onResize();
            while (!this.windows.isEmpty()) {
                Event event = (Event)((Object)bindingReader.readBinding(map));
                switch (event.ordinal()) {
                    case 0: {
                        this.handleInput(bindingReader.getLastBinding());
                        break;
                    }
                    case 1: {
                        this.handleMouse(this.terminal.readMouseEvent(() -> ((BindingReader)bindingReader).readCharacter()));
                    }
                }
                this.redraw();
            }
            try {
                while (this.terminal.reader().read(1L) > 0) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.terminal.puts(InfoCmp.Capability.cursor_visible, new Object[0]);
            this.terminal.trackMouse(Terminal.MouseTracking.Off);
            this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
            this.terminal.flush();
            this.terminal.setAttributes(attributes);
            this.terminal.handle(Terminal.Signal.WINCH, prevHandler);
        }
    }

    private void handle(Terminal.Signal signal) {
        if (signal == Terminal.Signal.WINCH) {
            this.onResize();
        }
    }

    private void onResize() {
        org.jline.terminal.Size sz = this.terminal.getSize();
        this.size = new Size(sz.getColumns(), sz.getRows());
        this.display.resize(sz.getRows(), sz.getColumns());
        this.background.setPosition(new Position(0, 0));
        this.background.setSize(this.size);
        for (Window window : this.windows) {
            if (window.getBehaviors().contains((Object)Component.Behavior.ManualLayout)) continue;
            window.setPosition(new Position(this.size.w() / 4, this.size.h() / 4));
            window.setSize(new Size(this.size.w() / 2, this.size.h() / 2));
        }
        this.redraw();
    }

    protected void handleInput(String input) {
        if (this.activeWindow != null) {
            this.activeWindow.handleInput(input);
        } else {
            this.background.handleInput(input);
        }
    }

    protected void handleMouse(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        Window window = null;
        if (this.activeWindow != null && this.activeWindow.getBehaviors().contains((Object)Component.Behavior.Popup)) {
            window = this.activeWindow;
        } else {
            Iterator<Window> it = this.windows.descendingIterator();
            while (it.hasNext()) {
                Window w = it.next();
                if (!w.isIn(x, y)) continue;
                window = w;
                break;
            }
        }
        if (window == null) {
            window = this.background;
        }
        window.handleMouse(event);
    }

    protected void redraw() {
        VirtualScreen screen = new VirtualScreen(this.size.w(), this.size.h());
        this.background.draw(screen);
        this.windows.forEach(w -> w.draw(screen));
        this.display.update(screen.lines(), -1, true);
    }

    static enum Event {
        Key,
        Mouse;

    }
}

