/*
 * Decompiled with CFR 0.152.
 */
package org.jline.widget;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jline.keymap.KeyMap;
import org.jline.reader.Binding;
import org.jline.reader.Buffer;
import org.jline.reader.LineReader;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.Widget;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.Status;

public abstract class Widgets {
    protected static final String AP_TOGGLE = "autopair-toggle";
    protected static final String AP_INSERT = "_autopair-insert";
    protected static final String AP_BACKWARD_DELETE_CHAR = "_autopair-backward-delete-char";
    protected static final String TT_TOGGLE = "tailtip-toggle";
    protected static final String TT_ACCEPT_LINE = "_tailtip-accept-line";
    protected final LineReader reader;

    public Widgets(LineReader reader) {
        this.reader = reader;
    }

    public void addWidget(String name, Widget widget) {
        this.reader.getWidgets().put(name, this.namedWidget(name, widget));
    }

    private Widget namedWidget(final String name, final Widget widget) {
        return new Widget(){

            public String toString() {
                return name;
            }

            public boolean apply() {
                return widget.apply();
            }
        };
    }

    public void callWidget(String name) {
        if (!name.startsWith("_") && !name.endsWith("-toggle")) {
            name = "." + name;
        }
        this.reader.callWidget(name);
    }

    public void executeWidget(String name) {
        Binding ref = (Binding)this.getKeyMap().getBoundKeys().get(KeyMap.alt((String)KeyMap.ctrl((char)'X')));
        this.getKeyMap().bind((Object)new Reference(name), (CharSequence)KeyMap.alt((String)KeyMap.ctrl((char)'X')));
        this.reader.runMacro(KeyMap.alt((String)KeyMap.ctrl((char)'X')));
        if (ref != null) {
            this.getKeyMap().bind((Object)ref, (CharSequence)KeyMap.alt((String)KeyMap.ctrl((char)'X')));
        }
    }

    public void aliasWidget(String orig, String alias) {
        this.reader.getWidgets().put(alias, this.widget(orig));
    }

    public String getWidget(String name) {
        return this.widget(name).toString();
    }

    public boolean existsWidget(String name) {
        try {
            this.widget(name);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Widget widget(String name) {
        Widget out = name.startsWith(".") ? (Widget)this.reader.getBuiltinWidgets().get(name.substring(1)) : (Widget)this.reader.getWidgets().get(name);
        if (out == null) {
            throw new InvalidParameterException("widget: no such widget " + name);
        }
        return out;
    }

    public Parser parser() {
        return this.reader.getParser();
    }

    public KeyMap<Binding> getKeyMap() {
        return (KeyMap)this.reader.getKeyMaps().get("main");
    }

    public Buffer buffer() {
        return this.reader.getBuffer();
    }

    public void replaceBuffer(Buffer buffer) {
        this.reader.getBuffer().copyFrom(buffer);
    }

    public List<String> args() {
        return this.reader.getParser().parse(this.buffer().toString(), 0, Parser.ParseContext.COMPLETE).words();
    }

    public String prevChar() {
        return String.valueOf((char)this.reader.getBuffer().prevChar());
    }

    public String currChar() {
        return String.valueOf((char)this.reader.getBuffer().currChar());
    }

    public String lastBinding() {
        return this.reader.getLastBinding();
    }

    public void putString(String string) {
        this.reader.getBuffer().write((CharSequence)string);
    }

    public String tailTip() {
        return this.reader.getTailTip();
    }

    public void setTailTip(String tailTip) {
        this.reader.setTailTip(tailTip);
    }

    public void setErrorPattern(Pattern errorPattern) {
        this.reader.getHighlighter().setErrorPattern(errorPattern);
    }

    public void setErrorIndex(int errorIndex) {
        this.reader.getHighlighter().setErrorIndex(errorIndex);
    }

    public void clearTailTip() {
        this.reader.setTailTip("");
    }

    public void setSuggestionType(LineReader.SuggestionType type) {
        this.reader.setAutosuggestion(type);
    }

    public void addDescription(List<AttributedString> desc) {
        Status.getStatus((Terminal)this.reader.getTerminal()).update(desc);
    }

    public void clearDescription() {
        this.initDescription(0);
    }

    public void initDescription(int size) {
        Status status = Status.getStatus((Terminal)this.reader.getTerminal(), (boolean)false);
        if (size > 0) {
            if (status == null) {
                status = Status.getStatus((Terminal)this.reader.getTerminal());
            }
            status.setBorder(true);
            ArrayList<AttributedString> as = new ArrayList<AttributedString>();
            for (int i = 0; i < size; ++i) {
                as.add(new AttributedString((CharSequence)""));
            }
            this.addDescription(as);
        } else if (status != null) {
            if (size < 0) {
                status.update(null);
            } else {
                status.clear();
            }
        }
    }

    public void destroyDescription() {
        this.initDescription(-1);
    }
}

