/*
 * Decompiled with CFR 0.152.
 */
package org.jline.consoleui.prompt.builder;

import java.util.ArrayList;
import java.util.List;
import org.jline.consoleui.elements.ExpandableChoice;
import org.jline.consoleui.elements.items.ChoiceItemIF;
import org.jline.consoleui.prompt.builder.ExpandableChoiceItemBuilder;
import org.jline.consoleui.prompt.builder.ExpandableChoiceSeparatorBuilder;
import org.jline.consoleui.prompt.builder.PromptBuilder;

public class ExpandableChoicePromptBuilder {
    private final PromptBuilder promptBuilder;
    private String name;
    private String message;
    private final List<ChoiceItemIF> itemList;

    public ExpandableChoicePromptBuilder(PromptBuilder promptBuilder) {
        this.promptBuilder = promptBuilder;
        this.itemList = new ArrayList<ChoiceItemIF>();
    }

    void addItem(ChoiceItemIF choiceItem) {
        this.itemList.add(choiceItem);
    }

    public ExpandableChoicePromptBuilder name(String name) {
        this.name = name;
        if (this.message == null) {
            this.message = name;
        }
        return this;
    }

    public ExpandableChoicePromptBuilder message(String message) {
        this.message = message;
        if (this.name == null) {
            this.name = message;
        }
        return this;
    }

    public ExpandableChoiceItemBuilder newItem() {
        return new ExpandableChoiceItemBuilder(this);
    }

    public ExpandableChoiceItemBuilder newItem(String name) {
        ExpandableChoiceItemBuilder expandableChoiceItemBuilder = new ExpandableChoiceItemBuilder(this);
        return expandableChoiceItemBuilder.name(name);
    }

    public PromptBuilder addPrompt() {
        ExpandableChoice expandableChoice = new ExpandableChoice(this.message, this.name, this.itemList);
        this.promptBuilder.addPrompt(expandableChoice);
        return this.promptBuilder;
    }

    public ExpandableChoiceSeparatorBuilder newSeparator(String text) {
        ExpandableChoiceSeparatorBuilder expandableChoiceSeparatorBuilder = new ExpandableChoiceSeparatorBuilder(this);
        return expandableChoiceSeparatorBuilder.text(text);
    }
}

