/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.schema.org.apache.maven.maven_v4_0_0.Model;

public class CreateProjectDocsMojo
extends AbstractMojo {
    public static final String URL_ENCODING = "UTF-8";
    public static final String STRING_ENCODING = "UTF8";
    private String schemaProjectLocation;
    private String catalogOut;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            URL url = null;
            try {
                url = new URL(this.schemaProjectLocation + File.separator + "pom.xml");
            }
            catch (MalformedURLException e) {
                url = new File(this.schemaProjectLocation + File.separator + "pom.xml").toURL();
            }
            InputStream in = url.openStream();
            Model model = this.getProjectInfo(in);
            in.close();
            PrintStream printOut = this.getPrintStream(this.catalogOut);
            printOut.println("<projects>");
            this.writeThisModel(model, printOut);
            Model.Modules modules = model.getModules();
            List modulesList = modules.getModuleList();
            for (int i = modulesList.size() - 1; i >= 0; --i) {
                if (!"site".equalsIgnoreCase((String)modulesList.get(i)) && !"schema-library-parent".equalsIgnoreCase((String)modulesList.get(i)) && !"schema-utilities".equalsIgnoreCase((String)modulesList.get(i))) continue;
                modulesList.remove(i);
            }
            this.scanSubModules(modulesList, this.schemaProjectLocation, printOut);
            printOut.println("</projects>");
            printOut.flush();
            printOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void scanSubModules(List<String> modulesList, String moduleLocation, PrintStream printOut) throws IOException {
        printOut.println("<modules>");
        for (String module : modulesList) {
            URL url = null;
            try {
                url = new URL(moduleLocation + File.separator + module + File.separator + "pom.xml");
            }
            catch (MalformedURLException e) {
                url = new File(moduleLocation + File.separator + module + File.separator + "pom.xml").toURL();
            }
            InputStream in = url.openStream();
            Model moduleModel = this.getProjectInfo(in);
            in.close();
            if (moduleModel == null) continue;
            printOut.println("<module>");
            this.writeThisModel(moduleModel, printOut);
            Model.Modules schemaModules = moduleModel.getModules();
            if (schemaModules != null) {
                List schemaModulesList = schemaModules.getModuleList();
                this.scanSubModules(schemaModulesList, moduleLocation + File.separator + module, printOut);
            }
            printOut.println("</module>");
        }
        printOut.println("</modules>");
    }

    public Model getProjectInfo(InputStream inStream) {
        try {
            IBindingFactory jc = BindingDirectory.getFactory(Model.class);
            IUnmarshallingContext unmarshaller = jc.createUnmarshallingContext();
            Model message = (Model)unmarshaller.unmarshalDocument(inStream, URL_ENCODING);
            return message;
        }
        catch (JiBXException e) {
            e.printStackTrace();
            return null;
        }
    }

    PrintStream getPrintStream(String fileOut) {
        File file;
        PrintStream out = null;
        int dirIndex = fileOut.lastIndexOf(File.separator);
        if (dirIndex == -1) {
            dirIndex = fileOut.lastIndexOf("\\");
        }
        if (dirIndex != -1) {
            new File(fileOut.substring(0, dirIndex)).mkdirs();
        }
        if ((file = new File(fileOut)).exists()) {
            file.delete();
        }
        try {
            FileOutputStream outStream = new FileOutputStream(file);
            out = new PrintStream(outStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return out;
    }

    public boolean writeThisModel(Model message, PrintStream out) {
        try {
            IBindingFactory jc = BindingDirectory.getFactory(Model.class);
            IMarshallingContext marshaller = jc.createMarshallingContext();
            marshaller.setIndent(4);
            ByteArrayOutputStream outb = new ByteArrayOutputStream();
            marshaller.marshalDocument((Object)message, URL_ENCODING, null, (OutputStream)outb);
            String xml = outb.toString(STRING_ENCODING);
            xml = this.stripProcessingInstructions(xml);
            out.println(xml);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (JiBXException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String stripProcessingInstructions(String xml) {
        while (true) {
            int startInstr = xml.indexOf("<?");
            int endInstr = xml.indexOf("?>", startInstr);
            if (startInstr == -1 || endInstr == -1) break;
            if (xml.charAt(endInstr + 2) == '\n') {
                ++endInstr;
            }
            xml = xml.substring(0, startInstr) + xml.substring(endInstr + 2);
        }
        return xml;
    }
}

