/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.archetype.mojos.CreateProjectFromArchetypeMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.schema.org.apache.maven.maven_v4_0_0.Model;

public abstract class BaseJibxProjectBuilder
extends CreateProjectFromArchetypeMojo {
    public static final String URL_ENCODING = "UTF-8";
    public static final String STRING_ENCODING = "UTF8";

    public void execute() throws MojoExecutionException, MojoFailureException {
    }

    public String schemaLocationToPackage(String schemaLocation, StringBuilder sbGroupId) {
        String[] paths;
        String host = schemaLocation;
        String pathRoot = "";
        try {
            URL url = new URL(schemaLocation);
            host = url.getHost();
            pathRoot = url.getPath();
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        StringBuilder packageName = new StringBuilder();
        String[] domains = host.split("\\.");
        for (int i = domains.length - 1; !(i < 0 || i == 0 && "www".equalsIgnoreCase(domains[i])); --i) {
            if (packageName.length() > 0) {
                packageName.append('.');
            }
            if (Character.isDigit(domains[i].charAt(0))) {
                packageName.append('_');
            }
            packageName.append(this.stringToPackageName(domains[i]));
        }
        sbGroupId.append((CharSequence)packageName);
        if (pathRoot.endsWith(".xsd") || pathRoot.endsWith(".xml") || pathRoot.endsWith(".html")) {
            pathRoot = pathRoot.substring(0, pathRoot.lastIndexOf(46));
        }
        pathRoot = pathRoot.replace('.', '_');
        for (String path : paths = pathRoot.split("/")) {
            if (path.length() == 0) continue;
            if (Character.isDigit(path.charAt(0))) {
                path = "_" + path;
            }
            path = this.stringToPackageName(path);
            if (packageName.length() > 0) {
                packageName.append('.');
            }
            packageName.append(path);
        }
        return packageName.toString();
    }

    public String stringToPackageName(String packageName) {
        for (int i = 0; i < packageName.length(); ++i) {
            char pathChar = packageName.charAt(i);
            if (pathChar == '_' || Character.isLetterOrDigit(pathChar)) continue;
            packageName = packageName.replace(pathChar, '_');
        }
        return packageName;
    }

    public Object getBindingFromStream(Class<?> bindingClass, InputStream inStream) {
        try {
            IBindingFactory jc = BindingDirectory.getFactory(bindingClass);
            IUnmarshallingContext unmarshaller = jc.createUnmarshallingContext();
            Model message = (Model)unmarshaller.unmarshalDocument(inStream, URL_ENCODING);
            return message;
        }
        catch (JiBXException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeThisModel(String artifactId, Model model) {
        File dir = new File(artifactId);
        dir.mkdirs();
        File file = new File(dir, "pom.xml");
        if (file.exists()) {
            file.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            this.writeThisModel(model, out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean writeThisModel(Model message, OutputStream out) {
        try {
            IBindingFactory jc = BindingDirectory.getFactory(Model.class);
            IMarshallingContext marshaller = jc.createMarshallingContext();
            marshaller.setIndent(4);
            marshaller.marshalDocument((Object)message, URL_ENCODING, null, out);
            return true;
        }
        catch (JiBXException e) {
            e.printStackTrace();
            return false;
        }
    }
}

