/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.util.ArrayList;
import java.util.Iterator;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.BindingOrganizer;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.util.HolderBase;
import org.jibx.util.LazyList;

public class BindingHolder
extends HolderBase {
    private final BindingOrganizer m_organizer;
    private BindingElement m_binding;
    private boolean m_finished;
    private String m_bindingName;
    private final LazyList m_formats;
    private final LazyList m_includes;
    private final LazyList m_mappings;

    public BindingHolder(String uri, int index, BindingOrganizer dir) {
        super(uri);
        this.m_organizer = dir;
        this.m_binding = new BindingElement();
        this.m_formats = new LazyList();
        this.m_includes = new LazyList();
        this.m_mappings = new LazyList();
        if (uri != null) {
            NamespaceElement ns = new NamespaceElement();
            ns.setDefaultName("elements");
            ns.setUri(uri);
            if (index != 0) {
                ns.setPrefix("ns" + index);
            }
            this.m_binding.addTopChild(ns);
            this.m_binding.addNamespaceDecl("tns", uri);
        }
    }

    public BindingOrganizer getOrganizer() {
        return this.m_organizer;
    }

    public BindingElement getBinding() {
        return this.m_binding;
    }

    public void setBinding(BindingElement bind) {
        this.m_binding = bind;
    }

    private void checkModifiable() {
        if (this.m_finished) {
            throw new IllegalStateException("Internal error - attempt to modify binding after finalized");
        }
    }

    public String getBindingName() {
        return this.m_bindingName;
    }

    public void setBindingName(String name) {
        this.m_bindingName = name;
    }

    protected void addNamespaceDecl(String prefix, String uri) {
        this.checkModifiable();
        this.m_binding.addNamespaceDecl(prefix, uri);
    }

    public void addFormat(FormatElement format) {
        this.checkModifiable();
        this.m_formats.add(format);
    }

    public void addInclude(IncludeElement include) {
        this.checkModifiable();
        this.m_includes.add(include);
    }

    public void addMapping(MappingElementBase mapping) {
        this.checkModifiable();
        this.m_mappings.add(mapping);
    }

    public void addDependency(String uri) {
        this.checkModifiable();
        this.m_organizer.addDependency(uri, this);
    }

    public void finish() {
        if (!this.m_finished) {
            Iterator iter = this.getReferences().iterator();
            while (iter.hasNext()) {
                this.getPrefix(((BindingHolder)iter.next()).getNamespace());
            }
            ArrayList topchilds = this.m_binding.topChildren();
            for (int i = 0; i < this.m_formats.size(); ++i) {
                FormatElement format = (FormatElement)this.m_formats.get(i);
                if (format.getDefaultText() == null && format.getDeserializerName() == null && format.getEnumValueName() == null && format.getSerializerName() == null) continue;
                topchilds.add(format);
            }
            topchilds.addAll(this.m_includes);
            topchilds.addAll(this.m_mappings);
            this.m_finished = true;
        }
    }
}

