/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.jibx.binding.classes.BranchTarget;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.MappingReference;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NestedBase;
import org.jibx.runtime.JiBXException;

public class NestedStructure
extends NestedBase {
    private static final String CHECK_ISSTART_NAME = "org.jibx.runtime.impl.UnmarshallingContext.isStart";
    private static final String CHECK_ISSTART_SIGNATURE = "()Z";
    private static final String SKIP_ELEMENT_NAME = "org.jibx.runtime.impl.UnmarshallingContext.skipElement";
    private static final String SKIP_ELEMENT_SIGNATURE = "()V";
    private static final String THROW_EXCEPTION_NAME = "org.jibx.runtime.impl.UnmarshallingContext.throwNameException";
    private static final String THROW_EXCEPTION_SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
    private IComponent m_idChild;
    protected final boolean m_isChoice;
    private final boolean m_allowDuplicates;
    private boolean m_hasObject;
    private boolean m_isLinked;

    public NestedStructure(IContainer parent, IContextObj objc, boolean ord, boolean choice, boolean flex, boolean ctx, boolean hasobj, boolean dupl) {
        super(parent, objc, ord, flex, ctx);
        this.m_isChoice = choice;
        this.m_hasObject = hasobj;
        this.m_allowDuplicates = dupl;
    }

    public void setObjectContext(IContextObj objc) {
        this.m_hasObject = false;
    }

    public boolean isMappingReference() {
        return this.m_contents.size() == 1 && this.m_contents.get(0) instanceof MappingReference;
    }

    public void genNewInstance(ContextMethodBuilder mb) {
        if (this.isMappingReference()) {
            throw new IllegalStateException("Internal error - no instance creation");
        }
    }

    public boolean hasAttribute() {
        return this.m_attributes != null && this.m_attributes.size() > 0;
    }

    public void genAttrPresentTest(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_attributes != null && this.m_attributes.size() > 0) {
            int count = this.m_attributes.size();
            if (count == 1) {
                ((IComponent)this.m_attributes.get(0)).genAttrPresentTest(mb);
            } else {
                BranchWrapper[] tofound = new BranchWrapper[count];
                for (int i = 0; i < count; ++i) {
                    IComponent comp = (IComponent)this.m_attributes.get(i);
                    comp.genAttrPresentTest(mb);
                    tofound[i] = mb.appendIFNE(this);
                }
                mb.appendICONST_0();
                BranchWrapper toend = mb.appendUnconditionalBranch(this);
                for (int i = 0; i < count; ++i) {
                    mb.targetNext(tofound[i]);
                }
                mb.appendICONST_1();
                mb.targetNext(toend);
            }
        } else {
            throw new IllegalStateException("Internal error - no attributes present");
        }
    }

    public void genAttributeUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_attributes != null && this.m_attributes.size() > 0) {
            for (int i = 0; i < this.m_attributes.size(); ++i) {
                IComponent attr = (IComponent)this.m_attributes.get(i);
                attr.genAttributeUnmarshal(mb);
            }
        } else {
            throw new IllegalStateException("Internal error - no attributes present");
        }
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_attributes != null && this.m_attributes.size() > 0) {
            for (int i = 0; i < this.m_attributes.size(); ++i) {
                IComponent attr = (IComponent)this.m_attributes.get(i);
                attr.genAttributeMarshal(mb);
            }
        } else {
            throw new IllegalStateException("Internal error - no attributes present");
        }
    }

    public boolean hasContent() {
        return this.m_contents.size() > 0;
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_contents.size() > 0) {
            if (this.m_isOrdered) {
                for (int i = 0; i < this.m_contents.size(); ++i) {
                    IComponent child = (IComponent)this.m_contents.get(i);
                    child.genContentUnmarshal(mb);
                }
            } else {
                IComponent child;
                int i;
                boolean useflag;
                int count = this.m_contents.size();
                int nreq = 0;
                for (int i2 = 0; i2 < count; ++i2) {
                    if (((IComponent)this.m_contents.get(i2)).isOptional()) continue;
                    ++nreq;
                }
                boolean bl = useflag = nreq > 0 || !this.m_allowDuplicates;
                if (useflag) {
                    mb.appendLoadConstant(count);
                    mb.appendCreateArray("boolean");
                    mb.defineSlot(this, ClassItem.typeFromName("boolean[]"));
                }
                BranchWrapper link = null;
                BranchTarget first = mb.appendTargetNOP();
                BranchWrapper[] toends = this.m_isChoice ? new BranchWrapper[count + 1] : new BranchWrapper[1];
                for (i = 0; i < count; ++i) {
                    if (link != null) {
                        mb.targetNext(link);
                    }
                    child = (IComponent)this.m_contents.get(i);
                    child.genContentPresentTest(mb);
                    link = mb.appendIFEQ(this);
                    if (!this.m_allowDuplicates) {
                        this.genFlagTest(true, i, "Duplicate element ", child.getWrapperName(), mb);
                    }
                    if (useflag || !child.isOptional() || !this.m_allowDuplicates) {
                        mb.appendLoadLocal(mb.getSlot(this));
                        mb.appendLoadConstant(i);
                        mb.appendLoadConstant(1);
                        mb.appendASTORE("boolean");
                    }
                    child.genContentUnmarshal(mb);
                    BranchWrapper next = mb.appendUnconditionalBranch(this);
                    if (this.m_isChoice) {
                        toends[i + 1] = next;
                        continue;
                    }
                    next.setTarget(first, mb);
                }
                if (this.m_isFlexible) {
                    if (link != null) {
                        mb.targetNext(link);
                        mb.loadContext();
                        mb.appendCallVirtual(CHECK_ISSTART_NAME, CHECK_ISSTART_SIGNATURE);
                        toends[0] = mb.appendIFEQ(this);
                        mb.loadContext();
                        mb.appendCallVirtual(SKIP_ELEMENT_NAME, SKIP_ELEMENT_SIGNATURE);
                        mb.appendUnconditionalBranch(this).setTarget(first, mb);
                    }
                } else {
                    toends[0] = link;
                }
                mb.targetNext(toends);
                if (nreq > 0) {
                    for (i = 0; i < count; ++i) {
                        child = (IComponent)this.m_contents.get(i);
                        if (child.isOptional()) continue;
                        this.genFlagTest(false, i, "Missing required element ", child.getWrapperName(), mb);
                    }
                }
                mb.freeSlot(this);
            }
        } else {
            throw new IllegalStateException("Internal error - no content present");
        }
    }

    private void genFlagTest(boolean cond, int pos, String msg, NameDefinition name, ContextMethodBuilder mb) {
        mb.appendLoadLocal(mb.getSlot(this));
        mb.appendLoadConstant(pos);
        mb.appendALOAD("boolean");
        BranchWrapper ifgood = cond ? mb.appendIFEQ(this) : mb.appendIFNE(this);
        mb.loadContext();
        mb.appendLoadConstant(msg);
        if (name == null) {
            mb.appendACONST_NULL();
            mb.appendLoadConstant("(unknown name, position " + pos + " in binding structure)");
        } else {
            name.genPushUriPair(mb);
        }
        mb.appendCallVirtual(THROW_EXCEPTION_NAME, THROW_EXCEPTION_SIGNATURE);
        mb.targetNext(ifgood);
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_contents.size() > 0) {
            for (int i = 0; i < this.m_contents.size(); ++i) {
                IComponent content = (IComponent)this.m_contents.get(i);
                content.genContentMarshal(mb);
            }
        } else {
            throw new IllegalStateException("Internal error - no content present");
        }
    }

    public String getType() {
        if (this.m_hasObject) {
            return super.getType();
        }
        if (this.m_attributes != null && this.m_attributes.size() > 0) {
            return ((IComponent)this.m_attributes.get(0)).getType();
        }
        if (this.m_contents.size() > 0) {
            return ((IComponent)this.m_contents.get(0)).getType();
        }
        throw new IllegalStateException("Internal error - no type defined for structure");
    }

    public boolean hasId() {
        return this.m_idChild != null;
    }

    public void genLoadId(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_idChild == null) {
            throw new IllegalStateException("No ID child defined");
        }
        this.m_idChild.genLoadId(mb);
    }

    public void setLinkages() throws JiBXException {
        if (!this.m_isLinked) {
            this.m_isLinked = true;
            int i = 0;
            while (i < this.m_contents.size()) {
                IComponent comp = (IComponent)this.m_contents.get(i);
                comp.setLinkages();
                if (comp.hasAttribute()) {
                    if (this.m_attributes == null) {
                        this.m_attributes = new ArrayList();
                    }
                    this.m_attributes.add(comp);
                }
                if (!comp.hasContent()) {
                    this.m_contents.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    public void print(int depth) {
        IComponent comp;
        int i;
        BindingDefinition.indent(depth);
        System.out.print("structure " + (this.m_isChoice ? "choice" : (this.m_isOrdered ? "ordered" : "unordered")));
        if (this.m_allowDuplicates) {
            System.out.print(", duplicates allowed");
        }
        if (this.isFlexible()) {
            System.out.print(", flexible");
        }
        if (this.m_idChild != null) {
            System.out.print(" (ID)");
        }
        System.out.println();
        for (i = 0; i < this.m_contents.size(); ++i) {
            comp = (IComponent)this.m_contents.get(i);
            comp.print(depth + 1);
        }
        if (this.m_attributes != null) {
            for (i = 0; i < this.m_attributes.size(); ++i) {
                comp = (IComponent)this.m_attributes.get(i);
                comp.print(depth + 1);
            }
        }
    }
}

