/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.jibx.binding.classes.BranchTarget;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.NestedBase;
import org.jibx.runtime.JiBXException;

public class NestedStructure
extends NestedBase {
    private IComponent m_idChild;
    protected final boolean m_isChoice;
    private final boolean m_hasObject;
    private boolean m_isLinked;

    public NestedStructure(IContainer parent, IContextObj objc, boolean ord, boolean choice, boolean ctx, boolean hasobj) {
        super(parent, objc, ord, ctx);
        this.m_isChoice = choice;
        this.m_hasObject = hasobj;
    }

    public boolean hasAttribute() {
        return this.m_attributes != null && this.m_attributes.size() > 0;
    }

    public void genAttrPresentTest(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_attributes != null && this.m_attributes.size() > 0) {
            int count = this.m_attributes.size();
            if (count == 1) {
                ((IComponent)this.m_attributes.get(0)).genAttrPresentTest(mb);
            } else {
                BranchWrapper[] tofound = new BranchWrapper[count];
                for (int i = 0; i < count; ++i) {
                    IComponent comp = (IComponent)this.m_attributes.get(i);
                    comp.genAttrPresentTest(mb);
                    tofound[i] = mb.appendIFNE(this);
                }
                mb.appendICONST_0();
                BranchWrapper toend = mb.appendUnconditionalBranch(this);
                for (int i = 0; i < count; ++i) {
                    mb.targetNext(tofound[i]);
                }
                mb.appendICONST_1();
                mb.targetNext(toend);
            }
        } else {
            throw new IllegalStateException("Internal error - no attributes present");
        }
    }

    public void genAttributeUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_attributes != null && this.m_attributes.size() > 0) {
            for (int i = 0; i < this.m_attributes.size(); ++i) {
                IComponent attr = (IComponent)this.m_attributes.get(i);
                attr.genAttributeUnmarshal(mb);
            }
        } else {
            throw new IllegalStateException("Internal error - no attributes present");
        }
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_attributes != null && this.m_attributes.size() > 0) {
            for (int i = 0; i < this.m_attributes.size(); ++i) {
                IComponent attr = (IComponent)this.m_attributes.get(i);
                attr.genAttributeMarshal(mb);
            }
        } else {
            throw new IllegalStateException("Internal error - no attributes present");
        }
    }

    public boolean hasContent() {
        return this.m_contents.size() > 0;
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_contents.size() > 0) {
            if (this.m_isOrdered) {
                for (int i = 0; i < this.m_contents.size(); ++i) {
                    IComponent child = (IComponent)this.m_contents.get(i);
                    child.genContentUnmarshal(mb);
                }
            } else {
                BranchWrapper link = null;
                BranchTarget first = mb.appendTargetNOP();
                int count = this.m_contents.size();
                BranchWrapper[] toends = this.m_isChoice ? new BranchWrapper[count + 1] : new BranchWrapper[1];
                for (int i = 0; i < count; ++i) {
                    if (link != null) {
                        mb.targetNext(link);
                    }
                    IComponent child = (IComponent)this.m_contents.get(i);
                    child.genContentPresentTest(mb);
                    link = mb.appendIFEQ(this);
                    child.genContentUnmarshal(mb);
                    BranchWrapper next = mb.appendUnconditionalBranch(this);
                    if (this.m_isChoice) {
                        toends[i + 1] = next;
                        continue;
                    }
                    next.setTarget(first, mb);
                }
                toends[0] = link;
                mb.targetNext(toends);
            }
        } else {
            throw new IllegalStateException("Internal error - no content present");
        }
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_contents.size() > 0) {
            for (int i = 0; i < this.m_contents.size(); ++i) {
                IComponent content = (IComponent)this.m_contents.get(i);
                content.genContentMarshal(mb);
            }
        } else {
            throw new IllegalStateException("Internal error - no content present");
        }
    }

    public String getType() {
        if (this.m_hasObject) {
            return super.getType();
        }
        if (this.m_attributes != null && this.m_attributes.size() > 0) {
            return ((IComponent)this.m_attributes.get(0)).getType();
        }
        if (this.m_contents.size() > 0) {
            return ((IComponent)this.m_contents.get(0)).getType();
        }
        throw new IllegalStateException("Internal error - no type defined for structure");
    }

    public boolean hasId() {
        return this.m_idChild != null;
    }

    public void genLoadId(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_idChild == null) {
            throw new IllegalStateException("No ID child defined");
        }
        this.m_idChild.genLoadId(mb);
    }

    public boolean checkContentSequence(boolean text) throws JiBXException {
        for (int i = 0; i < this.m_contents.size(); ++i) {
            IComponent content = (IComponent)this.m_contents.get(i);
            text = content.checkContentSequence(text);
        }
        return text;
    }

    public void setLinkages() throws JiBXException {
        if (!this.m_isLinked) {
            this.m_isLinked = true;
            int i = 0;
            while (i < this.m_contents.size()) {
                IComponent comp = (IComponent)this.m_contents.get(i);
                comp.setLinkages();
                if (comp.hasAttribute()) {
                    if (this.m_attributes == null) {
                        this.m_attributes = new ArrayList();
                    }
                    this.m_attributes.add(comp);
                }
                if (!comp.hasContent()) {
                    this.m_contents.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    public void print(int depth) {
        IComponent comp;
        int i;
        BindingDefinition.indent(depth);
        System.out.print("structure " + (this.m_isChoice ? "choice" : (this.m_isOrdered ? "ordered" : "unordered")));
        if (this.m_idChild != null) {
            System.out.print(" (ID)");
        }
        System.out.println();
        for (i = 0; i < this.m_contents.size(); ++i) {
            comp = (IComponent)this.m_contents.get(i);
            comp.print(depth + 1);
        }
        if (this.m_attributes != null) {
            for (i = 0; i < this.m_attributes.size(); ++i) {
                comp = (IComponent)this.m_attributes.get(i);
                comp.print(depth + 1);
            }
        }
    }
}

